; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve2-aes < %s | FileCheck %s
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve,+sve-aes < %s | FileCheck %s
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve,+ssve-aes < %s | FileCheck %s
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sme,+ssve-aes -force-streaming < %s | FileCheck %s

;
; AESD
;

define <vscale x 16 x i8> @aesd_i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: aesd_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    aesd z0.b, z0.b, z1.b
; CHECK-NEXT:    ret
  %out = call <vscale x 16 x i8> @llvm.aarch64.sve.aesd(<vscale x 16 x i8> %a,
                                                        <vscale x 16 x i8> %b)
  ret <vscale x 16 x i8> %out
}

define <vscale x 16 x i8> @aesd_i8_commuted(<vscale x 16 x i8> %a,
; CHECK-LABEL: aesd_i8_commuted:
; CHECK:       // %bb.0:
; CHECK-NEXT:    aesd z0.b, z0.b, z1.b
; CHECK-NEXT:    ret
                                            <vscale x 16 x i8> %b) {
  %out = call <vscale x 16 x i8> @llvm.aarch64.sve.aesd(<vscale x 16 x i8> %b,
                                                        <vscale x 16 x i8> %a)
  ret <vscale x 16 x i8> %out
}

;
; AESIMC
;

define <vscale x 16 x i8> @aesimc_i8(<vscale x 16 x i8> %a) {
; CHECK-LABEL: aesimc_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    aesimc z0.b, z0.b
; CHECK-NEXT:    ret
  %out = call <vscale x 16 x i8> @llvm.aarch64.sve.aesimc(<vscale x 16 x i8> %a)
  ret <vscale x 16 x i8> %out
}

;
; AESE
;

define <vscale x 16 x i8> @aese_i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) {
; CHECK-LABEL: aese_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    aese z0.b, z0.b, z1.b
; CHECK-NEXT:    ret
  %out = call <vscale x 16 x i8> @llvm.aarch64.sve.aese(<vscale x 16 x i8> %a,
                                                        <vscale x 16 x i8> %b)
  ret <vscale x 16 x i8> %out
}

define <vscale x 16 x i8> @aese_i8_commuted(<vscale x 16 x i8> %a,
; CHECK-LABEL: aese_i8_commuted:
; CHECK:       // %bb.0:
; CHECK-NEXT:    aese z0.b, z0.b, z1.b
; CHECK-NEXT:    ret
                                            <vscale x 16 x i8> %b) {
  %out = call <vscale x 16 x i8> @llvm.aarch64.sve.aese(<vscale x 16 x i8> %b,
                                                        <vscale x 16 x i8> %a)
  ret <vscale x 16 x i8> %out
}

;
; AESMC
;

define <vscale x 16 x i8> @aesmc_i8(<vscale x 16 x i8> %a) {
; CHECK-LABEL: aesmc_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    aesmc z0.b, z0.b
; CHECK-NEXT:    ret
  %out = call <vscale x 16 x i8> @llvm.aarch64.sve.aesmc(<vscale x 16 x i8> %a)
  ret <vscale x 16 x i8> %out
}

declare <vscale x 16 x i8> @llvm.aarch64.sve.aesd(<vscale x 16 x i8>, <vscale x 16 x i8>)
declare <vscale x 16 x i8> @llvm.aarch64.sve.aesimc(<vscale x 16 x i8>)
declare <vscale x 16 x i8> @llvm.aarch64.sve.aese(<vscale x 16 x i8>, <vscale x 16 x i8>)
declare <vscale x 16 x i8> @llvm.aarch64.sve.aesmc(<vscale x 16 x i8>)
