#!/usr/bin/perl

package eBay::API::XML::Call::SetPictureManagerDetails::SetPictureManagerDetailsRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetPictureManagerDetailsRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetPictureManagerDetails::SetPictureManagerDetailsRequestType

=head1 DESCRIPTION

Creates, updates, or deletes Picture Manager account settings, folders, or pictures.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetPictureManagerDetails::SetPictureManagerDetailsRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::PictureManagerDetailsType;
use eBay::API::XML::DataType::Enum::PictureManagerActionCodeType;


my @gaProperties = ( [ 'Action', 'ns:PictureManagerActionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PictureManagerActionCodeType', '' ]
	, [ 'PictureManagerDetails', 'ns:PictureManagerDetailsType', ''
	     ,'eBay::API::XML::DataType::PictureManagerDetailsType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAction()

Specifies the action to take on the setting, folder, or picture.
The values Add and Delete apply only to folders.

  RequiredInput: Yes
#    Argument: 'ns:PictureManagerActionCodeType'

=cut

sub setAction {
  my $self = shift;
  $self->{'Action'} = shift
}

=head2 getAction()

#    Returns: 'ns:PictureManagerActionCodeType'

=cut

sub getAction {
  my $self = shift;
  return $self->{'Action'};
}


=head2 setPictureManagerDetails()

Specifies the setting or folder to create, update, or delete, or the
picture to update. You cannot upload or delete pictures using
SetPictureManagerDetails; you must use the eBay site.

  RequiredInput: Yes
#    Argument: 'ns:PictureManagerDetailsType'

=cut

sub setPictureManagerDetails {
  my $self = shift;
  $self->{'PictureManagerDetails'} = shift
}

=head2 getPictureManagerDetails()

#    Returns: 'ns:PictureManagerDetailsType'

=cut

sub getPictureManagerDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PictureManagerDetails'
		,'eBay::API::XML::DataType::PictureManagerDetailsType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
