/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLContextItem
extends StyleElement {
    private ItemType requiredType = AnyItemType.getInstance();
    private boolean mayBeOmitted = true;
    private boolean absentFocus = false;

    public void prepareAttributes() throws XPathException {
        String asAtt = null;
        String useAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("as")) {
                asAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use")) {
                useAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (asAtt != null) {
            SequenceType st;
            try {
                st = this.makeSequenceType(asAtt);
            }
            catch (XPathException e) {
                st = SequenceType.SINGLE_ITEM;
                this.compileErrorInAttribute(e.getMessage(), e.getErrorCodeLocalPart(), "as");
            }
            if (st.getCardinality() != 16384) {
                this.compileError("The xsl:context-item/@use attribute must be an item type (no occurrence indicator allowed)", "XTSE0020");
                return;
            }
            this.requiredType = st.getPrimaryType();
        }
        if (useAtt != null) {
            if (useAtt.equals("required")) {
                this.mayBeOmitted = false;
            } else if (!useAtt.equals("optional")) {
                if (useAtt.equals("absent")) {
                    this.absentFocus = true;
                } else {
                    this.invalidAttribute("use", "required|optional|absent");
                }
            }
        }
        if (asAtt != null && this.absentFocus) {
            this.compileError("The 'as' attribute must be omitted when use='absent' is specified", "XTSE3089");
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo prec;
        if (!(this.getParent() instanceof XSLTemplate)) {
            this.compileError("xsl:context-item can appear only as a child of xsl:template");
            return;
        }
        if (this.mayBeOmitted && ((XSLTemplate)this.getParent()).getTemplateName() == null) {
            this.compileError("xsl:context-item appearing in an xsl:template declaration with no name attribute must specify use=required", "XTSE0020");
        }
        ((XSLTemplate)this.getParent()).setContextItemRequirements(this.requiredType, this.mayBeOmitted, this.absentFocus);
        AxisIterator precSib = this.iterateAxis((byte)11);
        while ((prec = precSib.next()) != null) {
            if (prec.getNodeKind() == 3 && Whitespace.isWhite(prec.getStringValueCS())) continue;
            this.compileError("xsl:context-item must be the first child of xsl:template");
        }
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredType;
    }

    public boolean isMayBeOmitted() {
        return this.mayBeOmitted;
    }

    public boolean isAbsentFocus() {
        return this.absentFocus;
    }
}

