package Tags::HTML::Element;

use strict;
use warnings;

our $VERSION = 0.09;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Data::HTML::Element - Tags helpers for HTML elements.

=head1 SEE ALSO

=over

=item L<Tags::HTML::Element::A>

Tags helper for HTML a element.

=item L<Tags::HTML::Element::Button>

Tags helper for HTML button element.

=item L<Tags::HTML::Element::Form>

Tags helper for HTML form element.

=item L<Tags::HTML::Element::Input>

Tags helper for HTML input element.

=item L<Tags::HTML::Element::Option>

Tags helper for HTML option element.

=item L<Tags::HTML::Element::Select>

Tags helper for HTML select element.

=item L<Tags::HTML::Element::Textarea>

Tags helper for HTML textarea element.

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Tags-HTML-Element>

=head1 AUTHOR

Michal Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© 2022-2024 Michal Josef Špaček

BSD 2-Clause License

=head1 VERSION

0.09

=cut
