# Generated by default/object.tt
package Paws::SecurityHub::AwsCertificateManagerCertificateDetails;
  use Moose;
  has CertificateAuthorityArn => (is => 'ro', isa => 'Str');
  has CreatedAt => (is => 'ro', isa => 'Str');
  has DomainName => (is => 'ro', isa => 'Str');
  has DomainValidationOptions => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsCertificateManagerCertificateDomainValidationOption]');
  has ExtendedKeyUsages => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsCertificateManagerCertificateExtendedKeyUsage]');
  has FailureReason => (is => 'ro', isa => 'Str');
  has ImportedAt => (is => 'ro', isa => 'Str');
  has InUseBy => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has IssuedAt => (is => 'ro', isa => 'Str');
  has Issuer => (is => 'ro', isa => 'Str');
  has KeyAlgorithm => (is => 'ro', isa => 'Str');
  has KeyUsages => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsCertificateManagerCertificateKeyUsage]');
  has NotAfter => (is => 'ro', isa => 'Str');
  has NotBefore => (is => 'ro', isa => 'Str');
  has Options => (is => 'ro', isa => 'Paws::SecurityHub::AwsCertificateManagerCertificateOptions');
  has RenewalEligibility => (is => 'ro', isa => 'Str');
  has RenewalSummary => (is => 'ro', isa => 'Paws::SecurityHub::AwsCertificateManagerCertificateRenewalSummary');
  has Serial => (is => 'ro', isa => 'Str');
  has SignatureAlgorithm => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has Subject => (is => 'ro', isa => 'Str');
  has SubjectAlternativeNames => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsCertificateManagerCertificateDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsCertificateManagerCertificateDetails object:

  $service_obj->Method(Att1 => { CertificateAuthorityArn => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsCertificateManagerCertificateDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->CertificateAuthorityArn

=head1 DESCRIPTION

Provides details about an AWS Certificate Manager certificate.

=head1 ATTRIBUTES


=head2 CertificateAuthorityArn => Str

The ARN of the private certificate authority (CA) that will be used to
issue the certificate.


=head2 CreatedAt => Str

Indicates when the certificate was requested.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 DomainName => Str

The fully qualified domain name (FQDN), such as www.example.com, that
is secured by the certificate.


=head2 DomainValidationOptions => ArrayRef[L<Paws::SecurityHub::AwsCertificateManagerCertificateDomainValidationOption>]

Contains information about the initial validation of each domain name
that occurs as a result of the C<RequestCertificate> request.

Only provided if the certificate type is C<AMAZON_ISSUED>.


=head2 ExtendedKeyUsages => ArrayRef[L<Paws::SecurityHub::AwsCertificateManagerCertificateExtendedKeyUsage>]

Contains a list of Extended Key Usage X.509 v3 extension objects. Each
object specifies a purpose for which the certificate public key can be
used and consists of a name and an object identifier (OID).


=head2 FailureReason => Str

For a failed certificate request, the reason for the failure.

Valid values: C<NO_AVAILABLE_CONTACTS> |
C<ADDITIONAL_VERIFICATION_REQUIRED> | C<DOMAIN_NOT_ALLOWED> |
C<INVALID_PUBLIC_DOMAIN> | C<DOMAIN_VALIDATION_DENIED> | C<CAA_ERROR> |
C<PCA_LIMIT_EXCEEDED> | C<PCA_INVALID_ARN> | C<PCA_INVALID_STATE> |
C<PCA_REQUEST_FAILED> | C<PCA_NAME_CONSTRAINTS_VALIDATION> |
C<PCA_RESOURCE_NOT_FOUND> | C<PCA_INVALID_ARGS> |
C<PCA_INVALID_DURATION> | C<PCA_ACCESS_DENIED> | C<SLR_NOT_FOUND> |
C<OTHER>


=head2 ImportedAt => Str

Indicates when the certificate was imported. Provided if the
certificate type is C<IMPORTED>.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 InUseBy => ArrayRef[Str|Undef]

The list of ARNs for the AWS resources that use the certificate.


=head2 IssuedAt => Str

Indicates when the certificate was issued. Provided if the certificate
type is C<AMAZON_ISSUED>.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 Issuer => Str

The name of the certificate authority that issued and signed the
certificate.


=head2 KeyAlgorithm => Str

The algorithm that was used to generate the public-private key pair.

Valid values: C<RSA_2048> | C<RSA_1024> |C< RSA_4096> |
C<EC_prime256v1> | C<EC_secp384r1> | C<EC_secp521r1>


=head2 KeyUsages => ArrayRef[L<Paws::SecurityHub::AwsCertificateManagerCertificateKeyUsage>]

A list of key usage X.509 v3 extension objects.


=head2 NotAfter => Str

The time after which the certificate becomes invalid.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 NotBefore => Str

The time before which the certificate is not valid.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 Options => L<Paws::SecurityHub::AwsCertificateManagerCertificateOptions>

Provides a value that specifies whether to add the certificate to a
transparency log.


=head2 RenewalEligibility => Str

Whether the certificate is eligible for renewal.

Valid values: C<ELIGIBLE> | C<INELIGIBLE>


=head2 RenewalSummary => L<Paws::SecurityHub::AwsCertificateManagerCertificateRenewalSummary>

Information about the status of the AWS Certificate Manager managed
renewal for the certificate. Provided only when the certificate type is
C<AMAZON_ISSUED>.


=head2 Serial => Str

The serial number of the certificate.


=head2 SignatureAlgorithm => Str

The algorithm that was used to sign the certificate.


=head2 Status => Str

The status of the certificate.

Valid values: C<PENDING_VALIDATION> | C<ISSUED> | C<INACTIVE> |
C<EXPIRED> | C<VALIDATION_TIMED_OUT> | C<REVOKED> | C<FAILED>


=head2 Subject => Str

The name of the entity that is associated with the public key contained
in the certificate.


=head2 SubjectAlternativeNames => ArrayRef[Str|Undef]

One or more domain names (subject alternative names) included in the
certificate. This list contains the domain names that are bound to the
public key that is contained in the certificate.

The subject alternative names include the canonical domain name (CN) of
the certificate and additional domain names that can be used to connect
to the website.


=head2 Type => Str

The source of the certificate. For certificates that AWS Certificate
Manager provides, C<Type> is C<AMAZON_ISSUED>. For certificates that
are imported with C<ImportCertificate>, C<Type> is C<IMPORTED>.

Valid values: C<IMPORTED> | C<AMAZON_ISSUED> | C<PRIVATE>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

