# Generated by default/object.tt
package Paws::Proton::Service;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest'], required => 1);
  has BranchName => (is => 'ro', isa => 'Str', request_name => 'branchName', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest'], required => 1);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has LastModifiedAt => (is => 'ro', isa => 'Str', request_name => 'lastModifiedAt', traits => ['NameInRequest'], required => 1);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has Pipeline => (is => 'ro', isa => 'Paws::Proton::ServicePipeline', request_name => 'pipeline', traits => ['NameInRequest']);
  has RepositoryConnectionArn => (is => 'ro', isa => 'Str', request_name => 'repositoryConnectionArn', traits => ['NameInRequest']);
  has RepositoryId => (is => 'ro', isa => 'Str', request_name => 'repositoryId', traits => ['NameInRequest']);
  has Spec => (is => 'ro', isa => 'Str', request_name => 'spec', traits => ['NameInRequest'], required => 1);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest'], required => 1);
  has StatusMessage => (is => 'ro', isa => 'Str', request_name => 'statusMessage', traits => ['NameInRequest']);
  has TemplateName => (is => 'ro', isa => 'Str', request_name => 'templateName', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Proton::Service

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Proton::Service object:

  $service_obj->Method(Att1 => { Arn => $value, ..., TemplateName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Proton::Service object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The service detail data.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

The Amazon Resource Name (ARN) of the service.


=head2 BranchName => Str

The name of the code repository branch that holds the code that's
deployed in AWS Proton.


=head2 B<REQUIRED> CreatedAt => Str

The time when the service was created.


=head2 Description => Str

A description of a service.


=head2 B<REQUIRED> LastModifiedAt => Str

The time when the service was last modified.


=head2 B<REQUIRED> Name => Str

The name of the service.


=head2 Pipeline => L<Paws::Proton::ServicePipeline>

The service pipeline detail data.


=head2 RepositoryConnectionArn => Str

The ARN of the repository connection. For more information, see Set up
a repository connection
(https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol)
in the I<AWS Proton Administration Guide> and Getting started
(https://docs.aws.amazon.com/proton/latest/userguide/ug-getting-started.html#getting-started-step1)
in the I<AWS Proton User Guide>.


=head2 RepositoryId => Str

The ID of the code repository.


=head2 B<REQUIRED> Spec => Str

The formatted specification that defines the service.


=head2 B<REQUIRED> Status => Str

The status of the service.


=head2 StatusMessage => Str

A service status message.


=head2 B<REQUIRED> TemplateName => Str

The name of the service template.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Proton>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

