/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.guide.decision;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureModel;
import org.maltparser.core.feature.FeatureVector;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.guide.ClassifierGuide;
import org.maltparser.parser.guide.GuideException;
import org.maltparser.parser.guide.decision.DecisionModel;
import org.maltparser.parser.guide.decision.OneDecisionModel;
import org.maltparser.parser.guide.decision.SeqDecisionModel;
import org.maltparser.parser.guide.instance.AtomicModel;
import org.maltparser.parser.guide.instance.FeatureDivideModel;
import org.maltparser.parser.guide.instance.InstanceModel;
import org.maltparser.parser.history.action.GuideDecision;
import org.maltparser.parser.history.action.MultipleDecision;
import org.maltparser.parser.history.action.SingleDecision;
import org.maltparser.parser.history.container.TableContainer;

public class BranchedDecisionModel
implements DecisionModel {
    private ClassifierGuide guide;
    private String modelName;
    private FeatureModel featureModel;
    private InstanceModel instanceModel;
    private int decisionIndex;
    private DecisionModel parentDecisionModel;
    private HashMap<Integer, DecisionModel> children;
    private String branchedDecisionSymbols;

    public BranchedDecisionModel(ClassifierGuide guide, FeatureModel featureModel) throws MaltChainedException {
        this.branchedDecisionSymbols = "";
        this.setGuide(guide);
        this.setFeatureModel(featureModel);
        this.setDecisionIndex(0);
        this.setModelName("bdm" + this.decisionIndex);
        this.setParentDecisionModel(null);
    }

    public BranchedDecisionModel(ClassifierGuide guide, DecisionModel parentDecisionModel, String branchedDecisionSymbol) throws MaltChainedException {
        this.branchedDecisionSymbols = branchedDecisionSymbol != null && branchedDecisionSymbol.length() > 0 ? branchedDecisionSymbol : "";
        this.setGuide(guide);
        this.setParentDecisionModel(parentDecisionModel);
        this.setDecisionIndex(parentDecisionModel.getDecisionIndex() + 1);
        this.setFeatureModel(parentDecisionModel.getFeatureModel());
        if (this.branchedDecisionSymbols != null && this.branchedDecisionSymbols.length() > 0) {
            this.setModelName("bdm" + this.decisionIndex + this.branchedDecisionSymbols);
        } else {
            this.setModelName("bdm" + this.decisionIndex);
        }
        this.parentDecisionModel = parentDecisionModel;
    }

    public void updateFeatureModel() throws MaltChainedException {
        this.featureModel.update();
    }

    public void updateCardinality() throws MaltChainedException {
        this.featureModel.updateCardinality();
    }

    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
        if (this.instanceModel != null) {
            this.instanceModel.finalizeSentence(dependencyGraph);
        }
        if (this.children != null) {
            for (DecisionModel child : this.children.values()) {
                child.finalizeSentence(dependencyGraph);
            }
        }
    }

    public void noMoreInstances() throws MaltChainedException {
        if (this.guide.getGuideMode() == ClassifierGuide.GuideMode.CLASSIFY) {
            throw new GuideException("The decision model could not create it's model. ");
        }
        this.featureModel.updateCardinality();
        if (this.instanceModel != null) {
            this.instanceModel.noMoreInstances();
            this.instanceModel.train();
        }
        if (this.children != null) {
            for (DecisionModel child : this.children.values()) {
                child.noMoreInstances();
            }
        }
    }

    public void terminate() throws MaltChainedException {
        if (this.instanceModel != null) {
            this.instanceModel.terminate();
            this.instanceModel = null;
        }
        if (this.children != null) {
            for (DecisionModel child : this.children.values()) {
                child.terminate();
            }
        }
    }

    public void addInstance(GuideDecision decision) throws MaltChainedException {
        if (decision instanceof SingleDecision) {
            throw new GuideException("A branched decision model expect more than one decisions. ");
        }
        this.updateFeatureModel();
        SingleDecision singleDecision = ((MultipleDecision)decision).getSingleDecision(this.decisionIndex);
        if (this.instanceModel == null) {
            this.initInstanceModel(singleDecision.getTableContainer().getTableContainerName());
        }
        this.instanceModel.addInstance(singleDecision);
        if (this.decisionIndex + 1 < decision.numberOfDecisions() && singleDecision.continueWithNextDecision()) {
            DecisionModel child;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((child = this.children.get(singleDecision.getDecisionCode())) == null) {
                child = this.initChildDecisionModel(((MultipleDecision)decision).getSingleDecision(this.decisionIndex + 1), this.branchedDecisionSymbols + (this.branchedDecisionSymbols.length() == 0 ? "" : "_") + singleDecision.getDecisionSymbol());
                this.children.put(singleDecision.getDecisionCode(), child);
            }
            child.addInstance(decision);
        }
    }

    public boolean predict(GuideDecision decision) throws MaltChainedException {
        if (decision instanceof SingleDecision) {
            throw new GuideException("A branched decision model expect more than one decisions. ");
        }
        this.updateFeatureModel();
        SingleDecision singleDecision = ((MultipleDecision)decision).getSingleDecision(this.decisionIndex);
        if (this.instanceModel == null) {
            this.initInstanceModel(singleDecision.getTableContainer().getTableContainerName());
        }
        this.instanceModel.predict(singleDecision);
        if (this.decisionIndex + 1 < decision.numberOfDecisions() && singleDecision.continueWithNextDecision()) {
            DecisionModel child;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((child = this.children.get(singleDecision.getDecisionCode())) == null) {
                child = this.initChildDecisionModel(((MultipleDecision)decision).getSingleDecision(this.decisionIndex + 1), this.branchedDecisionSymbols + (this.branchedDecisionSymbols.length() == 0 ? "" : "_") + singleDecision.getDecisionSymbol());
                this.children.put(singleDecision.getDecisionCode(), child);
            }
            child.predict(decision);
        }
        return true;
    }

    public FeatureVector predictExtract(GuideDecision decision) throws MaltChainedException {
        if (decision instanceof SingleDecision) {
            throw new GuideException("A branched decision model expect more than one decisions. ");
        }
        this.updateFeatureModel();
        SingleDecision singleDecision = ((MultipleDecision)decision).getSingleDecision(this.decisionIndex);
        if (this.instanceModel == null) {
            this.initInstanceModel(singleDecision.getTableContainer().getTableContainerName());
        }
        FeatureVector fv = this.instanceModel.predictExtract(singleDecision);
        if (this.decisionIndex + 1 < decision.numberOfDecisions() && singleDecision.continueWithNextDecision()) {
            DecisionModel child;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((child = this.children.get(singleDecision.getDecisionCode())) == null) {
                child = this.initChildDecisionModel(((MultipleDecision)decision).getSingleDecision(this.decisionIndex + 1), this.branchedDecisionSymbols + (this.branchedDecisionSymbols.length() == 0 ? "" : "_") + singleDecision.getDecisionSymbol());
                this.children.put(singleDecision.getDecisionCode(), child);
            }
            child.predictExtract(decision);
        }
        return fv;
    }

    public FeatureVector extract() throws MaltChainedException {
        this.updateFeatureModel();
        return this.instanceModel.extract();
    }

    public boolean predictFromKBestList(GuideDecision decision) throws MaltChainedException {
        DecisionModel child;
        if (decision instanceof SingleDecision) {
            throw new GuideException("A branched decision model expect more than one decisions. ");
        }
        boolean success = false;
        SingleDecision singleDecision = ((MultipleDecision)decision).getSingleDecision(this.decisionIndex);
        if (this.decisionIndex + 1 < decision.numberOfDecisions() && singleDecision.continueWithNextDecision()) {
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((child = this.children.get(singleDecision.getDecisionCode())) != null) {
                success = child.predictFromKBestList(decision);
            }
        }
        if (!success) {
            success = singleDecision.updateFromKBestList();
            if (this.decisionIndex + 1 < decision.numberOfDecisions() && singleDecision.continueWithNextDecision()) {
                if (this.children == null) {
                    this.children = new HashMap();
                }
                if ((child = this.children.get(singleDecision.getDecisionCode())) == null) {
                    child = this.initChildDecisionModel(((MultipleDecision)decision).getSingleDecision(this.decisionIndex + 1), this.branchedDecisionSymbols + (this.branchedDecisionSymbols.length() == 0 ? "" : "_") + singleDecision.getDecisionSymbol());
                    this.children.put(singleDecision.getDecisionCode(), child);
                }
                child.predict(decision);
            }
        }
        return success;
    }

    public ClassifierGuide getGuide() {
        return this.guide;
    }

    public String getModelName() {
        return this.modelName;
    }

    public FeatureModel getFeatureModel() {
        return this.featureModel;
    }

    public int getDecisionIndex() {
        return this.decisionIndex;
    }

    public DecisionModel getParentDecisionModel() {
        return this.parentDecisionModel;
    }

    private void setFeatureModel(FeatureModel featureModel) {
        this.featureModel = featureModel;
    }

    private void setDecisionIndex(int decisionIndex) {
        this.decisionIndex = decisionIndex;
    }

    private void setParentDecisionModel(DecisionModel parentDecisionModel) {
        this.parentDecisionModel = parentDecisionModel;
    }

    private void setModelName(String modelName) {
        this.modelName = modelName;
    }

    private void setGuide(ClassifierGuide guide) {
        this.guide = guide;
    }

    private DecisionModel initChildDecisionModel(SingleDecision decision, String branchedDecisionSymbol) throws MaltChainedException {
        Class decisionModelClass = null;
        if (decision.getRelationToNextDecision() == TableContainer.RelationToNextDecision.SEQUANTIAL) {
            decisionModelClass = SeqDecisionModel.class;
        } else if (decision.getRelationToNextDecision() == TableContainer.RelationToNextDecision.BRANCHED) {
            decisionModelClass = BranchedDecisionModel.class;
        } else if (decision.getRelationToNextDecision() == TableContainer.RelationToNextDecision.NONE) {
            decisionModelClass = OneDecisionModel.class;
        }
        if (decisionModelClass == null) {
            throw new GuideException("Could not find an appropriate decision model for the relation to the next decision");
        }
        try {
            Class[] argTypes = new Class[]{ClassifierGuide.class, DecisionModel.class, String.class};
            Object[] arguments = new Object[]{this.getGuide(), this, branchedDecisionSymbol};
            Constructor constructor = decisionModelClass.getConstructor(argTypes);
            return (DecisionModel)constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new GuideException("The decision model class '" + decisionModelClass.getName() + "' cannot be initialized. ", e);
        }
        catch (InstantiationException e) {
            throw new GuideException("The decision model class '" + decisionModelClass.getName() + "' cannot be initialized. ", e);
        }
        catch (IllegalAccessException e) {
            throw new GuideException("The decision model class '" + decisionModelClass.getName() + "' cannot be initialized. ", e);
        }
        catch (InvocationTargetException e) {
            throw new GuideException("The decision model class '" + decisionModelClass.getName() + "' cannot be initialized. ", e);
        }
    }

    private void initInstanceModel(String subModelName) throws MaltChainedException {
        DependencyParserConfig c;
        FeatureVector fv = this.featureModel.getFeatureVector(this.branchedDecisionSymbols + "." + subModelName);
        if (fv == null) {
            fv = this.featureModel.getFeatureVector(subModelName);
        }
        if (fv == null) {
            fv = this.featureModel.getMainFeatureVector();
        }
        this.instanceModel = (c = this.guide.getConfiguration()).getOptionValue("guide", "data_split_column").toString().length() == 0 ? new AtomicModel(-1, fv, this) : new FeatureDivideModel(fv, this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.modelName + ", ");
        for (DecisionModel model : this.children.values()) {
            sb.append(model.toString() + ", ");
        }
        return sb.toString();
    }
}

