/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import gnu.trove.TIntDoubleHashMap;
import java.io.IOException;
import java.util.StringTokenizer;
import opennlp.maxent.GISModel;

public abstract class GISModelReader {
    protected int NUM_PREDS;

    protected void checkModelType() throws IOException {
        String modelType = this.readUTF();
        if (!modelType.equals("GIS")) {
            System.out.println("Error: attempting to load a " + modelType + " model as a GIS model." + " You should expect problems.");
        }
    }

    protected int getCorrectionConstant() throws IOException {
        return this.readInt();
    }

    protected double getCorrectionParameter() throws IOException {
        return this.readDouble();
    }

    public GISModel getModel() throws IOException {
        this.checkModelType();
        int correctionConstant = this.getCorrectionConstant();
        double correctionParam = this.getCorrectionParameter();
        String[] outcomeLabels = this.getOutcomes();
        int[][] outcomePatterns = this.getOutcomePatterns();
        String[] predLabels = this.getPredicates();
        TIntDoubleHashMap[] params = this.getParameters(outcomePatterns);
        return new GISModel(params, predLabels, outcomeLabels, correctionConstant, correctionParam);
    }

    protected int[][] getOutcomePatterns() throws IOException {
        int numOCTypes = this.readInt();
        int[][] outcomePatterns = new int[numOCTypes][];
        int i = 0;
        while (i < numOCTypes) {
            StringTokenizer tok = new StringTokenizer(this.readUTF(), " ");
            int[] infoInts = new int[tok.countTokens()];
            int j = 0;
            while (tok.hasMoreTokens()) {
                infoInts[j] = Integer.parseInt(tok.nextToken());
                ++j;
            }
            outcomePatterns[i] = infoInts;
            ++i;
        }
        return outcomePatterns;
    }

    protected String[] getOutcomes() throws IOException {
        int numOutcomes = this.readInt();
        String[] outcomeLabels = new String[numOutcomes];
        int i = 0;
        while (i < numOutcomes) {
            outcomeLabels[i] = this.readUTF();
            ++i;
        }
        return outcomeLabels;
    }

    protected TIntDoubleHashMap[] getParameters(int[][] outcomePatterns) throws IOException {
        TIntDoubleHashMap[] params = new TIntDoubleHashMap[this.NUM_PREDS];
        int pid = 0;
        int i = 0;
        while (i < outcomePatterns.length) {
            int j = 0;
            while (j < outcomePatterns[i][0]) {
                params[pid] = new TIntDoubleHashMap();
                int k = 1;
                while (k < outcomePatterns[i].length) {
                    double d = this.readDouble();
                    params[pid].put(outcomePatterns[i][k], d);
                    ++k;
                }
                params[pid].compact();
                ++pid;
                ++j;
            }
            ++i;
        }
        return params;
    }

    protected String[] getPredicates() throws IOException {
        this.NUM_PREDS = this.readInt();
        String[] predLabels = new String[this.NUM_PREDS];
        int i = 0;
        while (i < this.NUM_PREDS) {
            predLabels[i] = this.readUTF();
            ++i;
        }
        return predLabels;
    }

    protected abstract double readDouble() throws IOException;

    protected abstract int readInt() throws IOException;

    protected abstract String readUTF() throws IOException;
}

