/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.NoOpAnnotator;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.fit.util.LifeCycleUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;

public class JCasIterator
implements Iterator<JCas> {
    private final CollectionReader collectionReader;
    private final AnalysisEngine[] analysisEngines;
    private final JCas jCas;
    private boolean selfComplete = false;
    private boolean selfDestroy = false;
    private boolean destroyed = false;

    public JCasIterator(CollectionReader aReader, AnalysisEngine ... aEngines) throws CASException, ResourceInitializationException {
        this.collectionReader = aReader;
        this.analysisEngines = aEngines;
        ArrayList<ProcessingResourceMetaData> metaData = new ArrayList<ProcessingResourceMetaData>();
        metaData.add(aReader.getProcessingResourceMetaData());
        for (AnalysisEngine ae : aEngines) {
            metaData.add(ae.getProcessingResourceMetaData());
        }
        ResourceManager resMgr = ResourceManagerFactory.newResourceManager();
        this.jCas = CasCreationUtils.createCas(metaData, null, resMgr).getJCas();
    }

    public JCasIterator(CollectionReader aReader, TypeSystemDescription aTypeSystemDescription) throws CASException, ResourceInitializationException {
        this(aReader, AnalysisEngineFactory.createEngine(NoOpAnnotator.class, aTypeSystemDescription, new Object[0]));
    }

    @Override
    public boolean hasNext() {
        if (this.destroyed) {
            return false;
        }
        boolean error = true;
        try {
            boolean hasOneMore = this.collectionReader.hasNext();
            error = false;
            boolean bl = hasOneMore;
            return bl;
        }
        catch (CollectionException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (error && this.selfDestroy) {
                this.destroy();
            }
        }
    }

    @Override
    public JCas next() {
        this.jCas.reset();
        boolean error = true;
        boolean destroyed = false;
        try {
            this.collectionReader.getNext(this.jCas.getCas());
            for (AnalysisEngine engine : this.analysisEngines) {
                engine.process(this.jCas);
            }
            if ((this.selfComplete || this.selfDestroy) && !this.hasNext()) {
                if (this.selfComplete) {
                    this.collectionProcessComplete();
                }
                if (this.selfDestroy) {
                    this.destroy();
                    destroyed = true;
                }
            }
            error = false;
        }
        catch (CollectionException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (AnalysisEngineProcessException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (error && this.selfDestroy && !destroyed) {
                this.destroy();
            }
        }
        return this.jCas;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        LifeCycleUtil.collectionProcessComplete(this.analysisEngines);
    }

    public void destroy() {
        if (!this.destroyed) {
            LifeCycleUtil.close(this.collectionReader);
            LifeCycleUtil.destroy(this.collectionReader);
            LifeCycleUtil.destroy(this.analysisEngines);
            this.destroyed = true;
        }
    }

    public boolean isSelfComplete() {
        return this.selfComplete;
    }

    public void setSelfComplete(boolean aSelfComplete) {
        this.selfComplete = aSelfComplete;
    }

    public boolean isSelfDestroy() {
        return this.selfDestroy;
    }

    public void setSelfDestroy(boolean aSelfDestroy) {
        this.selfDestroy = aSelfDestroy;
    }
}

