/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.DefaultLocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

@XmlType(name="MemberName_Type")
@XmlRootElement(name="MemberName")
public class DefaultMemberName
extends DefaultLocalName
implements MemberName {
    private static final long serialVersionUID = 7307683415489715298L;
    @XmlElement(required=true)
    private final TypeName attributeType;

    protected DefaultMemberName(NameSpace nameSpace, CharSequence charSequence, TypeName typeName) {
        super(nameSpace, charSequence);
        ArgumentChecks.ensureNonNull("attributeType", typeName);
        this.attributeType = typeName;
    }

    public static DefaultMemberName castOrCopy(MemberName memberName) {
        if (memberName == null || memberName instanceof DefaultMemberName) {
            return (DefaultMemberName)memberName;
        }
        return new DefaultMemberName(memberName.scope(), memberName.toInternationalString(), memberName.getAttributeType());
    }

    @Override
    public TypeName getAttributeType() {
        return this.attributeType;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && Objects.equals(this.attributeType, ((DefaultMemberName)object).attributeType);
    }

    @Override
    final int computeHashCode() {
        return super.computeHashCode() + Objects.hashCode(this.attributeType);
    }

    private DefaultMemberName() {
        this.attributeType = null;
    }
}

