/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.List;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.simple.CitationConstant;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.citation.Citation;

public final class Citations
extends Static {
    public static final List<Citation> ISO_19115 = UnmodifiableArrayList.wrap(new CitationConstant[]{new CitationConstant("ISO 19115-1"), new CitationConstant("ISO 19115-2")});
    static final Citation IOGP = new CitationConstant("IOGP");
    public static final IdentifierSpace<Integer> EPSG = new CitationConstant.Authority<Integer>("EPSG");
    public static final IdentifierSpace<Integer> WMS = new WMS();
    public static final IdentifierSpace<String> OGC = new CitationConstant.Authority<String>("OGC");
    public static final IdentifierSpace<String> ESRI = new CitationConstant.Authority<String>("ESRI");
    public static final IdentifierSpace<String> NETCDF = new CitationConstant.Authority<String>("NetCDF");
    public static final IdentifierSpace<Integer> GEOTIFF = new CitationConstant.Authority<Integer>("GeoTIFF");
    public static final IdentifierSpace<String> PROJ4 = new CitationConstant.Authority<String>("Proj4");
    public static final IdentifierSpace<Integer> MAP_INFO = new CitationConstant.Authority<Integer>("MapInfo");
    public static final IdentifierSpace<Integer> S57 = new CitationConstant.Authority<Integer>("S57");
    public static final IdentifierSpace<String> ISBN = new NonMarshalledAuthority<String>("ISBN", 5);
    public static final IdentifierSpace<String> ISSN = new NonMarshalledAuthority<String>("ISSN", 4);
    public static final Citation SIS = new CitationConstant("SIS");
    private static final CitationConstant[] CITATIONS = new CitationConstant[]{(CitationConstant)((Object)EPSG), (CitationConstant)((Object)WMS), (CitationConstant)((Object)OGC), (CitationConstant)((Object)ESRI), (CitationConstant)((Object)NETCDF), (CitationConstant)((Object)GEOTIFF), (CitationConstant)((Object)PROJ4), (CitationConstant)((Object)MAP_INFO), (CitationConstant)((Object)S57), (CitationConstant)((Object)ISBN), (CitationConstant)((Object)ISSN), (CitationConstant)SIS, (CitationConstant)ISO_19115.get(0), (CitationConstant)ISO_19115.get(1), (CitationConstant)IOGP};

    private Citations() {
    }

    static void refresh() {
        for (CitationConstant citationConstant : CITATIONS) {
            citationConstant.refresh();
        }
    }

    public static Citation fromName(String string) {
        if (string == null || (string = CharSequences.trimWhitespaces(string)).isEmpty()) {
            return null;
        }
        for (CitationConstant citationConstant : CITATIONS) {
            if (!org.apache.sis.internal.util.Citations.equalsFiltered(string, citationConstant.title)) continue;
            return citationConstant;
        }
        if (org.apache.sis.internal.util.Citations.equalsFiltered(string, "OGP")) {
            return IOGP;
        }
        if (org.apache.sis.internal.util.Citations.equalsFiltered(string, "CRS")) {
            return WMS;
        }
        return new SimpleCitation(string);
    }

    public static boolean titleMatches(Citation citation, Citation citation2) {
        return org.apache.sis.internal.util.Citations.titleMatches(citation, citation2);
    }

    public static boolean titleMatches(Citation citation, String string) {
        return org.apache.sis.internal.util.Citations.titleMatches(citation, string);
    }

    public static boolean identifierMatches(Citation citation, Citation citation2) {
        return org.apache.sis.internal.util.Citations.identifierMatches(citation, citation2);
    }

    public static boolean identifierMatches(Citation citation, String string) {
        return org.apache.sis.internal.util.Citations.identifierMatches(citation, null, string);
    }

    public static String getIdentifier(Citation citation) {
        return org.apache.sis.internal.util.Citations.getIdentifier(citation, false);
    }

    public static String getUnicodeIdentifier(Citation citation) {
        return org.apache.sis.internal.util.Citations.getUnicodeIdentifier(citation);
    }

    public static String getCodeSpace(Citation citation) {
        if (citation instanceof IdentifierSpace) {
            return ((IdentifierSpace)citation).getName();
        }
        return Citations.getUnicodeIdentifier(citation);
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.metadata"){

            @Override
            protected void classpathChanged() {
                Citations.refresh();
            }

            @Override
            protected void databaseChanged() {
                Citations.refresh();
            }
        });
    }

    private static final class WMS
    extends CitationConstant.Authority<Integer> {
        private static final long serialVersionUID = -8490156477724003085L;

        WMS() {
            super("WMS");
        }

        @Override
        public String getName() {
            return "OGC";
        }
    }
}

