/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.internal.util.XPaths;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.UnitDimension;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.resources.Errors;

public class UnitFormat
extends Format
implements javax.measure.format.UnitFormat,
Localized {
    private static final long serialVersionUID = -3064428584419360693L;
    private static final String DEGREES = "degrees";
    static final String UNITY = "unity";
    static final String DECA = "da";
    static final UnitFormat INSTANCE = new UnitFormat();
    private Locale locale;
    private Style style;
    private final Map<Unit<?>, String> unitToLabel;
    private final Map<String, Unit<?>> labelToUnit;
    private volatile transient ResourceBundle symbolToName;
    private volatile transient Map<String, Unit<?>> nameToUnit;
    private static final WeakValueHashMap<Locale, Map<String, Unit<?>>> SHARED = new WeakValueHashMap(Locale.class);
    private static final int NOOP = 0;
    private static final int IMPLICIT = 1;
    private static final int MULTIPLY = 2;
    private static final int DIVIDE = 3;

    private UnitFormat() {
        this.locale = Locale.ROOT;
        this.style = Style.SYMBOL;
        this.unitToLabel = Collections.emptyMap();
        this.labelToUnit = Collections.emptyMap();
    }

    public UnitFormat(Locale locale) {
        ArgumentChecks.ensureNonNull("locale", locale);
        this.locale = locale;
        this.style = Style.SYMBOL;
        this.unitToLabel = new HashMap();
        this.labelToUnit = new HashMap();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        ArgumentChecks.ensureNonNull("locale", locale);
        this.locale = locale;
        this.symbolToName = null;
        this.nameToUnit = null;
    }

    @Override
    public boolean isLocaleSensitive() {
        return this.style == Style.NAME;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        ArgumentChecks.ensureNonNull("style", (Object)style);
        this.style = style;
    }

    @Override
    public void label(Unit<?> unit, String string) {
        int n;
        ArgumentChecks.ensureNonNull("unit", unit);
        string = CharSequences.trimWhitespaces(string);
        ArgumentChecks.ensureNonEmpty("label", string);
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (AbstractUnit.isSymbolChar(n) || Character.isSpaceChar(n)) continue;
            throw new IllegalArgumentException(Errors.format((short)45, "label", string));
        }
        Unit<?> unit2 = this.labelToUnit.remove(this.unitToLabel.put(unit, string));
        Unit<?> unit3 = this.labelToUnit.put(string, unit);
        if (unit3 != null && !unit3.equals(unit) && !string.equals(this.unitToLabel.remove(unit3))) {
            throw new CorruptedObjectException("unitToLabel");
        }
        if (unit2 != null && !unit2.equals(unit)) {
            throw new CorruptedObjectException("labelToUnit");
        }
    }

    static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("org.apache.sis.measure.UnitNames", locale, UnitFormat.class.getClassLoader());
    }

    private ResourceBundle symbolToName() {
        ResourceBundle resourceBundle = this.symbolToName;
        if (resourceBundle == null) {
            this.symbolToName = resourceBundle = UnitFormat.getBundle(this.locale);
        }
        return resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unit<?> fromName(String string) {
        Map<String, Unit<?>> map;
        int n = string.length();
        int n2 = 0;
        while (true) {
            if (n2 != DEGREES.length()) {
                if (n2 == n || (string.charAt(n2) | 0x20) != DEGREES.charAt(n2)) {
                    if (n2 != 3 && n2 != 6) break;
                }
            } else {
                if (n == n2) {
                    return Units.DEGREE;
                }
                int n3 = string.codePointAt(n2);
                if (n3 == 95 || Character.isSpaceChar(n3)) {
                    n2 += Character.charCount(n3);
                }
                if (n - n2 != 1) break;
                switch (string.charAt(n2)) {
                    case 'K': 
                    case '\u212a': {
                        return Units.KELVIN;
                    }
                    case 'C': {
                        return Units.CELSIUS;
                    }
                    case 'E': 
                    case 'N': {
                        return Units.DEGREE;
                    }
                }
                break;
            }
            ++n2;
        }
        if ((map = this.nameToUnit) == null) {
            map = SHARED.get(this.locale);
            if (map == null) {
                map = new HashMap(128);
                UnitFormat.copy(this.locale, this.symbolToName(), map);
                if (!this.locale.equals(Locale.US)) {
                    UnitFormat.copy(Locale.US, UnitFormat.getBundle(Locale.US), map);
                }
                if (!this.locale.equals(Locale.ROOT)) {
                    UnitFormat.copy(Locale.ROOT, UnitFormat.getBundle(Locale.ROOT), map);
                }
                ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.sis.measure.UnitAliases", this.locale, UnitFormat.class.getClassLoader());
                for (String object : resourceBundle.keySet()) {
                    map.put(object.intern(), Units.get(resourceBundle.getString(object)));
                }
                map = Collections.unmodifiableMap(map);
                WeakValueHashMap<Locale, Map<String, Unit<?>>> weakValueHashMap = SHARED;
                synchronized (weakValueHashMap) {
                    for (Map<String, Unit<?>> map2 : SHARED.values()) {
                        if (!map.equals(map2)) continue;
                        map = map2;
                        break;
                    }
                    SHARED.put(this.locale, map);
                }
            }
            this.nameToUnit = map;
        }
        string = string.replace('_', ' ').toLowerCase(this.locale);
        string = CharSequences.replace(CharSequences.replace(CharSequences.replace(CharSequences.toASCII(string), "meters", "meter"), "metres", "metre"), DEGREES, "degree").toString();
        return map.get(string);
    }

    private static void copy(Locale locale, ResourceBundle resourceBundle, Map<String, Unit<?>> map) {
        for (String string : resourceBundle.keySet()) {
            map.put(CharSequences.toASCII(resourceBundle.getString(string).toLowerCase(locale)).toString().intern(), Units.get(string));
        }
    }

    @Override
    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        Map<Unit<?>, Number> map;
        ArgumentChecks.ensureNonNull("unit", unit);
        ArgumentChecks.ensureNonNull("toAppendTo", appendable);
        String string = this.unitToLabel.get(unit);
        if (string != null) {
            return appendable.append(string);
        }
        if (this.style == Style.NAME) {
            if (!(unit instanceof AbstractUnit)) {
                string = unit.getName();
                if (string != null) {
                    return appendable.append(string);
                }
            } else {
                string = unit.getSymbol();
                if (string != null) {
                    if (string.isEmpty()) {
                        string = UNITY;
                    }
                    ResourceBundle resourceBundle = this.symbolToName();
                    try {
                        string = resourceBundle.getString(string);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    return appendable.append(string);
                }
            }
        }
        if ((string = unit.getSymbol()) != null) {
            return this.style.appendSymbol(appendable, string);
        }
        double d = Units.toStandardUnit(unit);
        if (d != 1.0) {
            if (Double.isNaN(d)) {
                throw new IllegalArgumentException(Errors.format((short)104, "?\u22c5(" + unit.getSystemUnit() + ')'));
            }
            map = Double.toString(d);
            int n = ((String)((Object)map)).length();
            if (((String)((Object)map)).endsWith(".0")) {
                n -= 2;
            }
            appendable.append((CharSequence)((Object)map), 0, n).append(this.style.multiply);
        }
        if (unit instanceof AbstractUnit) {
            map = ((AbstractUnit)unit).getBaseSystemUnits();
        } else {
            map = unit.getBaseUnits();
            if (map == null) {
                map = Collections.singletonMap(unit, 1);
            }
        }
        UnitFormat.formatComponents(map, this.style, appendable);
        return appendable;
    }

    static void formatComponents(Map<?, ? extends Number> map, Style style, Appendable appendable) throws IOException {
        boolean bl = true;
        ArrayList arrayList = new ArrayList(map.size());
        for (Map.Entry<?, Number> entry : map.entrySet()) {
            int n;
            Number object = entry.getValue();
            int n2 = n = object instanceof Fraction ? ((Fraction)object).numerator : object.intValue();
            if (n > 0) {
                if (!bl) {
                    appendable.append(style.multiply);
                }
                bl = false;
                UnitFormat.formatComponent(entry, false, style, appendable);
                continue;
            }
            if (n == 0) continue;
            arrayList.add(entry);
        }
        if (!arrayList.isEmpty()) {
            boolean bl2;
            appendable.append(style.divide);
            boolean bl3 = bl2 = arrayList.size() > 1;
            if (bl2) {
                appendable.append('(');
            }
            bl = true;
            for (Map.Entry entry : arrayList) {
                if (!bl) {
                    appendable.append(style.multiply);
                }
                bl = false;
                UnitFormat.formatComponent(entry, true, style, appendable);
            }
            if (bl2) {
                appendable.append(')');
            }
        }
    }

    private static void formatComponent(Map.Entry<?, ? extends Number> entry, boolean bl, Style style, Appendable appendable) throws IOException {
        int n;
        UnitFormat.formatSymbol(entry.getKey(), style, appendable);
        Number number = entry.getValue();
        if (number instanceof Fraction) {
            Fraction fraction = (Fraction)number;
            if (fraction.denominator != 1) {
                if (bl) {
                    fraction = fraction.negate();
                }
                style.appendPower(appendable, fraction);
                return;
            }
            n = fraction.numerator;
        } else {
            n = number.intValue();
        }
        if (bl) {
            n = -n;
        }
        if (n != 1) {
            style.appendPower(appendable, n);
        }
    }

    private static void formatSymbol(Object object, Style style, Appendable appendable) throws IOException {
        String string;
        char c;
        if (object instanceof UnitDimension && (c = ((UnitDimension)object).symbol) != '\u0000') {
            appendable.append(c);
            return;
        }
        if (object instanceof Unit && (string = ((Unit)object).getSymbol()) != null) {
            style.appendSymbol(appendable, string);
            return;
        }
        appendable.append('?');
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        try {
            return (StringBuffer)this.format((Unit)object, stringBuffer);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public String format(Unit<?> unit) {
        try {
            return this.format(unit, new StringBuilder()).toString();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    private static int exponentOperator(CharSequence charSequence, int n, int n2) {
        if (n >= 0 && ++n < n2) {
            char c = charSequence.charAt(n);
            if (c == '*') {
                return 1;
            }
            if ((UnitFormat.isDigit(c) || UnitFormat.isSign(c)) && UnitFormat.isDigit(charSequence.charAt(n - 2))) {
                return 0;
            }
        }
        return -1;
    }

    private static boolean isDecimalSeparator(CharSequence charSequence, int n, int n2) {
        return n == 0 || UnitFormat.isDigit(charSequence.charAt(n - 1)) && (++n >= n2 || UnitFormat.isDigit(charSequence.charAt(n)));
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isSign(char c) {
        return c == '+' || c == '-';
    }

    private static boolean hasDigit(CharSequence charSequence, int n, int n2) {
        while (n < n2) {
            if (!UnitFormat.isDigit(charSequence.charAt(n++))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Unit<?> parse(CharSequence charSequence) throws ParserException {
        ParsePosition parsePosition = new ParsePosition(0);
        Unit<?> unit = this.parse(charSequence, parsePosition);
        int n = charSequence.length();
        int n2 = CharSequences.skipLeadingWhitespaces(charSequence, parsePosition.getIndex(), n);
        if (n2 < n) {
            throw new ParserException(Errors.format((short)135, CharSequences.trimWhitespaces(charSequence, 0, n2), CharSequences.trimWhitespaces(charSequence, n2, n)), charSequence, n2);
        }
        return unit;
    }

    public Unit<?> parse(CharSequence object, ParsePosition parsePosition) throws ParserException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object2;
        ArgumentChecks.ensureNonNull("symbols", object);
        ArgumentChecks.ensureNonNull("position", parsePosition);
        int n6 = object.length();
        int n7 = CharSequences.skipLeadingWhitespaces((CharSequence)object, parsePosition.getIndex(), n6);
        int n8 = XPaths.endOfURI((CharSequence)object, n7);
        if (n8 >= 0) {
            String string = object.subSequence(n7, n8).toString();
            object2 = DefinitionURI.codeOf("uom", "EPSG", string);
            if (object2 != null && object2 != string) {
                NumberFormatException numberFormatException = null;
                try {
                    Unit<?> unit = Units.valueOfEPSG(Integer.parseInt((String)object2));
                    if (unit != null) {
                        parsePosition.setIndex(n8);
                        return unit;
                    }
                }
                catch (NumberFormatException numberFormatException2) {
                    numberFormatException = numberFormatException2;
                }
                throw (ParserException)new ParserException(Errors.format((short)150, "EPSG:" + (String)object2), (CharSequence)object, n7 + Math.max(0, string.lastIndexOf((String)object2))).initCause(numberFormatException);
            }
            object2 = XPaths.xpointer("uom", string);
            if (object2 != null) {
                n5 = n7;
                n7 = n8 - ((String)object2).length();
                do {
                    if (--n7 >= n5) continue;
                    object = object2;
                    n7 = 0;
                    break;
                } while (!CharSequences.regionMatches((CharSequence)object, n7, (CharSequence)object2));
                n6 = n7 + ((String)object2).length();
            } else {
                n8 = -1;
            }
        }
        int n9 = 0;
        object2 = null;
        n5 = 0;
        block11: for (n3 = n7; n3 < n6; n3 += n4) {
            int n10 = Character.codePointAt((CharSequence)object, n3);
            n4 = Character.charCount(n10);
            switch (n10) {
                default: {
                    if (AbstractUnit.isSymbolChar(n10)) {
                        if (n9 != 1) continue block11;
                        n9 = 2;
                        continue block11;
                    }
                    if (Character.isDigit(n10) || Characters.isSuperScript(n10)) continue block11;
                    if (!Character.isSpaceChar(n10)) break block11;
                    n5 = 1;
                    continue block11;
                }
                case 42: {
                    n2 = UnitFormat.exponentOperator((CharSequence)object, n3, n6);
                    if (n2 < 0) {
                        n = 2;
                        break;
                    }
                    n3 += n2;
                }
                case 94: {
                    if (n9 != 1) continue block11;
                    break block11;
                }
                case 46: {
                    if (UnitFormat.isDecimalSeparator((CharSequence)object, n3, n6)) continue block11;
                }
                case 215: 
                case 8901: {
                    n = 2;
                    break;
                }
                case 47: 
                case 247: 
                case 8260: 
                case 8725: {
                    n = 3;
                    break;
                }
                case 40: {
                    ParsePosition parsePosition2 = new ParsePosition(n3 + Character.charCount(n10));
                    Unit<?> unit = this.parse((CharSequence)object, parsePosition2);
                    n3 = CharSequences.skipLeadingWhitespaces((CharSequence)object, parsePosition2.getIndex(), n6);
                    if (n3 >= n6 || Character.codePointAt((CharSequence)object, n3) != 41) {
                        throw new ParserException(Errors.format((short)101, object.subSequence(n7, n3), Character.valueOf(')')), (CharSequence)object, n7);
                    }
                    object2 = UnitFormat.apply(n9, object2, unit);
                    n9 = 1;
                    n4 = 1;
                    n7 = n3 + 1;
                    continue block11;
                }
            }
            if (n9 != 1) {
                object2 = UnitFormat.apply(n9, object2, this.parseTerm((CharSequence)object, n7, n3));
            }
            n5 = 0;
            n9 = n;
            n7 = n3 + n4;
        }
        Unit<?> unit = null;
        if (n5 != 0) {
            String string;
            n6 = n3;
            n7 = CharSequences.skipLeadingWhitespaces((CharSequence)object, n7, n3);
            block12: while ((n3 = CharSequences.skipTrailingWhitespaces((CharSequence)object, n7, n3)) > n7 && (unit = this.labelToUnit.get(string = object.subSequence(n7, n3).toString())) == null && (unit = this.fromName(string)) == null) {
                n = n3;
                while ((n -= Character.charCount(n2 = Character.codePointBefore((CharSequence)object, n))) > n7) {
                    if (!Character.isWhitespace(n2)) continue;
                    n3 = n;
                    continue block12;
                }
                break block12;
            }
            if (UnitFormat.hasDigit((CharSequence)object, n7, n3)) {
                n3 = n6;
            }
        }
        if (unit == null) {
            unit = this.parseTerm((CharSequence)object, n7, n3);
        }
        object2 = UnitFormat.apply(n9, object2, unit);
        parsePosition.setIndex(n8 >= 0 ? n8 : n3);
        return object2;
    }

    private static Unit<?> apply(int n, Unit<?> unit, Unit<?> unit2) {
        switch (n) {
            case 0: {
                return unit2;
            }
            case 1: 
            case 2: {
                return unit.multiply(unit2);
            }
            case 3: {
                return unit.divide(unit2);
            }
        }
        throw new AssertionError(n);
    }

    private Unit<?> parseTerm(CharSequence charSequence, int n, int n2) throws ParserException {
        String string = CharSequences.trimWhitespaces(charSequence, n, n2).toString();
        Unit<?> unit = this.labelToUnit.get(string);
        if (unit == null && (unit = UnitFormat.getPrefixed(string)) == null) {
            int n3 = string.length();
            if (n3 == 0) {
                return Units.UNITY;
            }
            int n4 = string.charAt(0);
            if (UnitFormat.isDigit((char)n4) || UnitFormat.isSign((char)n4)) {
                double d;
                try {
                    int n5;
                    int n6 = string.lastIndexOf(32);
                    if (n6 >= 0 && (n5 = CharSequences.skipLeadingWhitespaces(string, n6, n3)) < n3 && AbstractUnit.isSymbolChar(string.codePointAt(n5))) {
                        double d2 = Double.parseDouble(string.substring(0, n6));
                        return this.parseTerm(string, n6, n3).multiply(d2);
                    }
                    n6 = string.lastIndexOf(42);
                    if (n6 >= 0 || (n6 = string.lastIndexOf(94)) >= 0) {
                        n5 = Integer.parseInt(string.substring(0, n6));
                        int n7 = Integer.parseInt(string.substring(n6 + 1));
                        d = Math.pow(n5, n7);
                    } else {
                        d = Double.parseDouble(string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw (ParserException)new ParserException(Errors.format((short)150, string), charSequence, n).initCause(numberFormatException);
                }
                return Units.UNITY.multiply(d);
            }
            if (n3 >= 2) {
                n4 = 1;
                int n8 = n3;
                char c = string.charAt(--n8);
                boolean bl = false;
                if (Characters.isSuperScript(c)) {
                    if (UnitFormat.isDigit(c = Characters.toNormalScript(c))) {
                        n4 = c - 48;
                        bl = true;
                    }
                } else if (UnitFormat.isDigit(c)) {
                    do {
                        if (UnitFormat.isDigit(c = string.charAt(--n8))) continue;
                        if (!UnitFormat.isSign(c)) {
                            ++n8;
                        }
                        try {
                            n4 = Integer.parseInt(string.substring(n8));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw (ParserException)new ParserException(Errors.format((short)150, string), charSequence, n + n8).initCause(numberFormatException);
                        }
                        bl = true;
                        break;
                    } while (n8 != 0);
                }
                if (bl) {
                    if ((n8 = CharSequences.skipTrailingWhitespaces(string, 0, n8)) != 0) {
                        switch (string.charAt(n8 - 1)) {
                            case '*': {
                                if (n8 != 1 && string.charAt(n8 - 2) == '*') {
                                    --n8;
                                }
                            }
                            case '^': {
                                n8 = CharSequences.skipTrailingWhitespaces(string, 0, n8 - 1);
                            }
                        }
                    }
                    if ((unit = UnitFormat.getPrefixed(string.substring(CharSequences.skipLeadingWhitespaces(string, 0, n8), n8))) != null) {
                        return unit.pow(n4);
                    }
                }
            }
            if ((unit = this.fromName(string)) == null) {
                if (CharSequences.regionMatches(charSequence, n, UNITY, true)) {
                    return Units.UNITY;
                }
                throw new ParserException(Errors.format((short)150, string), charSequence, n);
            }
        }
        return unit;
    }

    private static Unit<?> getPrefixed(String string) {
        Unit<?> unit = Units.get(string);
        if (unit == null && string.length() >= 2) {
            LinearConverter linearConverter;
            int n = 1;
            char c = string.charAt(0);
            if (c == 'd' && string.charAt(1) == 'a') {
                c = '\u3372';
                n = 2;
            }
            if ((unit = Units.get(string.substring(n))) instanceof AbstractUnit && ((AbstractUnit)unit).isPrefixable() && (linearConverter = LinearConverter.forPrefix(c)) != null) {
                String string2 = unit.getSymbol();
                string2 = c == '\u3372' ? DECA + string2 : c + string2;
                return new ConventionalUnit((AbstractUnit)unit, linearConverter, string2.intern(), 0, 0);
            }
            unit = null;
        }
        return unit;
    }

    @Override
    public Object parseObject(String string) throws ParseException {
        try {
            return this.parse(string);
        }
        catch (ParserException parserException) {
            throw (ParseException)new ParseException(parserException.getLocalizedMessage(), parserException.getPosition()).initCause(parserException);
        }
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        try {
            return this.parse(string, parsePosition);
        }
        catch (ParserException parserException) {
            parsePosition.setErrorIndex(parserException.getPosition());
            return null;
        }
    }

    @Override
    public UnitFormat clone() {
        UnitFormat unitFormat = (UnitFormat)super.clone();
        try {
            unitFormat.setFinal("unitToLabel", this.unitToLabel);
            unitFormat.setFinal("labelToUnit", this.labelToUnit);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
        return unitFormat;
    }

    private void setFinal(String string, Map<?, ?> map) throws ReflectiveOperationException {
        map = map instanceof HashMap ? (Map<Object, Object>)((HashMap)map).clone() : new HashMap();
        Field field = UnitFormat.class.getDeclaredField(string);
        field.setAccessible(true);
        field.set(this, map);
    }

    public static enum Style {
        SYMBOL('\u22c5', '\u2215'),
        UCUM('.', '/'){

            @Override
            Appendable appendSymbol(Appendable appendable, String string) throws IOException {
                if (string.startsWith("\u00b0")) {
                    int n = string.length();
                    if (n == 2) {
                        switch (string.charAt(1)) {
                            case 'C': {
                                return appendable.append("Cel");
                            }
                            case 'K': 
                            case '\u212a': {
                                return appendable.append('K');
                            }
                        }
                    }
                    return appendable.append("deg").append(string, 1, n);
                }
                CharSequence charSequence = CharSequences.toASCII(string);
                int n = charSequence.length();
                for (int i = 0; i < n; ++i) {
                    appendable.append(Characters.toNormalScript(charSequence.charAt(i)));
                }
                return appendable;
            }

            @Override
            void appendPower(Appendable appendable, int n) throws IOException {
                appendable.append(String.valueOf(n));
            }

            @Override
            void appendPower(Appendable appendable, Fraction fraction) throws IOException {
                appendable.append('^').append('(').append(String.valueOf(fraction.numerator)).append('/').append(String.valueOf(fraction.denominator)).append(')');
            }
        }
        ,
        NAME('\u22c5', '\u2215');

        static final char EXPONENT_OR_MULTIPLY = '*';
        static final char EXPONENT = '^';
        static final char OPEN = '(';
        static final char CLOSE = ')';
        final char multiply;
        final char divide;

        private Style(char c, char c2) {
            this.multiply = c;
            this.divide = c2;
        }

        Appendable appendSymbol(Appendable appendable, String string) throws IOException {
            return appendable.append(string);
        }

        void appendPower(Appendable appendable, int n) throws IOException {
            if (n >= 0 && n <= 9) {
                appendable.append(Characters.toSuperScript((char)(n + 48)));
            } else {
                appendable.append(String.valueOf(n));
            }
        }

        void appendPower(Appendable appendable, Fraction fraction) throws IOException {
            appendable.append('^');
            String string = fraction.toString();
            if (string.length() == 1) {
                appendable.append(string);
            } else {
                appendable.append('(').append(string).append(')');
            }
        }
    }
}

