/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.ObjectStreamException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Numbers;

final class DefaultFormat
extends Format {
    private static final long serialVersionUID = -2309270763519060316L;
    private static final Format[] INSTANCES = new Format[7];
    private final Class<?> type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Format getInstance(Class<?> clazz) {
        int n;
        if (clazz == Number.class) {
            n = 0;
        } else {
            n = Numbers.getEnumConstant(clazz) - 2;
            if (n < 0 || n >= INSTANCES.length) {
                return null;
            }
        }
        Format[] formatArray = INSTANCES;
        synchronized (INSTANCES) {
            Format format = INSTANCES[n];
            if (format == null) {
                DefaultFormat.INSTANCES[n] = format = new DefaultFormat(clazz);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return format;
        }
    }

    private DefaultFormat(Class<?> clazz) {
        this.type = clazz;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return stringBuffer.append(object);
    }

    private Object valueOf(String string) throws NumberFormatException {
        return this.type != Number.class ? Numbers.valueOf(string, this.type) : Numbers.narrowestNumber(string);
    }

    @Override
    public Object parseObject(String string) throws ParseException {
        string = CharSequences.trimWhitespaces(string);
        try {
            return this.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LocalizedParseException(null, this.type, string, null).initCause(numberFormatException);
        }
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        Object object;
        int n;
        int n2;
        boolean bl = false;
        block6: for (n2 = n = CharSequences.skipLeadingWhitespaces(string, parsePosition.getIndex(), string.length()); n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            switch (c) {
                default: {
                    if (c < '+' || c > '9') break block6;
                    continue block6;
                }
                case ',': 
                case '/': {
                    break block6;
                }
                case 'E': 
                case 'e': {
                    if (bl) break block6;
                    bl = true;
                    continue block6;
                }
            }
        }
        string = string.substring(n, n2);
        try {
            object = this.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        parsePosition.setIndex(n2);
        return object;
    }

    private Object readResolve() throws ObjectStreamException {
        Format format = DefaultFormat.getInstance(this.type);
        return format != null ? format : this;
    }
}

