/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.internal.referencing.provider.GeographicOffsets2D;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;

@XmlTransient
public class GeographicOffsets
extends GeodeticOperation {
    private static final long serialVersionUID = -6246011184175753328L;
    static final ParameterDescriptor<Double> TX;
    static final ParameterDescriptor<Double> TY;
    static final ParameterDescriptor<Double> TZ;
    private static final ParameterDescriptorGroup PARAMETERS;

    public GeographicOffsets() {
        super(3, 3, PARAMETERS, new GeographicOffsets[4]);
        this.redimensioned[0] = new GeographicOffsets2D(this.redimensioned);
        this.redimensioned[1] = new GeographicOffsets(2, 3, PARAMETERS, this.redimensioned);
        this.redimensioned[2] = new GeographicOffsets(3, 2, PARAMETERS, this.redimensioned);
        this.redimensioned[3] = this;
    }

    GeographicOffsets(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup, GeodeticOperation[] geodeticOperationArray) {
        super(n, n2, parameterDescriptorGroup, geodeticOperationArray);
    }

    ParameterDescriptor<Double> vertical() {
        return TZ;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        Matrix4 matrix4 = new Matrix4();
        matrix4.m03 = parameters.doubleValue(TX);
        matrix4.m13 = parameters.doubleValue(TY);
        matrix4.m23 = parameters.doubleValue(this.vertical());
        return MathTransforms.linear(matrix4);
    }

    static {
        ParameterBuilder parameterBuilder = GeographicOffsets.builder();
        TY = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8601")).addName("Latitude offset")).create(0.0, Units.DEGREE);
        TX = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8602")).addName("Longitude offset")).create(0.0, Units.DEGREE);
        TZ = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8603")).addName("Vertical Offset")).create(0.0, Units.METRE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("9660")).addName("Geographic3D offsets")).createGroup(TY, TX, TZ);
    }
}

