/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk9;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.sis.internal.util.UnmodifiableArrayList;

public final class JDK9 {
    private JDK9() {
    }

    @SafeVarargs
    public static <E> List<E> listOf(E ... EArray) {
        switch (EArray.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(EArray[0]);
            }
        }
        return UnmodifiableArrayList.wrap(EArray);
    }

    @SafeVarargs
    public static <E> Set<E> setOf(E ... EArray) {
        switch (EArray.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(EArray[0]);
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(Arrays.asList(EArray)));
    }
}

