/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.BodyPartBuilder;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.message.MessageBuilder;
import org.apache.james.mime4j.message.MultipartImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.NameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartBuilder {
    private final List<Entity> bodyParts = new LinkedList<Entity>();
    private String subType;
    private String preamble;
    private String epilogue;
    private BodyFactory bodyFactory;

    public static MultipartBuilder create(String subType) {
        return new MultipartBuilder().setSubType(subType);
    }

    public static MultipartBuilder createCopy(Multipart other) {
        return new MultipartBuilder().copy(other);
    }

    public static MultipartBuilder create() {
        return new MultipartBuilder();
    }

    private MultipartBuilder() {
    }

    public MultipartBuilder use(BodyFactory bodyFactory) {
        this.bodyFactory = bodyFactory;
        return this;
    }

    public String getSubType() {
        return this.subType;
    }

    public MultipartBuilder setSubType(String subType) {
        this.subType = subType;
        return this;
    }

    public int getCount() {
        return this.bodyParts.size();
    }

    public List<Entity> getBodyParts() {
        return Collections.unmodifiableList(this.bodyParts);
    }

    public MultipartBuilder addBodyPart(Entity bodyPart) {
        if (bodyPart == null) {
            throw new IllegalArgumentException();
        }
        this.bodyParts.add(bodyPart);
        return this;
    }

    public MultipartBuilder addBodyPart(Entity bodyPart, int index) {
        if (bodyPart == null) {
            throw new IllegalArgumentException();
        }
        this.bodyParts.add(index, bodyPart);
        return this;
    }

    public MultipartBuilder removeBodyPart(int index) {
        this.bodyParts.remove(index);
        return this;
    }

    public MultipartBuilder replaceBodyPart(Entity bodyPart, int index) {
        if (bodyPart == null) {
            throw new IllegalArgumentException();
        }
        this.bodyParts.set(index, bodyPart);
        return this;
    }

    public String getPreamble() {
        return this.preamble;
    }

    public MultipartBuilder setPreamble(String preamble) {
        this.preamble = preamble;
        return this;
    }

    public String getEpilogue() {
        return this.epilogue;
    }

    public MultipartBuilder setEpilogue(String epilogue) {
        this.epilogue = epilogue;
        return this;
    }

    public MultipartBuilder addTextPart(String text, Charset charset) throws IOException {
        Charset cs = charset != null ? charset : Charsets.ISO_8859_1;
        TextBody body = this.bodyFactory != null ? this.bodyFactory.textBody(InputStreams.create(text, cs), cs.name()) : BasicBodyFactory.INSTANCE.textBody(text, cs);
        BodyPart bodyPart = BodyPartBuilder.create().setBody(body).setContentType("text/plain", new NameValuePair("charset", cs.name())).setContentTransferEncoding(Charsets.US_ASCII.equals(cs) ? "7bit" : "quoted-printable").build();
        return this.addBodyPart(bodyPart);
    }

    public MultipartBuilder addBinaryPart(byte[] bin, String mimeType) throws IOException {
        BinaryBody body = this.bodyFactory != null ? this.bodyFactory.binaryBody(InputStreams.create(bin)) : BasicBodyFactory.INSTANCE.binaryBody(bin);
        BodyPart bodyPart = BodyPartBuilder.create().setBody(body).setContentType(mimeType != null ? mimeType : "application/octet-stream", new NameValuePair[0]).setContentTransferEncoding("base64").build();
        return this.addBodyPart(bodyPart);
    }

    public MultipartBuilder copy(Multipart other) {
        if (other == null) {
            return this;
        }
        this.subType = other.getSubType();
        this.bodyParts.clear();
        List<Entity> otherParts = other.getBodyParts();
        for (Entity otherPart : otherParts) {
            Body otherBody;
            BodyPart bodyPart = new BodyPart();
            Header otherHeader = otherPart.getHeader();
            if (otherHeader != null) {
                HeaderImpl header = new HeaderImpl();
                for (Field otherField : otherHeader.getFields()) {
                    header.addField(otherField);
                }
                bodyPart.setHeader(header);
            }
            if ((otherBody = otherPart.getBody()) != null) {
                Body body = null;
                if (otherBody instanceof Message) {
                    body = MessageBuilder.createCopy((Message)otherBody).build();
                } else if (otherBody instanceof Multipart) {
                    body = MultipartBuilder.createCopy((Multipart)otherBody).build();
                } else if (otherBody instanceof SingleBody) {
                    body = ((SingleBody)otherBody).copy();
                }
                bodyPart.setBody(body);
            }
            this.bodyParts.add(bodyPart);
        }
        this.preamble = other.getPreamble();
        this.epilogue = other.getEpilogue();
        return this;
    }

    public Multipart build() {
        MultipartImpl multipart = new MultipartImpl(this.subType);
        for (Entity part : this.bodyParts) {
            multipart.addBodyPart(part);
        }
        multipart.setPreamble(this.preamble);
        multipart.setEpilogue(this.epilogue);
        return multipart;
    }
}

