/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Event;
import org.opengis.metadata.acquisition.Objective;
import org.opengis.metadata.acquisition.Operation;
import org.opengis.metadata.acquisition.OperationType;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.Progress;
import org.opengis.util.InternationalString;

@XmlType(name="MI_Operation_Type", propOrder={"description", "citation", "identifier", "status", "type", "childOperations", "objectives", "parentOperation", "plan", "platforms", "significantEvents"})
@XmlRootElement(name="MI_Operation")
public class DefaultOperation
extends ISOMetadata
implements Operation {
    private static final long serialVersionUID = 4828650802232651791L;
    private InternationalString description;
    private Citation citation;
    private Progress status;
    private OperationType type;
    private Collection<Operation> childOperations;
    private Collection<Objective> objectives;
    private Operation parentOperation;
    private Plan plan;
    private Collection<Platform> platforms;
    private Collection<Event> significantEvents;

    public DefaultOperation() {
    }

    public DefaultOperation(Operation operation) {
        super(operation);
        if (operation != null) {
            this.description = operation.getDescription();
            this.citation = operation.getCitation();
            this.identifiers = this.singleton(operation.getIdentifier(), Identifier.class);
            this.status = operation.getStatus();
            this.type = operation.getType();
            this.childOperations = this.copyCollection(operation.getChildOperations(), Operation.class);
            this.objectives = this.copyCollection(operation.getObjectives(), Objective.class);
            this.parentOperation = operation.getParentOperation();
            this.plan = operation.getPlan();
            this.platforms = this.copyCollection(operation.getPlatforms(), Platform.class);
            this.significantEvents = this.copyCollection(operation.getSignificantEvents(), Event.class);
        }
    }

    public static DefaultOperation castOrCopy(Operation operation) {
        if (operation == null || operation instanceof DefaultOperation) {
            return (DefaultOperation)operation;
        }
        return new DefaultOperation(operation);
    }

    @Override
    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @Override
    @XmlElement(name="citation")
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation citation) {
        this.checkWritePermission();
        this.citation = citation;
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return NonMarshalledAuthority.getMarshallable(this.identifiers);
    }

    public void setIdentifier(Identifier identifier) {
        this.checkWritePermission();
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        NonMarshalledAuthority.setMarshallable(this.identifiers, identifier);
    }

    @Override
    @XmlElement(name="status", required=true)
    public Progress getStatus() {
        return this.status;
    }

    public void setStatus(Progress progress) {
        this.checkWritePermission();
        this.status = progress;
    }

    @Override
    @XmlElement(name="type")
    public OperationType getType() {
        return this.type;
    }

    public void setType(OperationType operationType) {
        this.checkWritePermission();
        this.type = operationType;
    }

    @XmlElement(name="childOperation")
    public Collection<Operation> getChildOperations() {
        this.childOperations = this.nonNullCollection(this.childOperations, Operation.class);
        return this.childOperations;
    }

    public void setChildOperations(Collection<? extends Operation> collection) {
        this.childOperations = this.writeCollection(collection, this.childOperations, Operation.class);
    }

    @XmlElement(name="objective")
    public Collection<Objective> getObjectives() {
        this.objectives = this.nonNullCollection(this.objectives, Objective.class);
        return this.objectives;
    }

    public void setObjectives(Collection<? extends Objective> collection) {
        this.objectives = this.writeCollection(collection, this.objectives, Objective.class);
    }

    @Override
    @XmlElement(name="parentOperation", required=true)
    public Operation getParentOperation() {
        return this.parentOperation;
    }

    public void setParentOperation(Operation operation) {
        this.checkWritePermission();
        this.parentOperation = operation;
    }

    @Override
    @XmlElement(name="plan")
    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan plan) {
        this.checkWritePermission();
        this.plan = plan;
    }

    @XmlElement(name="platform")
    public Collection<Platform> getPlatforms() {
        this.platforms = this.nonNullCollection(this.platforms, Platform.class);
        return this.platforms;
    }

    public void setPlatforms(Collection<? extends Platform> collection) {
        this.platforms = this.writeCollection(collection, this.platforms, Platform.class);
    }

    @XmlElement(name="significantEvent")
    public Collection<Event> getSignificantEvents() {
        this.significantEvents = this.nonNullCollection(this.significantEvents, Event.class);
        return this.significantEvents;
    }

    public void setSignificantEvents(Collection<? extends Event> collection) {
        this.significantEvents = this.writeCollection(collection, this.significantEvents, Event.class);
    }
}

