# Generated by default/object.tt
package Paws::MediaTailor::AdMarkerPassthrough;
  use Moose;
  has Enabled => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::AdMarkerPassthrough

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::AdMarkerPassthrough object:

  $service_obj->Method(Att1 => { Enabled => $value, ..., Enabled => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::AdMarkerPassthrough object:

  $result = $service_obj->Method(...);
  $result->Att1->Enabled

=head1 DESCRIPTION

For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN,
EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin
manifest to the MediaTailor personalized manifest.

No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT
has a value of 60, but no ads are filled for that ad break, MediaTailor
will not set the value to 0.

=head1 ATTRIBUTES


=head2 Enabled => Bool

Enables ad marker passthrough for your configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

