# Generated by default/object.tt
package Paws::ElastiCache::DestinationDetails;
  use Moose;
  has CloudWatchLogsDetails => (is => 'ro', isa => 'Paws::ElastiCache::CloudWatchLogsDestinationDetails');
  has KinesisFirehoseDetails => (is => 'ro', isa => 'Paws::ElastiCache::KinesisFirehoseDestinationDetails');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ElastiCache::DestinationDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElastiCache::DestinationDetails object:

  $service_obj->Method(Att1 => { CloudWatchLogsDetails => $value, ..., KinesisFirehoseDetails => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElastiCache::DestinationDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->CloudWatchLogsDetails

=head1 DESCRIPTION

Configuration details of either a CloudWatch Logs destination or
Kinesis Data Firehose destination.

=head1 ATTRIBUTES


=head2 CloudWatchLogsDetails => L<Paws::ElastiCache::CloudWatchLogsDestinationDetails>

The configuration details of the CloudWatch Logs destination.


=head2 KinesisFirehoseDetails => L<Paws::ElastiCache::KinesisFirehoseDestinationDetails>

The configuration details of the Kinesis Data Firehose destination.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElastiCache>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

