/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyAxisIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Orphan
implements MutableNodeInfo,
FingerprintedNode {
    private short kind;
    private NodeName nodeName = null;
    private CharSequence stringValue;
    private SchemaType typeAnnotation = null;
    private Configuration config;
    private String systemId;
    private boolean isId;
    private boolean isIdref;

    public Orphan(Configuration config) {
        this.config = config;
    }

    public void setNodeKind(short kind) {
        this.kind = kind;
    }

    public void setNodeName(NodeName nodeName) {
        this.nodeName = nodeName;
    }

    public void setStringValue(CharSequence stringValue) {
        this.stringValue = stringValue;
    }

    public void setTypeAnnotation(SchemaType typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
    }

    @Override
    public void setTypeAnnotation(int typeAnnotation) {
        this.typeAnnotation = this.getConfiguration().getSchemaType(typeAnnotation);
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setIsId(boolean id) {
        this.isId = id;
    }

    public void setIsIdref(boolean idref) {
        this.isIdref = idref;
    }

    @Override
    public int getNodeKind() {
        return this.kind;
    }

    @Override
    public SequenceIterator<? extends AtomicValue> getTypedValue() throws XPathException {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return SingletonIterator.makeIterator(new StringValue(this.stringValue));
            }
            case 3: 
            case 9: 
            case 13: {
                return SingletonIterator.makeIterator(new UntypedAtomicValue(this.stringValue));
            }
        }
        if (this.typeAnnotation == null || this.typeAnnotation == Untyped.getInstance() || this.typeAnnotation == BuiltInAtomicType.UNTYPED_ATOMIC) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(this.stringValue));
        }
        return this.typeAnnotation.getTypedValue(this);
    }

    @Override
    public Value atomize() throws XPathException {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.stringValue);
            }
            case 3: 
            case 9: 
            case 13: {
                return new UntypedAtomicValue(this.stringValue);
            }
        }
        if (this.typeAnnotation == null || this.typeAnnotation == Untyped.getInstance() || this.typeAnnotation == BuiltInAtomicType.UNTYPED_ATOMIC) {
            return new UntypedAtomicValue(this.stringValue);
        }
        return this.typeAnnotation.atomize(this);
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    @Override
    public int getTypeAnnotation() {
        SchemaType st = this.getSchemaType();
        return st == null ? -1 : st.getFingerprint();
    }

    @Override
    public SchemaType getSchemaType() {
        if (this.typeAnnotation == null) {
            if (this.kind == 1) {
                return Untyped.getInstance();
            }
            if (this.kind == 2) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
        }
        return this.typeAnnotation;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        return this == other;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getBaseURI() {
        if (this.kind == 7) {
            return this.systemId;
        }
        return null;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (this.isSameNodeInfo(other)) {
            return 0;
        }
        return this.hashCode() < ((Object)other).hashCode() ? -1 : 1;
    }

    @Override
    public String getStringValue() {
        return ((Object)this.stringValue).toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.stringValue;
    }

    @Override
    public int getNameCode() {
        NodeName nn = this.nodeName;
        if (nn == null) {
            return -1;
        }
        return nn.allocateNameCode(this.getNamePool());
    }

    @Override
    public int getFingerprint() {
        if (this.nodeName == null) {
            return -1;
        }
        return this.getNameCode() & 0xFFFFF;
    }

    @Override
    public String getLocalPart() {
        if (this.nodeName == null) {
            return "";
        }
        return this.nodeName.getLocalPart();
    }

    @Override
    public String getURI() {
        if (this.nodeName == null) {
            return "";
        }
        return this.nodeName.getURI();
    }

    @Override
    public String getPrefix() {
        if (this.nodeName == null) {
            return "";
        }
        return this.nodeName.getPrefix();
    }

    @Override
    public String getDisplayName() {
        if (this.nodeName == null) {
            return "";
        }
        return this.nodeName.getDisplayName();
    }

    @Override
    public NodeInfo getParent() {
        return null;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 1: 
            case 5: 
            case 12: {
                return SingleNodeIterator.makeIterator(this);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyAxisIterator.emptyAxisIterator();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 1: 
            case 5: 
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyAxisIterator.emptyAxisIterator();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public String getAttributeValue(int fingerprint) {
        return null;
    }

    @Override
    public String getAttributeValue(String uri, String local) {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        buffer.append('Q');
        buffer.append(Integer.toString(this.hashCode()));
    }

    @Override
    public long getDocumentNumber() {
        return this.hashCode() & 0xFFFFFF;
    }

    @Override
    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        Navigator.copy(this, out, copyOptions, locationId);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return null;
    }

    @Override
    public boolean isId() {
        return this.isId || this.kind == 2 && this.nodeName.equals(StandardNames.XML_ID_NAME);
    }

    @Override
    public boolean isIdref() {
        return this.isIdref;
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    @Override
    public void insertChildren(NodeInfo[] source, boolean atStart, boolean inherit) {
    }

    @Override
    public void insertSiblings(NodeInfo[] source, boolean before, boolean inherit) {
    }

    @Override
    public void removeAttribute(NodeInfo attribute) {
    }

    @Override
    public void addAttribute(NodeName nameCode, SimpleType attType, CharSequence value, int properties) {
    }

    @Override
    public void delete() {
        this.kind = (short)-1;
    }

    @Override
    public boolean isDeleted() {
        return this.kind == -1;
    }

    @Override
    public void replace(NodeInfo[] replacement, boolean inherit) {
        throw new IllegalStateException("Cannot replace a parentless node");
    }

    @Override
    public void replaceStringValue(CharSequence stringValue) {
        this.stringValue = stringValue;
    }

    @Override
    public void rename(NodeName newNameCode) {
        if (this.kind == 2 || this.kind == 7) {
            this.nodeName = newNameCode;
        }
    }

    @Override
    public void addNamespace(NamespaceBinding nscode, boolean inherit) {
    }

    @Override
    public void removeTypeAnnotation() {
        this.typeAnnotation = BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    @Override
    public Builder newBuilder() {
        throw new UnsupportedOperationException("Cannot create children for an Orphan node");
    }
}

