package Daje::Workflow::Checks::Mandatory;
use Mojo::Base 'Daje::Workflow::Common::Checks::Base', -base, -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Workflow::Checks::Mandatory  - Checks for mandatory fields
#
# SYNOPSIS
# ========
#
#    check($self)
#
#    Checks can either come from the workflow checks tag as a comma separated string of fields
#
#               {
#                 "name": "Mandatory fields",
#                 "class": "Daje::Workflow::Checks::Mandatory",
#                 "checks": "name,tools_object_types_fkey,active"
#               }
#
#    or a database model class containing a mandatory method containing a comma separated list of fields
#
#               {
#                 "name": "Mandatory fields",
#                 "class": "Daje::Workflow::Checks::Mandatory",
#                 "checks": "Daje::Database::Model::SentinelStatus"
#               }
#
#    Assumed format of data $self->context->{context}->{payload}->{field to be checked for existence)
#
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::Checks::Mandatory is used to check and make sure
# mandatory fields are included in the context
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

use Mojo::Loader qw(load_class);
use Data::Dumper;

sub check($self) {
    my $result = 1;
    my @fields = ();
    if (length($self->checks()) > 0) {
        my $checks = $self->checks();
        if ($checks =~ /\Q::\E/) {
            if (my $e = load_class $checks) {
                $self->error->add_error($e);
            }
            if ($self->error->has_error() == 0) {
                my $mandatory = $checks->new()->mandatory();
                @fields = split(',', $mandatory);
            }
        } else {
            @fields = split(',', $self->checks());
        }
        my $length = scalar @fields;
        for (my $i = 0; $i < $length; $i++) {
            my $temp = $self->context();
            if (!exists $self->context->{context}->{payload}->{$fields[$i]}) {
                $result = 0;
                $self->error->add_error("Mandatory field '$fields[$i]' is missing")
            }
        }
    }
    return $result;
}

1;













#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Checks::Mandatory  - Checks for mandatory fields



=head1 SYNOPSIS


   check($self)

   Checks can either come from the workflow checks tag as a comma separated string of fields

              {
                "name": "Mandatory fields",
                "class": "Daje::Workflow::Checks::Mandatory",
                "checks": "name,tools_object_types_fkey,active"
              }

   or a database model class containing a mandatory method containing a comma separated list of fields

              {
                "name": "Mandatory fields",
                "class": "Daje::Workflow::Checks::Mandatory",
                "checks": "Daje::Database::Model::SentinelStatus"
              }

   Assumed format of data $self->context->{context}->{payload}->{field to be checked for existence)




=head1 DESCRIPTION


Daje::Workflow::Checks::Mandatory is used to check and make sure
mandatory fields are included in the context



=head1 REQUIRES

L<Data::Dumper> 

L<Mojo::Loader> 

L<v5.42> 

L<Mojo::Base> 


=head1 METHODS

=head2 check($self)

 check($self)();


=head1 AUTHOR

janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

