# This Makefile.PL for Apache2-Filter-Minifier-JavaScript was generated by
# Dist::Zilla::Plugin::MakeMaker::ApacheTest 0.04
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.48.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008001;
use ExtUtils::MakeMaker;

# figure out if mod_perl v1 or v2 is installed.  DynamicPrereqs in the
# PluginBundle needs this to require the appropriate mod_perl module.
my $mp_version = mod_perl_version();

# configure Apache::Test
test_configure();

my %WriteMakefileArgs = (
  "ABSTRACT" => "JavaScript minifying output filter for mod_perl",
  "AUTHOR" => "Graham TerMarsch <cpan\@howlingfrog.com>",
  "CONFIGURE_REQUIRES" => {
    "Apache::Test" => 0,
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Apache2-Filter-Minifier-JavaScript",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME" => "Apache2::Filter::Minifier::JavaScript",
  "PREREQ_PM" => {
    "APR::Table" => 0,
    "Apache2::Const" => 0,
    "Apache2::Filter" => 0,
    "Apache2::Log" => 0,
    "Apache2::RequestRec" => 0,
    "Apache2::RequestUtil" => 0,
    "JavaScript::Minifier" => 0,
    "namespace::clean" => 0
  },
  "TEST_REQUIRES" => {
    "Apache::Test" => "1.12",
    "ExtUtils::MakeMaker" => 0,
    "File::Slurp" => 0,
    "File::Spec" => 0,
    "File::Temp" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "LWP::UserAgent" => 0,
    "Test::DiagINC" => "0.002",
    "Test::More" => "0.96"
  },
  "VERSION" => "1.07",
  "clean" => {
    "FILES" => [
      "t/TEST"
    ]
  },
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "APR::Table" => 0,
  "Apache2::Const" => 0,
  "Apache2::Filter" => 0,
  "Apache2::Log" => 0,
  "Apache2::RequestRec" => 0,
  "Apache2::RequestUtil" => 0,
  "Apache::Test" => "1.12",
  "ExtUtils::MakeMaker" => 0,
  "File::Slurp" => 0,
  "File::Spec" => 0,
  "File::Temp" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "JavaScript::Minifier" => 0,
  "LWP::UserAgent" => 0,
  "Test::DiagINC" => "0.002",
  "Test::More" => "0.96",
  "namespace::clean" => 0
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.039
if ($mp_version == 2) {     requires('mod_perl2', '1.999022'); } elsif ($mp_version == 1) {     requires('mod_perl', '1.27'); }

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

sub test_configure {
    require Apache::TestMM;

    # enable make test
    Apache::TestMM->import(qw(test clean));

    Apache::TestMM::filter_args();

    Apache::TestMM::generate_script('t/TEST');
}

sub mod_perl_version {
    # try MP2
    eval {
        require mod_perl2;
    };
    unless ($@) {
        return 2;
    }

    # try MP1
    eval {
        require mod_perl;
    };
    unless ($@) {
        if ($mod_perl::VERSION >= 1.99) {
            # mod_perl 2, prior to the mod_perl2 rename (1.99_21, AKA 2.0.0 RC5)
            die "mod_perl 2.0 RC5 or later is required\n";
        }

        return 1;
    }

    # assume mod_perl version 2 is wanted
    return 2;
}

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.039
sub _add_prereq {
  my ($mm_key, $module, $version_or_range) = @_;
  $version_or_range ||= 0;
  warn "$module already exists in $mm_key (at version $WriteMakefileArgs{$mm_key}{$module}) -- need to do a sane metamerge!"
    if exists $WriteMakefileArgs{$mm_key}{$module}
      and $WriteMakefileArgs{$mm_key}{$module} ne '0'
      and $WriteMakefileArgs{$mm_key}{$module} ne $version_or_range;
  warn "$module already exists in FallbackPrereqs (at version $FallbackPrereqs{$module}) -- need to do a sane metamerge!"
    if exists $FallbackPrereqs{$module} and $FallbackPrereqs{$module} ne '0'
        and $FallbackPrereqs{$module} ne $version_or_range;
  $WriteMakefileArgs{$mm_key}{$module} = $FallbackPrereqs{$module} = $version_or_range;
  return;
}

sub requires { goto &runtime_requires }

sub runtime_requires {
  my ($module, $version_or_range) = @_;
  _add_prereq(PREREQ_PM => $module, $version_or_range);
}
