#!/usr/bin/perl

package eBay::API::XML::Call::GetProductSellingPages::GetProductSellingPagesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetProductSellingPagesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetProductSellingPages::GetProductSellingPagesRequestType

=head1 DESCRIPTION

Retrieves information that describes how to present catalog
product information to a seller. Use this information to present
users with the equivalent of the Item Specifics portion of the
eBay Title and Description pages and to validate user-specified
values for eBay attributes on the client before including them in
an AddItem call or related calls. The data contains a list of all
the attributes that are applicable for one or more requested
products, along with related meta-data. The meta-data specifies
the pre-filled values of each attribute, the possible values of
attributes that are not pre-filled, the logic for presenting the
attributes to a user, and rules for validating the user's
selections. Use the results in combination with GetAttributesXSL
to render the Item Specifics in a graphical user interface. See
the eBay Web Services Guide for an overview of Pre-filled Item
Information, details about searching for catalog products, and
information about the ProductSellingPages content model.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetProductSellingPages::GetProductSellingPagesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ProductType;
use eBay::API::XML::DataType::Enum::ProductUseCaseCodeType;


my @gaProperties = ( [ 'Product', 'ns:ProductType', '1'
	     ,'eBay::API::XML::DataType::ProductType', '1' ]
	, [ 'UseCase', 'ns:ProductUseCaseCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ProductUseCaseCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setProduct()

A catalog product identifies a prototype description
of a well-known type of item, such as a popular book.
As this call supports batch requests, you can pass in an array of products
to retrieve data for several products at the same time.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrGPSellP
Title: Retrieving a Product's Item Specifics

  RequiredInput: Yes
#    Argument: reference to an array  
                      of 'ns:ProductType'

=cut

sub setProduct {
  my $self = shift;
  $self->{'Product'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getProduct()

#    Returns: reference to an array  
                      of 'ns:ProductType'

=cut

sub getProduct {
  my $self = shift;
  return $self->_getDataTypeArray('Product');
}


=head2 setUseCase()

Specifies the context in which the call is being executed, which will imply
certain validation rules. Use this property to make sure you retrieve the
appropriate version of product information and attribute meta-data
when you are listing, revising, or relisting an item with Pre-filled Item Information.
Valid values:<br>
<b>SYI</b> = Sell Your Item. Use before adding an item. Causes the response to include the
latest product ID in the system (given an ID specified in the Products element)
and the corresponding characteristic meta-data.<br>
<b>RYI</b> = Revise Your Item. Use this before revising an item. Causes the response to return
the product ID, attribute data, and other data associated with the version of the product
that you pass in the Products element. This is useful in case the product ID or associated data
has changed in the system since the item was originally listed. When revising
an item, this helps you make changes that are consistent with the original listing.<br>
<b>RELIST</b> = Use this before relisting an item. Causes the response to include the
latest product ID in the system (given an ID specified in the Products element)
and the corresponding characteristic meta-data. (Same as SYI).

  RequiredInput: Yes
#    Argument: 'ns:ProductUseCaseCodeType'

=cut

sub setUseCase {
  my $self = shift;
  $self->{'UseCase'} = shift
}

=head2 getUseCase()

#    Returns: 'ns:ProductUseCaseCodeType'

=cut

sub getUseCase {
  my $self = shift;
  return $self->{'UseCase'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
