# Generated by default/object.tt
package Paws::AutoScaling::PredictiveScalingMetricSpecification;
  use Moose;
  has PredefinedLoadMetricSpecification => (is => 'ro', isa => 'Paws::AutoScaling::PredictiveScalingPredefinedLoadMetric');
  has PredefinedMetricPairSpecification => (is => 'ro', isa => 'Paws::AutoScaling::PredictiveScalingPredefinedMetricPair');
  has PredefinedScalingMetricSpecification => (is => 'ro', isa => 'Paws::AutoScaling::PredictiveScalingPredefinedScalingMetric');
  has TargetValue => (is => 'ro', isa => 'Num', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AutoScaling::PredictiveScalingMetricSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AutoScaling::PredictiveScalingMetricSpecification object:

  $service_obj->Method(Att1 => { PredefinedLoadMetricSpecification => $value, ..., TargetValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AutoScaling::PredictiveScalingMetricSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->PredefinedLoadMetricSpecification

=head1 DESCRIPTION

This structure specifies the metrics and target utilization settings
for a predictive scaling policy.

You must specify either a metric pair, or a load metric and a scaling
metric individually. Specifying a metric pair instead of individual
metrics provides a simpler way to configure metrics for a scaling
policy. You choose the metric pair, and the policy automatically knows
the correct sum and average statistics to use for the load metric and
the scaling metric.

Example

=over

=item *

You create a predictive scaling policy and specify C<ALBRequestCount>
as the value for the metric pair and C<1000.0> as the target value. For
this type of metric, you must provide the metric dimension for the
corresponding target group, so you also provide a resource label for
the Application Load Balancer target group that is attached to your
Auto Scaling group.

=item *

The number of requests the target group receives per minute provides
the load metric, and the request count averaged between the members of
the target group provides the scaling metric. In CloudWatch, this
refers to the C<RequestCount> and C<RequestCountPerTarget> metrics,
respectively.

=item *

For optimal use of predictive scaling, you adhere to the best practice
of using a dynamic scaling policy to automatically scale between the
minimum capacity and maximum capacity in response to real-time changes
in resource utilization.

=item *

Amazon EC2 Auto Scaling consumes data points for the load metric over
the last 14 days and creates an hourly load forecast for predictive
scaling. (A minimum of 24 hours of data is required.)

=item *

After creating the load forecast, Amazon EC2 Auto Scaling determines
when to reduce or increase the capacity of your Auto Scaling group in
each hour of the forecast period so that the average number of requests
received by each instance is as close to 1000 requests per minute as
possible at all times.

=back


=head1 ATTRIBUTES


=head2 PredefinedLoadMetricSpecification => L<Paws::AutoScaling::PredictiveScalingPredefinedLoadMetric>

The load metric specification.


=head2 PredefinedMetricPairSpecification => L<Paws::AutoScaling::PredictiveScalingPredefinedMetricPair>

The metric pair specification from which Amazon EC2 Auto Scaling
determines the appropriate scaling metric and load metric to use.


=head2 PredefinedScalingMetricSpecification => L<Paws::AutoScaling::PredictiveScalingPredefinedScalingMetric>

The scaling metric specification.


=head2 B<REQUIRED> TargetValue => Num

Specifies the target utilization.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AutoScaling>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

