## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::unix::gid::exists;

our $DATE = '2024-11-15'; # DATE
our $VERSION = '0.022'; # VERSION

our $rschema = do{my$var={base=>"unix::gid",clsets_after_base=>[{description=>"\nExisting means having a group name associated with this GID, i.e. `getgrgid`\nreturns a record.\n\nSupport coercion from an existing group name.\n\n",prefilters=>["Unix::convert_unix_group_to_gid","Unix::check_gid_exists"],summary=>"Group identifier (GID) that has to exist on the system"}],clsets_after_type=>[{description=>"\nSee also `posint` for integers that start from 1.\n\n",examples=>[{data=>0,valid=>1},{data=>1,valid=>1},{data=>-1,valid=>0}],links=>[{summary=>"Equivalent Type::Tiny constraints: NonNegativeInteger",url=>"pm:Types::XSD"},{summary=>"Equivalent Type::Tiny constraints: PositiveOrZeroInt",url=>"pm:Types::Numbers"}],min=>0,summary=>"Non-negative integer (0, 1, 2, ...)"},{description=>"\nNote that this schema does not check whether the GID exists (has record in the\nuser database e.g. `/etc/group`). To do that, use the `unix::gid::exists`\nschema.\n\n",examples=>[{valid=>0,value=>-1},{valid=>1,value=>0},{valid=>1,value=>1}],prefilters=>["Unix::convert_unix_group_to_gid"],summary=>"Group identifier (GID)","x.completion"=>["unix_group_or_gid"]},'$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_type}[0]','$var->{clsets_after_type}[1]','$var->{clsets_after_base}[0]'],resolve_path=>["int","uint","unix::gid"],type=>"int",v=>2};$var->{clsets_after_type}[2]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_type}[0];$var->{"clsets_after_type.alt.merge.merged"}[1]=$var->{clsets_after_type}[1];$var->{"clsets_after_type.alt.merge.merged"}[2]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Group identifier (GID) that has to exist on the system

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::unix::gid::exists - Group identifier (GID) that has to exist on the system

=head1 VERSION

This document describes version 0.022 of Sah::SchemaR::unix::gid::exists (from Perl distribution Sah-SchemaBundle-Unix), released on 2024-11-15.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::SchemaBundle during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-SchemaBundle-Unix>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-SchemaBundle-Unix>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-SchemaBundle-Unix>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
