# Generated by default/object.tt
package Paws::SSOAdmin::AccessControlAttributeValue;
  use Moose;
  has Source => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSOAdmin::AccessControlAttributeValue

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSOAdmin::AccessControlAttributeValue object:

  $service_obj->Method(Att1 => { Source => $value, ..., Source => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSOAdmin::AccessControlAttributeValue object:

  $result = $service_obj->Method(...);
  $result->Att1->Source

=head1 DESCRIPTION

The value used for mapping a specified attribute to an identity source.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Source => ArrayRef[Str|Undef]

The identity source to use when mapping a specified attribute to AWS
SSO.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSOAdmin>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

