#!/usr/bin/perl -w

use strict;

require 5.006 ;
use ExtUtils::MakeMaker ;
use Config ;
use FindBin ;
use File::Path ;
use File::Copy ;

no warnings ;

BEGIN
{
    eval { require File::Spec::Functions ; File::Spec::Functions->import() } ;
    if ($@)
    {
        *catfile = sub { return "$_[0]/$_[1]" }
    }
}

########
# VARS #
########

my $exe = $Config{_exe};

my $rm = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e rm_f' : 'rm';
my $mv = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e mv' : 'mv';

my $rm_exe = "-\$(RM) *$exe" if $exe ;

#################
# WRITEMAKEFILE #
#################

if ( $ARGV[0] =~ /releasedir/i ) {
  releasedir() ;
  exit;
}

print "Writing Makefile for LibHTTP-Perl\n";

open OUT, "> Makefile" or die "open 'Makefile': $!";

################################################################################

print OUT <<EOT;
# AUTOGENERATED, DO NOT EDIT, RERUN Makefile.PL

RM=$rm
MV=$mv
PERL=$^X

RM_RF = \$(PERL) -MExtUtils::Command -e rm_rf

all: libhttp-perl$exe releasedir

clean: cleanrelease
	-\$(RM) *.dll *.so *.exe *.zip libzip.modules
	-\$(RM) *.opt *.pdb
	\$(MV) Makefile Makefile.old

realclean: clean
	-\$(RM) libhttp-perl$exe
	-\$(RM) Makefile Makefile.old

cleanrelease :
	\$(RM_RF) release

releasedir:
	\$(PERL) myMakeFile.PL releasedir

libhttp-perl$exe: \$(OBJECTS)
	\$(PERL) lib.pl
	libzip -ob libhttp-perl.pl -allowopts ceiImMTvVwWX

EOT


################################################################################


##############
# RELEASEDIR #
##############

sub releasedir {
  my $dir = catfile($FindBin::RealBin, 'release') ;
  rmtree($dir);
  
  mkdir($dir , 0775) ;
  
  my @files = ("libhttp-perl$exe" , 'libhttp.conf' , 'main.pl') ;

  opendir (DIRLOG, $FindBin::RealBin);
  while (my $filename = readdir DIRLOG) {
    push(@files , $filename) if $filename =~ /\.(?:dll|so|zip)$/ ;
  }
  closedir (DIRLOG);
  
  foreach my $files_i ( @files ) {
    copy(catfile($FindBin::RealBin, $files_i), $dir) ;
  }
}

#######
# END #
#######



