/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.managed;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.managed.TransactionRegistry;
import org.apache.tomcat.dbcp.dbcp2.managed.XAConnectionFactory;

public class LocalXAConnectionFactory
implements XAConnectionFactory {
    private final TransactionRegistry transactionRegistry;
    private final ConnectionFactory connectionFactory;

    public LocalXAConnectionFactory(TransactionManager transactionManager, ConnectionFactory connectionFactory) {
        this(transactionManager, null, connectionFactory);
    }

    public LocalXAConnectionFactory(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, ConnectionFactory connectionFactory) {
        Objects.requireNonNull(transactionManager, "transactionManager");
        Objects.requireNonNull(connectionFactory, "connectionFactory");
        this.transactionRegistry = new TransactionRegistry(transactionManager, transactionSynchronizationRegistry);
        this.connectionFactory = connectionFactory;
    }

    @Override
    public Connection createConnection() throws SQLException {
        Connection connection = this.connectionFactory.createConnection();
        LocalXAResource localXAResource = new LocalXAResource(connection);
        this.transactionRegistry.registerConnection(connection, localXAResource);
        return connection;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    protected static class LocalXAResource
    implements XAResource {
        private static final Xid[] EMPTY_XID_ARRAY = new Xid[0];
        private final Connection connection;
        private Xid currentXid;
        private boolean originalAutoCommit;

        public LocalXAResource(Connection connection) {
            this.connection = connection;
        }

        private Xid checkCurrentXid() throws XAException {
            if (this.currentXid == null) {
                throw new XAException("There is no current transaction");
            }
            return this.currentXid;
        }

        @Override
        public synchronized void commit(Xid xid, boolean bl) throws XAException {
            Objects.requireNonNull(xid, "xid");
            if (!this.checkCurrentXid().equals(xid)) {
                throw new XAException("Invalid Xid: expected " + String.valueOf(this.currentXid) + ", but was " + String.valueOf(xid));
            }
            try {
                if (this.connection.isClosed()) {
                    throw new XAException("Connection is closed");
                }
                if (!this.connection.isReadOnly()) {
                    this.connection.commit();
                }
            }
            catch (SQLException sQLException) {
                throw this.newXAException("Commit failed.", sQLException);
            }
            finally {
                try {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                }
                catch (SQLException sQLException) {}
                this.currentXid = null;
            }
        }

        @Override
        public synchronized void end(Xid xid, int n) throws XAException {
            Objects.requireNonNull(xid, "xid");
            if (!this.checkCurrentXid().equals(xid)) {
                throw new XAException("Invalid Xid: expected " + String.valueOf(this.currentXid) + ", but was " + String.valueOf(xid));
            }
        }

        @Override
        public synchronized void forget(Xid xid) {
            if (xid != null && xid.equals(this.currentXid)) {
                this.currentXid = null;
            }
        }

        @Override
        public int getTransactionTimeout() {
            return 0;
        }

        public synchronized Xid getXid() {
            return this.currentXid;
        }

        @Override
        public boolean isSameRM(XAResource xAResource) {
            return this == xAResource;
        }

        private XAException newXAException(String string, SQLException sQLException) {
            return (XAException)new XAException(string).initCause(sQLException);
        }

        @Override
        public synchronized int prepare(Xid xid) {
            try {
                if (this.connection.isReadOnly()) {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                    return 3;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return 0;
        }

        @Override
        public Xid[] recover(int n) {
            return EMPTY_XID_ARRAY;
        }

        @Override
        public synchronized void rollback(Xid xid) throws XAException {
            Objects.requireNonNull(xid, "xid");
            if (!this.checkCurrentXid().equals(xid)) {
                throw new XAException("Invalid Xid: expected " + String.valueOf(this.currentXid) + ", but was " + String.valueOf(xid));
            }
            try {
                this.connection.rollback();
            }
            catch (SQLException sQLException) {
                throw this.newXAException("Rollback failed.", sQLException);
            }
            finally {
                try {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                }
                catch (SQLException sQLException) {}
                this.currentXid = null;
            }
        }

        @Override
        public boolean setTransactionTimeout(int n) {
            return false;
        }

        @Override
        public synchronized void start(Xid xid, int n) throws XAException {
            if (n == 0) {
                if (this.currentXid != null) {
                    throw new XAException("Already enlisted in another transaction with xid " + String.valueOf(xid));
                }
                try {
                    this.originalAutoCommit = this.connection.getAutoCommit();
                }
                catch (SQLException sQLException) {
                    this.originalAutoCommit = true;
                }
                try {
                    this.connection.setAutoCommit(false);
                }
                catch (SQLException sQLException) {
                    throw this.newXAException("Count not turn off auto commit for a XA transaction", sQLException);
                }
                this.currentXid = xid;
            } else if (n == 0x8000000) {
                if (!xid.equals(this.currentXid)) {
                    throw new XAException("Attempting to resume in different transaction: expected " + String.valueOf(this.currentXid) + ", but was " + String.valueOf(xid));
                }
            } else {
                throw new XAException("Unknown start flag " + n);
            }
        }
    }
}

