/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.object;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.bz2.BZ2Object;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodec;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalDecoderObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalEncoderObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamReaderObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamWriterObject;
import com.oracle.graal.python.builtins.modules.codecs.PEncodingMap;
import com.oracle.graal.python.builtins.modules.csv.CSVDialect;
import com.oracle.graal.python.builtins.modules.csv.CSVReader;
import com.oracle.graal.python.builtins.modules.csv.CSVWriter;
import com.oracle.graal.python.builtins.modules.csv.QuoteStyle;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldObject;
import com.oracle.graal.python.builtins.modules.ctypes.CThunkObject;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArgObject;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrObject;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.functools.LruCacheObject;
import com.oracle.graal.python.builtins.modules.functools.PKeyWrapper;
import com.oracle.graal.python.builtins.modules.functools.PPartial;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObject;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.modules.io.PBytesIO;
import com.oracle.graal.python.builtins.modules.io.PBytesIOBuffer;
import com.oracle.graal.python.builtins.modules.io.PFileIO;
import com.oracle.graal.python.builtins.modules.io.PNLDecoder;
import com.oracle.graal.python.builtins.modules.io.PRWPair;
import com.oracle.graal.python.builtins.modules.io.PStringIO;
import com.oracle.graal.python.builtins.modules.io.PTextIO;
import com.oracle.graal.python.builtins.modules.json.PJSONEncoder;
import com.oracle.graal.python.builtins.modules.json.PJSONScanner;
import com.oracle.graal.python.builtins.modules.lsprof.Profiler;
import com.oracle.graal.python.builtins.modules.lzma.LZMAObject;
import com.oracle.graal.python.builtins.modules.multiprocessing.PGraalPySemLock;
import com.oracle.graal.python.builtins.modules.multiprocessing.PSemLock;
import com.oracle.graal.python.builtins.modules.pickle.PPickleBuffer;
import com.oracle.graal.python.builtins.modules.pickle.PPickler;
import com.oracle.graal.python.builtins.modules.pickle.PPicklerMemoProxy;
import com.oracle.graal.python.builtins.modules.pickle.PUnpickler;
import com.oracle.graal.python.builtins.modules.pickle.PUnpicklerMemoProxy;
import com.oracle.graal.python.builtins.modules.zlib.JavaCompress;
import com.oracle.graal.python.builtins.modules.zlib.JavaDecompress;
import com.oracle.graal.python.builtins.modules.zlib.NativeZlibCompObject;
import com.oracle.graal.python.builtins.modules.zlib.ZLibCompObject;
import com.oracle.graal.python.builtins.modules.zlib.ZlibDecompressorObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.asyncio.PANextAwaitable;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGen;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGenASend;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGenAThrow;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGenWrappedValue;
import com.oracle.graal.python.builtins.objects.asyncio.PCoroutineWrapper;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.ForeignHashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.KeywordsStorage;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.contextvars.PContextIterator;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsToken;
import com.oracle.graal.python.builtins.objects.deque.PDeque;
import com.oracle.graal.python.builtins.objects.deque.PDequeIter;
import com.oracle.graal.python.builtins.objects.dict.PDefaultDict;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.enumerate.PEnumerate;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.PBaseExceptionGroup;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.IndexedSlotDescriptor;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.PArrayIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBaseSetIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBigRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PDoubleSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PLongSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PObjectSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PSentinelIterator;
import com.oracle.graal.python.builtins.objects.iterator.PSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PStringIterator;
import com.oracle.graal.python.builtins.objects.iterator.PStructUnpackIterator;
import com.oracle.graal.python.builtins.objects.iterator.PZip;
import com.oracle.graal.python.builtins.objects.itertools.PAccumulate;
import com.oracle.graal.python.builtins.objects.itertools.PBatched;
import com.oracle.graal.python.builtins.objects.itertools.PChain;
import com.oracle.graal.python.builtins.objects.itertools.PCombinations;
import com.oracle.graal.python.builtins.objects.itertools.PCombinationsWithReplacement;
import com.oracle.graal.python.builtins.objects.itertools.PCompress;
import com.oracle.graal.python.builtins.objects.itertools.PCount;
import com.oracle.graal.python.builtins.objects.itertools.PCycle;
import com.oracle.graal.python.builtins.objects.itertools.PDropwhile;
import com.oracle.graal.python.builtins.objects.itertools.PFilterfalse;
import com.oracle.graal.python.builtins.objects.itertools.PGroupBy;
import com.oracle.graal.python.builtins.objects.itertools.PGrouper;
import com.oracle.graal.python.builtins.objects.itertools.PIslice;
import com.oracle.graal.python.builtins.objects.itertools.PPairwise;
import com.oracle.graal.python.builtins.objects.itertools.PPermutations;
import com.oracle.graal.python.builtins.objects.itertools.PProduct;
import com.oracle.graal.python.builtins.objects.itertools.PRepeat;
import com.oracle.graal.python.builtins.objects.itertools.PStarmap;
import com.oracle.graal.python.builtins.objects.itertools.PTakewhile;
import com.oracle.graal.python.builtins.objects.itertools.PTee;
import com.oracle.graal.python.builtins.objects.itertools.PTeeDataObject;
import com.oracle.graal.python.builtins.objects.itertools.PZipLongest;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.map.PMap;
import com.oracle.graal.python.builtins.objects.mappingproxy.PMappingproxy;
import com.oracle.graal.python.builtins.objects.memoryview.BufferLifecycleManager;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewIterator;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.mmap.PMMap;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.namespace.PSimpleNamespace;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.ordereddict.POrderedDict;
import com.oracle.graal.python.builtins.objects.ordereddict.POrderedDictIterator;
import com.oracle.graal.python.builtins.objects.posix.PDirEntry;
import com.oracle.graal.python.builtins.objects.posix.PScandirIterator;
import com.oracle.graal.python.builtins.objects.property.PProperty;
import com.oracle.graal.python.builtins.objects.queue.PSimpleQueue;
import com.oracle.graal.python.builtins.objects.random.PRandom;
import com.oracle.graal.python.builtins.objects.range.PBigRange;
import com.oracle.graal.python.builtins.objects.range.PIntRange;
import com.oracle.graal.python.builtins.objects.referencetype.PReferenceType;
import com.oracle.graal.python.builtins.objects.reversed.PSequenceReverseIterator;
import com.oracle.graal.python.builtins.objects.reversed.PStringReverseIterator;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.slice.PIntSlice;
import com.oracle.graal.python.builtins.objects.slice.PObjectSlice;
import com.oracle.graal.python.builtins.objects.socket.PSocket;
import com.oracle.graal.python.builtins.objects.ssl.PMemoryBIO;
import com.oracle.graal.python.builtins.objects.ssl.PSSLContext;
import com.oracle.graal.python.builtins.objects.ssl.PSSLSocket;
import com.oracle.graal.python.builtins.objects.ssl.SSLMethod;
import com.oracle.graal.python.builtins.objects.str.NativeCharSequence;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.struct.PStruct;
import com.oracle.graal.python.builtins.objects.superobject.SuperObject;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.graal.python.builtins.objects.thread.PRLock;
import com.oracle.graal.python.builtins.objects.thread.PThreadLocal;
import com.oracle.graal.python.builtins.objects.tokenize.PTokenizerIter;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.PTupleGetter;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.types.PGenericAlias;
import com.oracle.graal.python.builtins.objects.types.PGenericAliasIterator;
import com.oracle.graal.python.builtins.objects.types.PUnionType;
import com.oracle.graal.python.builtins.objects.typing.PParamSpec;
import com.oracle.graal.python.builtins.objects.typing.PParamSpecArgs;
import com.oracle.graal.python.builtins.objects.typing.PParamSpecKwargs;
import com.oracle.graal.python.builtins.objects.typing.PTypeAliasType;
import com.oracle.graal.python.builtins.objects.typing.PTypeVar;
import com.oracle.graal.python.builtins.objects.typing.PTypeVarTuple;
import com.oracle.graal.python.compiler.BytecodeCodeUnit;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.BytecodeDSLCodeUnit;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.runtime.NFIZlibSupport;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.tools.profiler.CPUSampler;
import java.lang.ref.ReferenceQueue;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.concurrent.Semaphore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public final class PFactory {
    private PFactory() {
    }

    private static <T> T trace(PythonLanguage language, T newInstance) {
        AllocationReporter reporter = language.getAllocationReporter();
        if (reporter.isActive()) {
            PFactory.doTrace(newInstance, reporter);
        }
        return newInstance;
    }

    @HostCompilerDirectives.InliningCutoff
    private static <T> void doTrace(T newInstance, AllocationReporter reporter) {
        reporter.onEnter(null, 0L, Long.MIN_VALUE);
        reporter.onReturnValue(newInstance, 0L, Long.MIN_VALUE);
    }

    public static PythonObject createPythonObject(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PythonObject(cls, shape));
    }

    public static PythonNativeVoidPtr createNativeVoidPtr(PythonLanguage language, Object obj) {
        return PFactory.trace(language, new PythonNativeVoidPtr(obj));
    }

    public static PythonNativeVoidPtr createNativeVoidPtr(PythonLanguage language, Object obj, long nativePtr) {
        return PFactory.trace(language, new PythonNativeVoidPtr(obj, nativePtr));
    }

    public static SuperObject createSuperObject(PythonLanguage language) {
        return PFactory.createSuperObject(language, (Object)PythonBuiltinClassType.Super, PythonBuiltinClassType.Super.getInstanceShape(language));
    }

    public static SuperObject createSuperObject(PythonLanguage language, Object self, Shape shape) {
        return PFactory.trace(language, new SuperObject(self, shape));
    }

    public static PInt createInt(PythonLanguage language, long value) {
        return PFactory.createInt(language, (Object)PythonBuiltinClassType.PInt, language.getBuiltinTypeInstanceShape(PythonBuiltinClassType.PInt), PFactory.asBigInt(value));
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger asBigInt(long value) {
        return BigInteger.valueOf(value);
    }

    public static PInt createInt(PythonLanguage language, BigInteger value) {
        return PFactory.createInt(language, (Object)PythonBuiltinClassType.PInt, language.getBuiltinTypeInstanceShape(PythonBuiltinClassType.PInt), value);
    }

    public static PInt createInt(PythonLanguage language, Object cls, Shape shape, long value) {
        return PFactory.createInt(language, cls, shape, PFactory.asBigInt(value));
    }

    public static PInt createInt(PythonLanguage language, Object cls, Shape shape, BigInteger value) {
        return PFactory.trace(language, new PInt(cls, shape, value));
    }

    public static PFloat createFloat(PythonLanguage language, double value) {
        return PFactory.createFloat(language, (Object)PythonBuiltinClassType.PFloat, language.getBuiltinTypeInstanceShape(PythonBuiltinClassType.PFloat), value);
    }

    public static PFloat createFloat(PythonLanguage language, Object cls, Shape shape, double value) {
        return PFactory.trace(language, new PFloat(cls, shape, value));
    }

    public static PString createString(PythonLanguage language, TruffleString string) {
        return PFactory.createString(language, (Object)PythonBuiltinClassType.PString, language.getBuiltinTypeInstanceShape(PythonBuiltinClassType.PString), string);
    }

    public static PString createString(PythonLanguage language, Object cls, Shape shape, TruffleString string) {
        return PFactory.trace(language, new PString(cls, shape, string));
    }

    public static PString createString(PythonLanguage language, NativeCharSequence string) {
        return PFactory.createString(language, (Object)PythonBuiltinClassType.PString, language.getBuiltinTypeInstanceShape(PythonBuiltinClassType.PString), string);
    }

    public static PString createString(PythonLanguage language, Object cls, Shape shape, NativeCharSequence string) {
        return PFactory.trace(language, new PString(cls, shape, string));
    }

    public static PBytes createEmptyBytes(PythonLanguage language) {
        if (CompilerDirectives.inInterpreter()) {
            return PFactory.createBytes(language, PythonUtils.EMPTY_BYTE_ARRAY);
        }
        return PFactory.createBytes(language, new byte[0]);
    }

    public static PBytes createBytes(PythonLanguage language, byte[] array) {
        return PFactory.createBytes(language, array, array.length);
    }

    public static PBytes createBytes(PythonLanguage language, byte[] array, int length) {
        return PFactory.createBytes(language, new ByteSequenceStorage(array, length));
    }

    public static PBytes createBytes(PythonLanguage language, SequenceStorage storage) {
        return PFactory.createBytes(language, (Object)PythonBuiltinClassType.PBytes, PythonBuiltinClassType.PBytes.getInstanceShape(language), storage);
    }

    public static PBytes createBytes(PythonLanguage language, Object cls, Shape shape, byte[] bytes) {
        return PFactory.createBytes(language, cls, shape, new ByteSequenceStorage(bytes));
    }

    public static PBytes createBytes(PythonLanguage language, Object cls, Shape shape, SequenceStorage storage) {
        return PFactory.trace(language, new PBytes(cls, shape, storage));
    }

    public static PTuple createEmptyTuple(PythonLanguage language) {
        return PFactory.createTuple(language, EmptySequenceStorage.INSTANCE);
    }

    public static PTuple createEmptyTuple(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.createTuple(language, cls, shape, EmptySequenceStorage.INSTANCE);
    }

    public static PTuple createTuple(PythonLanguage language, Object[] objects) {
        return PFactory.createTuple(language, new ObjectSequenceStorage(objects));
    }

    public static PTuple createTuple(PythonLanguage language, int[] ints) {
        return PFactory.createTuple(language, new IntSequenceStorage(ints));
    }

    public static PTuple createTuple(PythonLanguage language, SequenceStorage store) {
        return PFactory.createTuple(language, (Object)PythonBuiltinClassType.PTuple, PythonBuiltinClassType.PTuple.getInstanceShape(language), store);
    }

    public static PTuple createTuple(PythonLanguage language, Object cls, Shape shape, SequenceStorage store) {
        return PFactory.trace(language, new PTuple(cls, shape, store));
    }

    public static PTuple createStructSeq(PythonLanguage language, StructSequence.BuiltinTypeDescriptor desc, Object ... values) {
        assert (desc.inSequence <= values.length && values.length <= desc.fieldNames.length);
        return PFactory.createTuple(language, (Object)desc.type, desc.type.getInstanceShape(language), new ObjectSequenceStorage(values, desc.inSequence));
    }

    public static PTupleGetter createTupleGetter(PythonLanguage language, int index, Object doc) {
        return PFactory.createTupleGetter(language, (Object)PythonBuiltinClassType.PTupleGetter, PythonBuiltinClassType.PTupleGetter.getInstanceShape(language), index, doc);
    }

    public static PTupleGetter createTupleGetter(PythonLanguage language, Object cls, Shape shape, int index, Object doc) {
        return PFactory.trace(language, new PTupleGetter(cls, shape, index, doc));
    }

    public static PComplex createComplex(PythonLanguage language, Object cls, Shape shape, double real, double imag) {
        return PFactory.trace(language, new PComplex(cls, shape, real, imag));
    }

    public static PComplex createComplex(PythonLanguage language, double real, double imag) {
        return PFactory.createComplex(language, (Object)PythonBuiltinClassType.PComplex, PythonBuiltinClassType.PComplex.getInstanceShape(language), real, imag);
    }

    public static PIntRange createIntRange(PythonLanguage language, int stop) {
        return PFactory.trace(language, new PIntRange(language, 0, stop, 1, stop));
    }

    public static PIntRange createIntRange(PythonLanguage language, int start, int stop, int step, int len) {
        return PFactory.trace(language, new PIntRange(language, start, stop, step, len));
    }

    public static PBigRange createBigRange(PythonLanguage language, PInt start, PInt stop, PInt step, PInt len) {
        return PFactory.trace(language, new PBigRange(language, start, stop, step, len));
    }

    public static PIntSlice createIntSlice(PythonLanguage language, int start, int stop, int step) {
        return PFactory.trace(language, new PIntSlice(language, start, stop, step));
    }

    public static PIntSlice createIntSlice(PythonLanguage language, int start, int stop, int step, boolean isStartNone, boolean isStepNone) {
        return PFactory.trace(language, new PIntSlice(language, start, stop, step, isStartNone, isStepNone));
    }

    public static PObjectSlice createObjectSlice(PythonLanguage language, Object start, Object stop, Object step) {
        return PFactory.trace(language, new PObjectSlice(language, start, stop, step));
    }

    public static PRandom createRandom(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PRandom(cls, shape));
    }

    public static PythonModule createPythonModule(PythonLanguage language, TruffleString name) {
        return PFactory.trace(language, PythonModule.createInternal(name));
    }

    public static PythonModule createPythonModule(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PythonModule(cls, shape));
    }

    public static PythonClass createPythonClassAndFixupSlots(PythonLanguage language, TruffleString name, Object base, PythonAbstractClass[] bases) {
        return PFactory.createPythonClassAndFixupSlots(language, (Object)PythonBuiltinClassType.PythonClass, PythonBuiltinClassType.PythonClass.getInstanceShape(language), name, base, bases);
    }

    public static PythonClass createPythonClassAndFixupSlots(PythonLanguage language, Object metaclass, Shape metaclassShape, TruffleString name, Object base, PythonAbstractClass[] bases) {
        PythonClass result = PFactory.trace(language, new PythonClass(language, metaclass, metaclassShape, name, base, bases));
        MroSequenceStorage mro = TypeNodes.GetMroStorageNode.executeUncached(result);
        TpSlots.inherit(result, null, mro, true);
        TpSlots.fixupSlotDispatchers(result);
        result.initializeMroShape(language);
        return result;
    }

    public static PythonClass createPythonClass(PythonLanguage language, Object metaclass, Shape metaclassShape, TruffleString name, boolean invokeMro, Object base, PythonAbstractClass[] bases) {
        return PFactory.trace(language, new PythonClass(language, metaclass, metaclassShape, name, invokeMro, base, bases));
    }

    public static PMemoryView createMemoryView(PythonLanguage language, PythonContext context, BufferLifecycleManager bufferLifecycleManager, Object buffer, Object owner, int len, boolean readonly, int itemsize, BufferFormat format, TruffleString formatString, int ndim, Object bufPointer, int offset, int[] shape, int[] strides, int[] suboffsets, int flags) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.PMemoryView;
        return PFactory.trace(language, new PMemoryView((Object)cls, cls.getInstanceShape(language), context, bufferLifecycleManager, buffer, owner, len, readonly, itemsize, format, formatString, ndim, bufPointer, offset, shape, strides, suboffsets, flags));
    }

    public static PMemoryView createMemoryViewForManagedObject(PythonLanguage language, Object buffer, Object owner, int itemsize, int length, boolean readonly, TruffleString format, TruffleString.CodePointLengthNode lengthNode, TruffleString.CodePointAtIndexNode atIndexNode) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.PMemoryView;
        return PFactory.trace(language, new PMemoryView((Object)cls, cls.getInstanceShape(language), null, null, buffer, owner, length, readonly, itemsize, BufferFormat.forMemoryView(format, lengthNode, atIndexNode), format, 1, null, 0, new int[]{length / itemsize}, new int[]{itemsize}, null, 6));
    }

    public static MemoryViewIterator createMemoryViewIterator(PythonLanguage language, PMemoryView seq, int index, int length, BufferFormat fmt) {
        return PFactory.trace(language, new MemoryViewIterator((Object)PythonBuiltinClassType.PMemoryViewIterator, PythonBuiltinClassType.PMemoryViewIterator.getInstanceShape(language), seq, index, length, fmt));
    }

    public static PMethod createMethod(PythonLanguage language, Object cls, Shape shape, Object self, Object function) {
        return PFactory.trace(language, new PMethod(cls, shape, self, function));
    }

    public static PMethod createMethod(PythonLanguage language, Object self, Object function) {
        return PFactory.createMethod(language, (Object)PythonBuiltinClassType.PMethod, PythonBuiltinClassType.PMethod.getInstanceShape(language), self, function);
    }

    public static PMethod createBuiltinMethod(PythonLanguage language, Object self, PFunction function) {
        return PFactory.createMethod(language, (Object)PythonBuiltinClassType.PBuiltinFunctionOrMethod, PythonBuiltinClassType.PBuiltinFunctionOrMethod.getInstanceShape(language), self, function);
    }

    public static PBuiltinMethod createBuiltinMethod(PythonLanguage language, Object cls, Shape shape, Object self, PBuiltinFunction function) {
        return PFactory.trace(language, new PBuiltinMethod(cls, shape, self, function, null));
    }

    public static PBuiltinMethod createBuiltinMethod(PythonLanguage language, Object self, PBuiltinFunction function, Object classObject) {
        return PFactory.trace(language, new PBuiltinMethod((Object)PythonBuiltinClassType.PBuiltinMethod, PythonBuiltinClassType.PBuiltinMethod.getInstanceShape(language), self, function, classObject));
    }

    public static PBuiltinMethod createBuiltinMethod(PythonLanguage language, Object self, PBuiltinFunction function) {
        return PFactory.createBuiltinMethod(language, (Object)PythonBuiltinClassType.PBuiltinFunctionOrMethod, PythonBuiltinClassType.PBuiltinFunctionOrMethod.getInstanceShape(language), self, function);
    }

    public static PFunction createFunction(PythonLanguage language, TruffleString name, PCode code, PythonObject globals, PCell[] closure) {
        return PFactory.trace(language, new PFunction(language, name, name, code, globals, closure));
    }

    public static PFunction createFunction(PythonLanguage language, TruffleString name, TruffleString qualname, PCode code, PythonObject globals, Object[] defaultValues, PKeyword[] kwDefaultValues, PCell[] closure) {
        return PFactory.trace(language, new PFunction(language, name, qualname, code, globals, defaultValues, kwDefaultValues, closure));
    }

    public static PFunction createFunction(PythonLanguage language, TruffleString name, PCode code, PythonObject globals, Object[] defaultValues, PKeyword[] kwDefaultValues, PCell[] closure) {
        return PFactory.trace(language, new PFunction(language, name, name, code, globals, defaultValues, kwDefaultValues, closure));
    }

    public static PFunction createFunction(PythonLanguage language, TruffleString name, TruffleString qualname, PCode code, PythonObject globals, Object[] defaultValues, PKeyword[] kwDefaultValues, PCell[] closure, Assumption codeStableAssumption) {
        return PFactory.trace(language, new PFunction(language, name, qualname, code, globals, defaultValues, kwDefaultValues, closure, codeStableAssumption));
    }

    public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString name, Object type, int numDefaults, int flags, RootCallTarget callTarget) {
        return PFactory.trace(language, new PBuiltinFunction(PythonBuiltinClassType.PBuiltinFunction, PythonBuiltinClassType.PBuiltinFunction.getInstanceShape(language), name, type, PBuiltinFunction.generateDefaults(numDefaults), null, flags, callTarget));
    }

    public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString name, Object type, Object[] defaults, PKeyword[] kw, int flags, RootCallTarget callTarget) {
        return PFactory.trace(language, new PBuiltinFunction(PythonBuiltinClassType.PBuiltinFunction, PythonBuiltinClassType.PBuiltinFunction.getInstanceShape(language), name, type, defaults, kw, flags, callTarget));
    }

    public static PBuiltinFunction createWrapperDescriptor(PythonLanguage language, TruffleString name, Object type, int numDefaults, int flags, RootCallTarget callTarget, TpSlot slot, ExternalFunctionNodes.PExternalFunctionWrapper slotWrapper) {
        return PFactory.trace(language, new PBuiltinFunction(PythonBuiltinClassType.WrapperDescriptor, PythonBuiltinClassType.WrapperDescriptor.getInstanceShape(language), name, type, PBuiltinFunction.generateDefaults(numDefaults), null, flags, callTarget, slot, slotWrapper));
    }

    public static PBuiltinFunction createWrapperDescriptor(PythonLanguage language, TruffleString name, Object type, Object[] defaults, PKeyword[] kw, int flags, RootCallTarget callTarget, TpSlot slot, ExternalFunctionNodes.PExternalFunctionWrapper slotWrapper) {
        return PFactory.trace(language, new PBuiltinFunction(PythonBuiltinClassType.WrapperDescriptor, PythonBuiltinClassType.WrapperDescriptor.getInstanceShape(language), name, type, defaults, kw, flags, callTarget, slot, slotWrapper));
    }

    public static PBuiltinMethod createNewWrapper(PythonLanguage language, Object type, Object[] defaults, PKeyword[] kwdefaults, RootCallTarget callTarget, TpSlot slot) {
        PBuiltinFunction func = PFactory.createWrapperDescriptor(language, SpecialMethodNames.T___NEW__, type, defaults, kwdefaults, 3, callTarget, slot, ExternalFunctionNodes.PExternalFunctionWrapper.NEW);
        return PFactory.createBuiltinMethod(language, type, func);
    }

    public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, PBuiltinFunction function, Object klass) {
        PythonBuiltinClassType type = (PythonBuiltinClassType)((Object)function.getInitialPythonClass());
        return PFactory.trace(language, new PBuiltinFunction(type, type.getInstanceShape(language), function.getName(), klass, function.getDefaults(), function.getKwDefaults(), function.getFlags(), function.getCallTarget(), function.getSlot(), function.getSlotWrapper()));
    }

    public static GetSetDescriptor createGetSetDescriptor(PythonLanguage language, Object get, Object set, TruffleString name, Object type, boolean allowsDelete) {
        return PFactory.trace(language, new GetSetDescriptor(language, get, set, name, type, allowsDelete));
    }

    public static GetSetDescriptor createMemberDescriptor(PythonLanguage language, Object get, Object set, TruffleString name, Object type) {
        return PFactory.trace(language, new GetSetDescriptor((Object)PythonBuiltinClassType.MemberDescriptor, PythonBuiltinClassType.MemberDescriptor.getInstanceShape(language), get, set, name, type, set != null));
    }

    public static IndexedSlotDescriptor createIndexedSlotDescriptor(PythonLanguage language, TruffleString name, int index, Object type) {
        return PFactory.trace(language, new IndexedSlotDescriptor(language, name, index, type));
    }

    public static PDecoratedMethod createClassmethod(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PDecoratedMethod(cls, shape));
    }

    public static PDecoratedMethod createClassmethodFromCallableObj(PythonLanguage language, Object callable) {
        return PFactory.trace(language, new PDecoratedMethod((Object)PythonBuiltinClassType.PClassmethod, PythonBuiltinClassType.PClassmethod.getInstanceShape(language), callable));
    }

    public static PDecoratedMethod createBuiltinClassmethodFromCallableObj(PythonLanguage language, Object callable) {
        return PFactory.trace(language, new PDecoratedMethod((Object)PythonBuiltinClassType.PBuiltinClassMethod, PythonBuiltinClassType.PBuiltinClassMethod.getInstanceShape(language), callable));
    }

    public static PDecoratedMethod createInstancemethod(PythonLanguage language) {
        return PFactory.createInstancemethod(language, (Object)PythonBuiltinClassType.PInstancemethod, PythonBuiltinClassType.PInstancemethod.getInstanceShape(language));
    }

    public static PDecoratedMethod createInstancemethod(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PDecoratedMethod(cls, shape));
    }

    public static PDecoratedMethod createStaticmethod(PythonLanguage language) {
        return PFactory.createStaticmethod(language, (Object)PythonBuiltinClassType.PStaticmethod, PythonBuiltinClassType.PStaticmethod.getInstanceShape(language));
    }

    public static PDecoratedMethod createStaticmethod(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PDecoratedMethod(cls, shape));
    }

    public static PDecoratedMethod createStaticmethodFromCallableObj(PythonLanguage language, Object callable) {
        Object func;
        if (callable instanceof PBuiltinFunction) {
            PBuiltinFunction builtinFunction = (PBuiltinFunction)callable;
            func = PFactory.createBuiltinMethod(language, builtinFunction.getEnclosingType(), builtinFunction);
        } else {
            func = callable;
        }
        return PFactory.trace(language, new PDecoratedMethod((Object)PythonBuiltinClassType.PStaticmethod, PythonBuiltinClassType.PStaticmethod.getInstanceShape(language), func));
    }

    public static PList createList(PythonLanguage language) {
        return PFactory.createList(language, EmptySequenceStorage.INSTANCE);
    }

    public static PList createList(PythonLanguage language, Object[] array) {
        return PFactory.createList(language, new ObjectSequenceStorage(array));
    }

    public static PList createList(PythonLanguage language, SequenceStorage storage) {
        return PFactory.createList(language, storage, (PList.ListOrigin)null);
    }

    public static PList createList(PythonLanguage language, SequenceStorage storage, PList.ListOrigin origin) {
        return PFactory.createList(language, (Object)PythonBuiltinClassType.PList, PythonBuiltinClassType.PList.getInstanceShape(language), storage, origin);
    }

    public static PList createList(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.createList(language, cls, shape, EmptySequenceStorage.INSTANCE);
    }

    public static PList createList(PythonLanguage language, Object cls, Shape shape, SequenceStorage storage) {
        return PFactory.createList(language, cls, shape, storage, null);
    }

    public static PList createList(PythonLanguage language, Object cls, Shape shape, SequenceStorage storage, PList.ListOrigin origin) {
        return PFactory.trace(language, new PList(cls, shape, storage, origin));
    }

    public static PSet createSet(PythonLanguage language) {
        return PFactory.createSet(language, EmptyStorage.INSTANCE);
    }

    public static PSet createSet(PythonLanguage language, HashingStorage storage) {
        return PFactory.createSet(language, (Object)PythonBuiltinClassType.PSet, PythonBuiltinClassType.PSet.getInstanceShape(language), storage);
    }

    public static PSet createSet(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.createSet(language, cls, shape, EmptyStorage.INSTANCE);
    }

    public static PSet createSet(PythonLanguage language, Object cls, Shape shape, HashingStorage storage) {
        return PFactory.trace(language, new PSet(cls, shape, storage));
    }

    public static PFrozenSet createFrozenSet(PythonLanguage language) {
        return PFactory.createFrozenSet(language, EmptyStorage.INSTANCE);
    }

    public static PFrozenSet createFrozenSet(PythonLanguage language, HashingStorage storage) {
        return PFactory.createFrozenSet(language, (Object)PythonBuiltinClassType.PFrozenSet, PythonBuiltinClassType.PFrozenSet.getInstanceShape(language), storage);
    }

    public static PFrozenSet createFrozenSet(PythonLanguage language, Object cls, Shape shape, HashingStorage storage) {
        return PFactory.trace(language, new PFrozenSet(cls, shape, storage));
    }

    public static PDict createDict(PythonLanguage language) {
        return PFactory.createDict(language, EmptyStorage.INSTANCE);
    }

    public static PDict createDict(PythonLanguage language, PKeyword[] keywords) {
        return PFactory.createDict(language, new KeywordsStorage(keywords));
    }

    public static PDict createDict(PythonLanguage language, HashingStorage storage) {
        return PFactory.createDict(language, (Object)PythonBuiltinClassType.PDict, PythonBuiltinClassType.PDict.getInstanceShape(language), storage);
    }

    public static PDict createDict(PythonLanguage language, Object cls, Shape shape, HashingStorage storage) {
        return PFactory.trace(language, new PDict(cls, shape, storage));
    }

    public static POrderedDict createOrderedDict(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new POrderedDict(cls, shape));
    }

    public static PDictView.PDictKeysView createOrderedDictKeys(PythonLanguage language, POrderedDict dict) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.POrderedDictKeys;
        return PFactory.trace(language, new PDictView.PDictKeysView((Object)cls, cls.getInstanceShape(language), dict));
    }

    public static PDictView.PDictValuesView createOrderedDictValues(PythonLanguage language, POrderedDict dict) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.POrderedDictValues;
        return PFactory.trace(language, new PDictView.PDictValuesView((Object)cls, cls.getInstanceShape(language), dict));
    }

    public static PDictView.PDictItemsView createOrderedDictItems(PythonLanguage language, POrderedDict dict) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.POrderedDictItems;
        return PFactory.trace(language, new PDictView.PDictItemsView((Object)cls, cls.getInstanceShape(language), dict));
    }

    public static POrderedDictIterator createOrderedDictIterator(PythonLanguage language, POrderedDict dict, POrderedDictIterator.IteratorType type, boolean reversed) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.POrderedDictIterator;
        return PFactory.trace(language, new POrderedDictIterator((Object)cls, cls.getInstanceShape(language), dict, type, reversed));
    }

    public static PDict createDictFromMap(PythonLanguage language, LinkedHashMap<String, Object> map) {
        return PFactory.createDict(language, EconomicMapStorage.create(map));
    }

    public static PDict createDictFromMapGeneric(PythonLanguage language, LinkedHashMap<Object, Object> map) {
        return PFactory.createDict(language, EconomicMapStorage.createGeneric(map));
    }

    public static PDict createDictFixedStorage(PythonLanguage language, PythonObject pythonObject, MroSequenceStorage mroSequenceStorage) {
        return PFactory.createDict(language, new DynamicObjectStorage(pythonObject, mroSequenceStorage));
    }

    public static PDict createDictFixedStorage(PythonLanguage language, PythonObject pythonObject) {
        return PFactory.createDict(language, new DynamicObjectStorage(pythonObject));
    }

    public static PSimpleNamespace createSimpleNamespace(PythonLanguage language) {
        return PFactory.createSimpleNamespace(language, (Object)PythonBuiltinClassType.PSimpleNamespace, PythonBuiltinClassType.PSimpleNamespace.getInstanceShape(language));
    }

    public static PSimpleNamespace createSimpleNamespace(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PSimpleNamespace(cls, shape));
    }

    public static PKeyWrapper createKeyWrapper(PythonLanguage language, Object cmp) {
        return PFactory.trace(language, new PKeyWrapper((Object)PythonBuiltinClassType.PKeyWrapper, PythonBuiltinClassType.PKeyWrapper.getInstanceShape(language), cmp));
    }

    public static PPartial createPartial(PythonLanguage language, Object cls, Shape shape, Object function, Object[] args, PDict kwDict) {
        return PFactory.trace(language, new PPartial(cls, shape, function, args, kwDict));
    }

    public static LruCacheObject createLruCacheObject(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new LruCacheObject(cls, shape));
    }

    public static PDefaultDict createDefaultDict(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.createDefaultDict(language, cls, shape, PNone.NONE);
    }

    public static PDefaultDict createDefaultDict(PythonLanguage language, Object cls, Shape shape, Object defaultFactory) {
        return PFactory.trace(language, new PDefaultDict(cls, shape, defaultFactory));
    }

    public static PDefaultDict createDefaultDict(PythonLanguage language, Object defaultFactory, HashingStorage storage) {
        return PFactory.createDefaultDict(language, (Object)PythonBuiltinClassType.PDefaultDict, PythonBuiltinClassType.PDefaultDict.getInstanceShape(language), defaultFactory, storage);
    }

    public static PDefaultDict createDefaultDict(PythonLanguage language, Object cls, Shape shape, Object defaultFactory, HashingStorage storage) {
        return PFactory.trace(language, new PDefaultDict(cls, shape, storage, defaultFactory));
    }

    public static PDictView createDictKeysView(PythonLanguage language, PHashingCollection dict) {
        return PFactory.trace(language, new PDictView.PDictKeysView((Object)PythonBuiltinClassType.PDictKeysView, PythonBuiltinClassType.PDictKeysView.getInstanceShape(language), dict));
    }

    public static PDictView createDictKeysView(PythonLanguage language, Object dict, ForeignHashingStorage foreignHashingStorage) {
        return PFactory.trace(language, new PDictView.PDictKeysView((Object)PythonBuiltinClassType.PDictKeysView, PythonBuiltinClassType.PDictKeysView.getInstanceShape(language), dict, foreignHashingStorage));
    }

    public static PDictView createDictValuesView(PythonLanguage language, PHashingCollection dict) {
        return PFactory.trace(language, new PDictView.PDictValuesView((Object)PythonBuiltinClassType.PDictValuesView, PythonBuiltinClassType.PDictValuesView.getInstanceShape(language), dict));
    }

    public static PDictView createDictValuesView(PythonLanguage language, Object dict, ForeignHashingStorage foreignHashingStorage) {
        return PFactory.trace(language, new PDictView.PDictValuesView((Object)PythonBuiltinClassType.PDictValuesView, PythonBuiltinClassType.PDictValuesView.getInstanceShape(language), dict, foreignHashingStorage));
    }

    public static PDictView createDictItemsView(PythonLanguage language, PHashingCollection dict) {
        return PFactory.trace(language, new PDictView.PDictItemsView((Object)PythonBuiltinClassType.PDictItemsView, PythonBuiltinClassType.PDictItemsView.getInstanceShape(language), dict));
    }

    public static PDictView createDictItemsView(PythonLanguage language, Object dict, ForeignHashingStorage foreignHashingStorage) {
        return PFactory.trace(language, new PDictView.PDictItemsView((Object)PythonBuiltinClassType.PDictItemsView, PythonBuiltinClassType.PDictItemsView.getInstanceShape(language), dict, foreignHashingStorage));
    }

    public static PGenerator createGenerator(PythonLanguage language, TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments) {
        return PFactory.trace(language, PGenerator.create(language, name, qualname, rootNode, callTargets, arguments, PythonBuiltinClassType.PGenerator));
    }

    public static PGenerator createGenerator(PythonLanguage language, TruffleString name, TruffleString qualname, PBytecodeDSLRootNode rootNode, Object[] arguments) {
        return PFactory.trace(language, PGenerator.create(language, name, qualname, rootNode, arguments, PythonBuiltinClassType.PGenerator));
    }

    public static PGenerator createIterableCoroutine(PythonLanguage language, TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments) {
        return PFactory.trace(language, PGenerator.create(language, name, qualname, rootNode, callTargets, arguments, PythonBuiltinClassType.PGenerator, true));
    }

    public static PGenerator createIterableCoroutine(PythonLanguage language, TruffleString name, TruffleString qualname, PBytecodeDSLRootNode rootNode, Object[] arguments) {
        return PFactory.trace(language, PGenerator.create(language, name, qualname, rootNode, arguments, PythonBuiltinClassType.PGenerator, true));
    }

    public static PGenerator createCoroutine(PythonLanguage language, TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments) {
        return PFactory.trace(language, PGenerator.create(language, name, qualname, rootNode, callTargets, arguments, PythonBuiltinClassType.PCoroutine));
    }

    public static PGenerator createCoroutine(PythonLanguage language, TruffleString name, TruffleString qualname, PBytecodeDSLRootNode rootNode, Object[] arguments) {
        return PFactory.trace(language, PGenerator.create(language, name, qualname, rootNode, arguments, PythonBuiltinClassType.PCoroutine));
    }

    public static PCoroutineWrapper createCoroutineWrapper(PythonLanguage language, PGenerator generator) {
        return PFactory.trace(language, new PCoroutineWrapper(language, generator));
    }

    public static PAsyncGen createAsyncGenerator(PythonLanguage language, TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments) {
        return PFactory.trace(language, PAsyncGen.create(language, name, qualname, rootNode, callTargets, arguments));
    }

    public static PANextAwaitable createANextAwaitable(PythonLanguage language, Object wrapped, Object defaultValue) {
        return PFactory.trace(language, new PANextAwaitable((Object)PythonBuiltinClassType.PAnextAwaitable, PythonBuiltinClassType.PAnextAwaitable.getInstanceShape(language), wrapped, defaultValue));
    }

    public static PMappingproxy createMappingproxy(PythonLanguage language, Object object) {
        return PFactory.createMappingproxy(language, (Object)PythonBuiltinClassType.PMappingproxy, PythonBuiltinClassType.PMappingproxy.getInstanceShape(language), object);
    }

    public static PMappingproxy createMappingproxy(PythonLanguage language, Object cls, Shape shape, Object object) {
        return PFactory.trace(language, new PMappingproxy(cls, shape, object));
    }

    public static PReferenceType createReferenceType(PythonLanguage language, Object object) {
        return PFactory.createReferenceType(language, (Object)PythonBuiltinClassType.PReferenceType, PythonBuiltinClassType.PReferenceType.getInstanceShape(language), object);
    }

    public static PReferenceType createReferenceType(PythonLanguage language, Object cls, Shape shape, Object object) {
        return PFactory.createReferenceType(language, cls, shape, object, null, null);
    }

    public static PReferenceType createReferenceType(PythonLanguage language, Object cls, Shape shape, Object object, Object callback, ReferenceQueue<Object> queue) {
        return PFactory.trace(language, new PReferenceType(cls, shape, object, callback, queue));
    }

    public static PCell createCell(PythonLanguage language, Assumption effectivelyFinal) {
        return PFactory.trace(language, new PCell(effectivelyFinal));
    }

    public static PFrame createPFrame(PythonLanguage language, PFrame.Reference frameInfo, Node location, MaterializedFrame locals) {
        return PFactory.trace(language, new PFrame(language, frameInfo, location, locals));
    }

    public static PFrame createPFrame(PythonLanguage language, Object threadState, PCode code, PythonObject globals, Object localsDict) {
        return PFactory.trace(language, new PFrame(language, threadState, code, globals, localsDict));
    }

    public static PTraceback createTraceback(PythonLanguage language, PFrame frame, int lineno, PTraceback next) {
        return PFactory.trace(language, new PTraceback(language, frame, lineno, -1, next));
    }

    public static PTraceback createTracebackWithLasti(PythonLanguage language, PFrame frame, int lineno, int lasti, PTraceback next) {
        return PFactory.trace(language, new PTraceback(language, frame, lineno, lasti, next));
    }

    public static PTraceback createTraceback(PythonLanguage language, LazyTraceback tb) {
        return PFactory.trace(language, new PTraceback(language, tb));
    }

    public static PBaseException createBaseException(PythonLanguage language, Object cls, Shape shape, PTuple args) {
        return PFactory.createBaseException(language, cls, shape, null, args);
    }

    public static PBaseException createBaseException(PythonLanguage language, PythonBuiltinClassType cls, PTuple args) {
        return PFactory.createBaseException(language, (Object)cls, cls.getInstanceShape(language), null, args);
    }

    public static PBaseException createBaseException(PythonLanguage language, PythonBuiltinClassType type, Object[] data, PTuple args) {
        return PFactory.createBaseException(language, (Object)type, type.getInstanceShape(language), data, args);
    }

    public static PBaseException createBaseException(PythonLanguage language, Object cls, Shape shape, Object[] data, PTuple args) {
        return PFactory.trace(language, new PBaseException(cls, shape, data, args));
    }

    public static PBaseException createBaseException(PythonLanguage language, Object cls, Shape shape, TruffleString format, Object[] formatArgs) {
        return PFactory.createBaseException(language, cls, shape, null, format, formatArgs);
    }

    public static PBaseException createBaseException(PythonLanguage language, PythonBuiltinClassType type, TruffleString format, Object[] formatArgs) {
        return PFactory.createBaseException(language, (Object)type, type.getInstanceShape(language), null, format, formatArgs);
    }

    public static PBaseException createBaseException(PythonLanguage language, PythonBuiltinClassType type, Object[] data, TruffleString format, Object[] formatArgs) {
        return PFactory.createBaseException(language, (Object)type, type.getInstanceShape(language), data, format, formatArgs);
    }

    public static PBaseException createBaseException(PythonLanguage language, Object cls, Shape shape, Object[] data, TruffleString format, Object[] formatArgs) {
        assert (format != null);
        return PFactory.trace(language, new PBaseException(cls, shape, data, format, formatArgs));
    }

    public static PBaseException createBaseException(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PBaseException(cls, shape, null));
    }

    public static PBaseException createBaseException(PythonLanguage language, PythonBuiltinClassType type) {
        return PFactory.trace(language, new PBaseException((Object)type, type.getInstanceShape(language), null));
    }

    public static PBaseException createBaseException(PythonLanguage language, PythonBuiltinClassType type, TruffleString format) {
        return PFactory.trace(language, new PBaseException((Object)type, type.getInstanceShape(language), null, format, PythonUtils.EMPTY_OBJECT_ARRAY));
    }

    public static PBaseExceptionGroup createBaseExceptionGroup(PythonLanguage language, Object cls, Shape shape, TruffleString message, Object[] exceptions, Object[] args) {
        return PFactory.trace(language, new PBaseExceptionGroup(cls, shape, message, exceptions, PFactory.createTuple(language, args)));
    }

    public static PArray createArray(PythonLanguage language, Object cls, Shape shape, TruffleString formatString, BufferFormat format) {
        assert (format != null);
        return PFactory.trace(language, new PArray(cls, shape, formatString, format));
    }

    public static PArray createArray(PythonLanguage language, TruffleString formatString, BufferFormat format, int length) throws OverflowException {
        return PFactory.createArray(language, (Object)PythonBuiltinClassType.PArray, PythonBuiltinClassType.PArray.getInstanceShape(language), formatString, format, length);
    }

    public static PArray createArray(PythonLanguage language, Object cls, Shape shape, TruffleString formatString, BufferFormat format, int length) throws OverflowException {
        assert (format != null);
        int byteSize = PythonUtils.multiplyExact(length, format.bytesize);
        return PFactory.trace(language, new PArray(cls, shape, formatString, format, byteSize));
    }

    public static PByteArray createByteArray(PythonLanguage language, byte[] array) {
        return PFactory.createByteArray(language, array, array.length);
    }

    public static PByteArray createByteArray(PythonLanguage language, Object cls, Shape shape, byte[] array) {
        return PFactory.createByteArray(language, cls, shape, array, array.length);
    }

    public static PByteArray createByteArray(PythonLanguage language, byte[] array, int length) {
        return PFactory.createByteArray(language, new ByteSequenceStorage(array, length));
    }

    public static PByteArray createByteArray(PythonLanguage language, Object cls, Shape shape, byte[] array, int length) {
        return PFactory.createByteArray(language, cls, shape, new ByteSequenceStorage(array, length));
    }

    public static PByteArray createByteArray(PythonLanguage language, SequenceStorage storage) {
        return PFactory.createByteArray(language, (Object)PythonBuiltinClassType.PByteArray, PythonBuiltinClassType.PByteArray.getInstanceShape(language), storage);
    }

    public static PByteArray createByteArray(PythonLanguage language, Object cls, Shape shape, SequenceStorage storage) {
        return PFactory.trace(language, new PByteArray(cls, shape, storage));
    }

    public static PStringIterator createStringIterator(PythonLanguage language, TruffleString str) {
        return PFactory.trace(language, new PStringIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(language), str));
    }

    public static PStringReverseIterator createStringReverseIterator(PythonLanguage language, Object cls, Shape shape, TruffleString str) {
        return PFactory.trace(language, new PStringReverseIterator(cls, shape, str));
    }

    public static PIntegerSequenceIterator createIntegerSequenceIterator(PythonLanguage language, IntSequenceStorage storage, Object list) {
        return PFactory.trace(language, new PIntegerSequenceIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(language), storage, list));
    }

    public static PLongSequenceIterator createLongSequenceIterator(PythonLanguage language, LongSequenceStorage storage, Object list) {
        return PFactory.trace(language, new PLongSequenceIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(language), storage, list));
    }

    public static PDoubleSequenceIterator createDoubleSequenceIterator(PythonLanguage language, DoubleSequenceStorage storage, Object list) {
        return PFactory.trace(language, new PDoubleSequenceIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(language), storage, list));
    }

    public static PObjectSequenceIterator createObjectSequenceIterator(PythonLanguage language, ObjectSequenceStorage storage, Object list) {
        return PFactory.trace(language, new PObjectSequenceIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(language), storage, list));
    }

    public static PSequenceIterator createSequenceIterator(PythonLanguage language, Object sequence) {
        return PFactory.trace(language, new PSequenceIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(language), sequence));
    }

    public static PSequenceReverseIterator createSequenceReverseIterator(PythonLanguage language, Object sequence, int lengthHint) {
        return PFactory.createSequenceReverseIterator(language, (Object)PythonBuiltinClassType.PReverseIterator, PythonBuiltinClassType.PReverseIterator.getInstanceShape(language), sequence, lengthHint);
    }

    public static PSequenceReverseIterator createSequenceReverseIterator(PythonLanguage language, Object cls, Shape shape, Object sequence, int lengthHint) {
        return PFactory.trace(language, new PSequenceReverseIterator(cls, shape, sequence, lengthHint));
    }

    public static PIntRangeIterator createIntRangeIterator(PythonLanguage language, PIntRange fastRange) {
        return PFactory.createIntRangeIterator(language, fastRange.getIntStart(), fastRange.getIntStop(), fastRange.getIntStep(), fastRange.getIntLength());
    }

    public static PIntRangeIterator createIntRangeIterator(PythonLanguage language, int start, int stop, int step, int len) {
        return PFactory.trace(language, new PIntRangeIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(language), start, stop, step, len));
    }

    public static PBigRangeIterator createBigRangeIterator(PythonLanguage language, PInt start, PInt stop, PInt step, PInt len) {
        return PFactory.trace(language, new PBigRangeIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(language), start, stop, step, len));
    }

    public static PBigRangeIterator createBigRangeIterator(PythonLanguage language, PBigRange longRange) {
        return PFactory.createBigRangeIterator(language, longRange.getPIntStart(), longRange.getPIntStop(), longRange.getPIntStep(), longRange.getPIntLength());
    }

    public static PBigRangeIterator createBigRangeIterator(PythonLanguage language, BigInteger start, BigInteger stop, BigInteger step, BigInteger len) {
        return PFactory.createBigRangeIterator(language, PFactory.createInt(language, start), PFactory.createInt(language, stop), PFactory.createInt(language, step), PFactory.createInt(language, len));
    }

    public static PArrayIterator createArrayIterator(PythonLanguage language, PArray array) {
        return PFactory.trace(language, new PArrayIterator((Object)PythonBuiltinClassType.PArrayIterator, PythonBuiltinClassType.PArrayIterator.getInstanceShape(language), array));
    }

    public static PBaseSetIterator createBaseSetIterator(PythonLanguage language, PBaseSet set, HashingStorageNodes.HashingStorageIterator iterator, int initialSize) {
        return PFactory.trace(language, new PBaseSetIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(language), set, iterator, initialSize));
    }

    public static PDictView.PDictItemIterator createDictItemIterator(PythonLanguage language, HashingStorageNodes.HashingStorageIterator iterator, HashingStorage hashingStorage, int initialSize) {
        return PFactory.trace(language, new PDictView.PDictItemIterator((Object)PythonBuiltinClassType.PDictItemIterator, PythonBuiltinClassType.PDictItemIterator.getInstanceShape(language), iterator, hashingStorage, initialSize));
    }

    public static PDictView.PDictKeyIterator createDictKeyIterator(PythonLanguage language, HashingStorageNodes.HashingStorageIterator iterator, HashingStorage hashingStorage, int initialSize) {
        return PFactory.trace(language, new PDictView.PDictKeyIterator((Object)PythonBuiltinClassType.PDictKeyIterator, PythonBuiltinClassType.PDictKeyIterator.getInstanceShape(language), iterator, hashingStorage, initialSize));
    }

    public static PDictView.PDictValueIterator createDictValueIterator(PythonLanguage language, HashingStorageNodes.HashingStorageIterator iterator, HashingStorage hashingStorage, int initialSize) {
        return PFactory.trace(language, new PDictView.PDictValueIterator((Object)PythonBuiltinClassType.PDictValueIterator, PythonBuiltinClassType.PDictValueIterator.getInstanceShape(language), iterator, hashingStorage, initialSize));
    }

    public static Object createSentinelIterator(PythonLanguage language, Object callable, Object sentinel) {
        return PFactory.trace(language, new PSentinelIterator((Object)PythonBuiltinClassType.PSentinelIterator, PythonBuiltinClassType.PSentinelIterator.getInstanceShape(language), callable, sentinel));
    }

    public static PEnumerate createEnumerate(PythonLanguage language, Object cls, Shape shape, Object iterator, long start) {
        return PFactory.trace(language, new PEnumerate(cls, shape, iterator, start));
    }

    public static PEnumerate createEnumerate(PythonLanguage language, Object cls, Shape shape, Object iterator, PInt start) {
        return PFactory.trace(language, new PEnumerate(cls, shape, iterator, start));
    }

    public static PMap createMap(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PMap(cls, shape));
    }

    public static PZip createZip(PythonLanguage language, Object cls, Shape shape, Object[] iterables, boolean strict) {
        return PFactory.trace(language, new PZip(cls, shape, iterables, strict));
    }

    public static PCode createCode(PythonLanguage language, RootCallTarget ct) {
        return PFactory.trace(language, new PCode((Object)PythonBuiltinClassType.PCode, PythonBuiltinClassType.PCode.getInstanceShape(language), ct));
    }

    public static PCode createCode(PythonLanguage language, RootCallTarget ct, int flags, int firstlineno, byte[] linetable, TruffleString filename) {
        return PFactory.trace(language, new PCode((Object)PythonBuiltinClassType.PCode, PythonBuiltinClassType.PCode.getInstanceShape(language), ct, flags, firstlineno, linetable, filename));
    }

    public static PCode createCode(PythonLanguage language, RootCallTarget callTarget, Signature signature, BytecodeCodeUnit codeUnit) {
        return PFactory.trace(language, new PCode((Object)PythonBuiltinClassType.PCode, PythonBuiltinClassType.PCode.getInstanceShape(language), callTarget, signature, codeUnit));
    }

    public static PCode createCode(PythonLanguage language, RootCallTarget callTarget, Signature signature, BytecodeDSLCodeUnit codeUnit) {
        return PFactory.trace(language, new PCode((Object)PythonBuiltinClassType.PCode, PythonBuiltinClassType.PCode.getInstanceShape(language), callTarget, signature, codeUnit));
    }

    public static PCode createCode(PythonLanguage language, RootCallTarget callTarget, Signature signature, int nlocals, int stacksize, int flags, Object[] constants, TruffleString[] names, TruffleString[] varnames, TruffleString[] freevars, TruffleString[] cellvars, TruffleString filename, TruffleString name, TruffleString qualname, int firstlineno, byte[] linetable) {
        return PFactory.trace(language, new PCode((Object)PythonBuiltinClassType.PCode, PythonBuiltinClassType.PCode.getInstanceShape(language), callTarget, signature, nlocals, stacksize, flags, constants, names, varnames, freevars, cellvars, filename, name, qualname, firstlineno, linetable));
    }

    public static PSocket createSocket(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PSocket(cls, shape));
    }

    public static PThreadLocal createThreadLocal(PythonLanguage language, Object cls, Shape shape, Object[] args, PKeyword[] kwArgs) {
        return PFactory.trace(language, new PThreadLocal(cls, shape, args, kwArgs));
    }

    public static PLock createLock(PythonLanguage language) {
        return PFactory.createLock(language, (Object)PythonBuiltinClassType.PLock, PythonBuiltinClassType.PLock.getInstanceShape(language));
    }

    public static PLock createLock(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PLock(cls, shape));
    }

    public static PRLock createRLock(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PRLock(cls, shape));
    }

    public static PSemLock createSemLock(PythonLanguage language, Object cls, Shape shape, long handle, int kind, int maxValue, TruffleString name) {
        return PFactory.trace(language, new PSemLock(cls, shape, handle, kind, maxValue, name));
    }

    public static PGraalPySemLock createGraalPySemLock(PythonLanguage language, TruffleString name, int kind, Semaphore sharedSemaphore) {
        return PFactory.createGraalPySemLock(language, (Object)PythonBuiltinClassType.PGraalPySemLock, PythonBuiltinClassType.PGraalPySemLock.getInstanceShape(language), name, kind, sharedSemaphore);
    }

    public static PGraalPySemLock createGraalPySemLock(PythonLanguage language, Object cls, Shape shape, TruffleString name, int kind, Semaphore sharedSemaphore) {
        return PFactory.trace(language, new PGraalPySemLock(cls, shape, name, kind, sharedSemaphore));
    }

    public static PScandirIterator createScandirIterator(PythonLanguage language, PythonContext context, Object dirStream, PosixModuleBuiltins.PosixFileHandle path, boolean needsRewind) {
        return PFactory.trace(language, new PScandirIterator((Object)PythonBuiltinClassType.PScandirIterator, PythonBuiltinClassType.PScandirIterator.getInstanceShape(language), context, dirStream, path, needsRewind));
    }

    public static PDirEntry createDirEntry(PythonLanguage language, Object dirEntryData, PosixModuleBuiltins.PosixFileHandle path) {
        return PFactory.trace(language, new PDirEntry((Object)PythonBuiltinClassType.PDirEntry, PythonBuiltinClassType.PDirEntry.getInstanceShape(language), dirEntryData, path));
    }

    public static PEncodingMap createEncodingMap(PythonLanguage language, int count2, int count3, byte[] level1, byte[] level23) {
        return PFactory.trace(language, new PEncodingMap((Object)PythonBuiltinClassType.PEncodingMap, PythonBuiltinClassType.PEncodingMap.getInstanceShape(language), count2, count3, level1, level23));
    }

    public static PMMap createMMap(PythonLanguage language, PythonContext context, Object cls, Shape shape, Object mmapHandle, int fd, long length, int access) {
        return PFactory.trace(language, new PMMap(cls, shape, context, mmapHandle, fd, length, access));
    }

    public static BZ2Object.BZ2Compressor createBZ2Compressor(PythonLanguage language) {
        return PFactory.createBZ2Compressor(language, (Object)PythonBuiltinClassType.BZ2Compressor, PythonBuiltinClassType.BZ2Compressor.getInstanceShape(language));
    }

    public static BZ2Object.BZ2Compressor createBZ2Compressor(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, BZ2Object.createCompressor(cls, shape));
    }

    public static BZ2Object.BZ2Decompressor createBZ2Decompressor(PythonLanguage language) {
        return PFactory.createBZ2Decompressor(language, (Object)PythonBuiltinClassType.BZ2Decompressor, PythonBuiltinClassType.BZ2Decompressor.getInstanceShape(language));
    }

    public static BZ2Object.BZ2Decompressor createBZ2Decompressor(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, BZ2Object.createDecompressor(cls, shape));
    }

    public static JavaCompress createJavaZLibCompObjectCompress(PythonLanguage language, int level, int wbits, int strategy, byte[] zdict) {
        return PFactory.trace(language, new JavaCompress((Object)PythonBuiltinClassType.ZlibCompress, PythonBuiltinClassType.ZlibCompress.getInstanceShape(language), level, wbits, strategy, zdict));
    }

    public static JavaDecompress createJavaZLibCompObjectDecompress(PythonLanguage language, int wbits, byte[] zdict) {
        return PFactory.trace(language, new JavaDecompress((Object)PythonBuiltinClassType.ZlibDecompress, PythonBuiltinClassType.ZlibDecompress.getInstanceShape(language), wbits, zdict));
    }

    public static ZLibCompObject createNativeZLibCompObjectCompress(PythonLanguage language, Object zst, NFIZlibSupport zlibSupport) {
        return PFactory.createNativeZLibCompObject(language, (Object)PythonBuiltinClassType.ZlibCompress, PythonBuiltinClassType.ZlibCompress.getInstanceShape(language), zst, zlibSupport);
    }

    public static ZLibCompObject createNativeZLibCompObjectDecompress(PythonLanguage language, Object zst, NFIZlibSupport zlibSupport) {
        return PFactory.createNativeZLibCompObject(language, (Object)PythonBuiltinClassType.ZlibDecompress, PythonBuiltinClassType.ZlibDecompress.getInstanceShape(language), zst, zlibSupport);
    }

    public static ZLibCompObject createNativeZLibCompObject(PythonLanguage language, Object cls, Shape shape, Object zst, NFIZlibSupport zlibSupport) {
        return PFactory.trace(language, new NativeZlibCompObject(cls, shape, zst, zlibSupport));
    }

    public static ZlibDecompressorObject createJavaZlibDecompressorObject(PythonLanguage language, int wbits, byte[] zdict) {
        return PFactory.trace(language, ZlibDecompressorObject.createJava((Object)PythonBuiltinClassType.ZlibDecompressor, PythonBuiltinClassType.ZlibDecompressor.getInstanceShape(language), wbits, zdict));
    }

    public static ZlibDecompressorObject createNativeZlibDecompressorObject(PythonLanguage language, Object zst, NFIZlibSupport zlibSupport) {
        return PFactory.trace(language, ZlibDecompressorObject.createNative((Object)PythonBuiltinClassType.ZlibDecompressor, PythonBuiltinClassType.ZlibDecompressor.getInstanceShape(language), zst, zlibSupport));
    }

    public static LZMAObject.LZMADecompressor createLZMADecompressor(PythonLanguage language, Object cls, Shape shape, boolean isNative) {
        return PFactory.trace(language, LZMAObject.createDecompressor(cls, shape, isNative));
    }

    public static LZMAObject.LZMACompressor createLZMACompressor(PythonLanguage language, Object cls, Shape shape, boolean isNative) {
        return PFactory.trace(language, LZMAObject.createCompressor(cls, shape, isNative));
    }

    public static CSVReader createCSVReader(PythonLanguage language, Object inputIter, CSVDialect dialect) {
        return PFactory.createCSVReader(language, (Object)PythonBuiltinClassType.CSVReader, PythonBuiltinClassType.CSVReader.getInstanceShape(language), inputIter, dialect);
    }

    public static CSVReader createCSVReader(PythonLanguage language, Object cls, Shape shape, Object inputIter, CSVDialect dialect) {
        return PFactory.trace(language, new CSVReader(cls, shape, inputIter, dialect));
    }

    public static CSVWriter createCSVWriter(PythonLanguage language, Object write, CSVDialect dialect) {
        return PFactory.createCSVWriter(language, (Object)PythonBuiltinClassType.CSVWriter, PythonBuiltinClassType.CSVWriter.getInstanceShape(language), write, dialect);
    }

    public static CSVWriter createCSVWriter(PythonLanguage language, Object cls, Shape shape, Object write, CSVDialect dialect) {
        return PFactory.trace(language, new CSVWriter(cls, shape, write, dialect));
    }

    public static CSVDialect createCSVDialect(PythonLanguage language, Object cls, Shape shape, TruffleString delimiter, int delimiterCodePoint, boolean doubleQuote, TruffleString escapeChar, int escapeCharCodePoint, TruffleString lineTerminator, TruffleString quoteChar, int quoteCharCodePoint, QuoteStyle quoting, boolean skipInitialSpace, boolean strict) {
        return PFactory.trace(language, new CSVDialect(cls, shape, delimiter, delimiterCodePoint, doubleQuote, escapeChar, escapeCharCodePoint, lineTerminator, quoteChar, quoteCharCodePoint, quoting, skipInitialSpace, strict));
    }

    public static PFileIO createFileIO(PythonLanguage language) {
        return PFactory.createFileIO(language, (Object)PythonBuiltinClassType.PFileIO, PythonBuiltinClassType.PFileIO.getInstanceShape(language));
    }

    public static PFileIO createFileIO(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PFileIO(cls, shape));
    }

    public static PChain createChain(PythonLanguage language) {
        return PFactory.createChain(language, (Object)PythonBuiltinClassType.PChain, PythonBuiltinClassType.PChain.getInstanceShape(language));
    }

    public static PChain createChain(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PChain(cls, shape));
    }

    public static PCount createCount(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PCount(cls, shape));
    }

    public static PIslice createIslice(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PIslice(cls, shape));
    }

    public static PPairwise createPairwise(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PPairwise(cls, shape));
    }

    public static PPermutations createPermutations(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PPermutations(cls, shape));
    }

    public static PProduct createProduct(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PProduct(cls, shape));
    }

    public static PRepeat createRepeat(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PRepeat(cls, shape));
    }

    public static PAccumulate createAccumulate(PythonLanguage language) {
        return PFactory.createAccumulate(language, (Object)PythonBuiltinClassType.PAccumulate, PythonBuiltinClassType.PAccumulate.getInstanceShape(language));
    }

    public static PAccumulate createAccumulate(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PAccumulate(cls, shape));
    }

    public static PDropwhile createDropwhile(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PDropwhile(cls, shape));
    }

    public static PCombinations createCombinations(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PCombinations(cls, shape));
    }

    public static PCombinationsWithReplacement createCombinationsWithReplacement(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PCombinationsWithReplacement(cls, shape));
    }

    public static PCompress createCompress(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PCompress(cls, shape));
    }

    public static PCycle createCycle(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PCycle(cls, shape));
    }

    public static PFilterfalse createFilterfalse(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PFilterfalse(cls, shape));
    }

    public static PGroupBy createGroupBy(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PGroupBy(cls, shape));
    }

    public static PGrouper createGrouper(PythonLanguage language, PGroupBy parent, Object tgtKey) {
        return PFactory.trace(language, new PGrouper(parent, tgtKey, (Object)PythonBuiltinClassType.PGrouper, PythonBuiltinClassType.PGrouper.getInstanceShape(language)));
    }

    public static PTee createTee(PythonLanguage language, PTeeDataObject dataObj, int index) {
        return PFactory.trace(language, new PTee(dataObj, index, (Object)PythonBuiltinClassType.PTee, PythonBuiltinClassType.PTee.getInstanceShape(language)));
    }

    public static PStarmap createStarmap(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PStarmap(cls, shape));
    }

    public static PTakewhile createTakewhile(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PTakewhile(cls, shape));
    }

    public static PTeeDataObject createTeeDataObject(PythonLanguage language) {
        return PFactory.trace(language, new PTeeDataObject((Object)PythonBuiltinClassType.PTeeDataObject, PythonBuiltinClassType.PTeeDataObject.getInstanceShape(language)));
    }

    public static PTeeDataObject createTeeDataObject(PythonLanguage language, Object it) {
        return PFactory.trace(language, new PTeeDataObject(it, (Object)PythonBuiltinClassType.PTeeDataObject, PythonBuiltinClassType.PTeeDataObject.getInstanceShape(language)));
    }

    public static PZipLongest createZipLongest(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PZipLongest(cls, shape));
    }

    public static PBatched createBatched(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PBatched(cls, shape));
    }

    public static PTextIO createTextIO(PythonLanguage language) {
        return PFactory.createTextIO(language, (Object)PythonBuiltinClassType.PTextIOWrapper, PythonBuiltinClassType.PTextIOWrapper.getInstanceShape(language));
    }

    public static PTextIO createTextIO(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PTextIO(cls, shape));
    }

    public static PStringIO createStringIO(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PStringIO(cls, shape));
    }

    public static PBytesIO createBytesIO(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PBytesIO(cls, shape));
    }

    public static PBytesIOBuffer createBytesIOBuf(PythonLanguage language, PBytesIO source) {
        return PFactory.createBytesIOBuf(language, (Object)PythonBuiltinClassType.PBytesIOBuf, PythonBuiltinClassType.PBytesIOBuf.getInstanceShape(language), source);
    }

    public static PBytesIOBuffer createBytesIOBuf(PythonLanguage language, Object cls, Shape shape, PBytesIO source) {
        return PFactory.trace(language, new PBytesIOBuffer(cls, shape, source));
    }

    public static PNLDecoder createNLDecoder(PythonLanguage language) {
        return PFactory.createNLDecoder(language, (Object)PythonBuiltinClassType.PIncrementalNewlineDecoder, PythonBuiltinClassType.PIncrementalNewlineDecoder.getInstanceShape(language));
    }

    public static PNLDecoder createNLDecoder(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PNLDecoder(cls, shape));
    }

    public static PBuffered createBufferedReader(PythonLanguage language) {
        return PFactory.createBufferedReader(language, (Object)PythonBuiltinClassType.PBufferedReader, PythonBuiltinClassType.PBufferedReader.getInstanceShape(language));
    }

    public static PBuffered createBufferedReader(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PBuffered(cls, shape, true, false));
    }

    public static PBuffered createBufferedWriter(PythonLanguage language) {
        return PFactory.createBufferedWriter(language, (Object)PythonBuiltinClassType.PBufferedWriter, PythonBuiltinClassType.PBufferedWriter.getInstanceShape(language));
    }

    public static PBuffered createBufferedWriter(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PBuffered(cls, shape, false, true));
    }

    public static PBuffered createBufferedRandom(PythonLanguage language) {
        return PFactory.createBufferedRandom(language, (Object)PythonBuiltinClassType.PBufferedRandom, PythonBuiltinClassType.PBufferedRandom.getInstanceShape(language));
    }

    public static PBuffered createBufferedRandom(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PBuffered(cls, shape, true, true));
    }

    public static PRWPair createRWPair(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PRWPair(cls, shape));
    }

    public static PyCArgObject createCArgObject(PythonLanguage language) {
        return PFactory.trace(language, new PyCArgObject((Object)PythonBuiltinClassType.CArgObject, PythonBuiltinClassType.CArgObject.getInstanceShape(language)));
    }

    public static CThunkObject createCThunkObject(PythonLanguage language, int nArgs) {
        return PFactory.createCThunkObject(language, (Object)PythonBuiltinClassType.CThunkObject, PythonBuiltinClassType.CThunkObject.getInstanceShape(language), nArgs);
    }

    public static CThunkObject createCThunkObject(PythonLanguage language, Object cls, Shape shape, int nArgs) {
        return PFactory.trace(language, new CThunkObject(cls, shape, nArgs));
    }

    public static CDataObject createCDataObject(PythonLanguage language, Object cls, Shape shape, Pointer b_ptr, int b_size, boolean b_needsfree) {
        return PFactory.trace(language, new CDataObject(cls, shape, b_ptr, b_size, b_needsfree));
    }

    public static PyCFuncPtrObject createPyCFuncPtrObject(PythonLanguage language, Object cls, Shape shape, Pointer b_ptr, int b_size, boolean b_needsfree) {
        return PFactory.trace(language, new PyCFuncPtrObject(cls, shape, b_ptr, b_size, b_needsfree));
    }

    public static CFieldObject createCFieldObject(PythonLanguage language) {
        return PFactory.createCFieldObject(language, (Object)PythonBuiltinClassType.CField, PythonBuiltinClassType.CField.getInstanceShape(language));
    }

    public static CFieldObject createCFieldObject(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new CFieldObject(cls, shape));
    }

    public static StgDictObject createStgDictObject(PythonLanguage language) {
        return PFactory.createStgDictObject(language, (Object)PythonBuiltinClassType.StgDict, PythonBuiltinClassType.StgDict.getInstanceShape(language));
    }

    public static StgDictObject createStgDictObject(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new StgDictObject(cls, shape));
    }

    public static PSSLContext createSSLContext(PythonLanguage language, Object cls, Shape shape, SSLMethod method, int verifyFlags, boolean checkHostname, int verifyMode, SSLContext context) {
        return PFactory.trace(language, new PSSLContext(cls, shape, method, verifyFlags, checkHostname, verifyMode, context));
    }

    public static PSSLSocket createSSLSocket(PythonLanguage language, PSSLContext context, SSLEngine engine, PSocket socket) {
        return PFactory.createSSLSocket(language, (Object)PythonBuiltinClassType.PSSLSocket, PythonBuiltinClassType.PSSLSocket.getInstanceShape(language), context, engine, socket);
    }

    public static PSSLSocket createSSLSocket(PythonLanguage language, Object cls, Shape shape, PSSLContext context, SSLEngine engine, PSocket socket) {
        return PFactory.trace(language, new PSSLSocket(cls, shape, context, engine, socket, PFactory.createMemoryBIO(language), PFactory.createMemoryBIO(language), PFactory.createMemoryBIO(language)));
    }

    public static PSSLSocket createSSLSocket(PythonLanguage language, PSSLContext context, SSLEngine engine, PMemoryBIO inbound, PMemoryBIO outbound) {
        return PFactory.createSSLSocket(language, (Object)PythonBuiltinClassType.PSSLSocket, PythonBuiltinClassType.PSSLSocket.getInstanceShape(language), context, engine, inbound, outbound);
    }

    public static PSSLSocket createSSLSocket(PythonLanguage language, Object cls, Shape shape, PSSLContext context, SSLEngine engine, PMemoryBIO inbound, PMemoryBIO outbound) {
        return PFactory.trace(language, new PSSLSocket(cls, shape, context, engine, null, inbound, outbound, PFactory.createMemoryBIO(language)));
    }

    public static PMemoryBIO createMemoryBIO(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PMemoryBIO(cls, shape));
    }

    public static PMemoryBIO createMemoryBIO(PythonLanguage language) {
        return PFactory.trace(language, new PMemoryBIO((Object)PythonBuiltinClassType.PMemoryBIO, PythonBuiltinClassType.PMemoryBIO.getInstanceShape(language)));
    }

    public static PProperty createProperty(PythonLanguage language) {
        return PFactory.trace(language, new PProperty((Object)PythonBuiltinClassType.PProperty, PythonBuiltinClassType.PProperty.getInstanceShape(language)));
    }

    public static PProperty createProperty(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PProperty(cls, shape));
    }

    @CompilerDirectives.TruffleBoundary
    public static PJSONScanner createJSONScanner(PythonLanguage language, Object cls, Shape shape, boolean strict, Object objectHook, Object objectPairsHook, Object parseFloat, Object parseInt, Object parseConstant) {
        return PFactory.trace(language, new PJSONScanner(cls, shape, strict, objectHook, objectPairsHook, parseFloat, parseInt, parseConstant));
    }

    @CompilerDirectives.TruffleBoundary
    public static PJSONEncoder createJSONEncoder(PythonLanguage language, Object cls, Shape shape, Object markers, Object defaultFn, Object encoder, Object indent, TruffleString keySeparator, TruffleString itemSeparator, boolean sortKeys, boolean skipKeys, boolean allowNan, PJSONEncoder.FastEncode fastEncode) {
        return PFactory.trace(language, new PJSONEncoder(cls, shape, markers, defaultFn, encoder, indent, keySeparator, itemSeparator, sortKeys, skipKeys, allowNan, fastEncode));
    }

    public static PDeque createDeque(PythonLanguage language) {
        return PFactory.trace(language, new PDeque((Object)PythonBuiltinClassType.PDeque, PythonBuiltinClassType.PDeque.getInstanceShape(language)));
    }

    public static PDeque createDeque(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PDeque(cls, shape));
    }

    public static PDequeIter createDequeIter(PythonLanguage language, PDeque deque) {
        return PFactory.trace(language, new PDequeIter((Object)PythonBuiltinClassType.PDequeIter, PythonBuiltinClassType.PDequeIter.getInstanceShape(language), deque, false));
    }

    public static PDequeIter createDequeRevIter(PythonLanguage language, PDeque deque) {
        return PFactory.trace(language, new PDequeIter((Object)PythonBuiltinClassType.PDequeRevIter, PythonBuiltinClassType.PDequeRevIter.getInstanceShape(language), deque, true));
    }

    public static PSimpleQueue createSimpleQueue(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PSimpleQueue(cls, shape));
    }

    public static PContextVar createContextVar(PythonLanguage language, TruffleString name, Object def) {
        return PFactory.trace(language, new PContextVar((Object)PythonBuiltinClassType.ContextVar, PythonBuiltinClassType.ContextVar.getInstanceShape(language), name, def));
    }

    public static PContextVarsContext createContextVarsContext(PythonLanguage language) {
        return PFactory.trace(language, new PContextVarsContext((Object)PythonBuiltinClassType.ContextVarsContext, PythonBuiltinClassType.ContextVarsContext.getInstanceShape(language)));
    }

    public static PContextIterator createContextIterator(PythonLanguage language, PContextVarsContext ctx, PContextIterator.ItemKind kind) {
        return PFactory.trace(language, new PContextIterator((Object)PythonBuiltinClassType.ContextIterator, PythonBuiltinClassType.ContextIterator.getInstanceShape(language), ctx, kind));
    }

    public static PContextVarsContext copyContextVarsContext(PythonLanguage language, PContextVarsContext original) {
        return PFactory.trace(language, new PContextVarsContext(original, (Object)PythonBuiltinClassType.ContextVarsContext, PythonBuiltinClassType.ContextVarsContext.getInstanceShape(language)));
    }

    public static PContextVarsToken createContextVarsToken(PythonLanguage language, PContextVar var, Object oldValue) {
        return PFactory.trace(language, new PContextVarsToken(var, oldValue, (Object)PythonBuiltinClassType.ContextVarsToken, PythonBuiltinClassType.ContextVarsToken.getInstanceShape(language)));
    }

    public static PGenericAlias createGenericAlias(PythonLanguage language, Object cls, Shape shape, Object origin, Object arguments, boolean starred) {
        PTuple argumentsTuple = arguments instanceof PTuple ? (PTuple)arguments : PFactory.createTuple(language, new Object[]{arguments});
        return PFactory.trace(language, new PGenericAlias(cls, shape, origin, argumentsTuple, starred));
    }

    public static PGenericAlias createGenericAlias(PythonLanguage language, Object origin, Object arguments, boolean starred) {
        return PFactory.createGenericAlias(language, (Object)PythonBuiltinClassType.PGenericAlias, PythonBuiltinClassType.PGenericAlias.getInstanceShape(language), origin, arguments, starred);
    }

    public static PGenericAlias createGenericAlias(PythonLanguage language, Object origin, Object arguments) {
        return PFactory.createGenericAlias(language, origin, arguments, false);
    }

    public static PGenericAliasIterator createGenericAliasIterator(PythonLanguage language, PGenericAlias object) {
        return PFactory.trace(language, new PGenericAliasIterator((Object)PythonBuiltinClassType.PGenericAliasIterator, PythonBuiltinClassType.PGenericAliasIterator.getInstanceShape(language), object));
    }

    public static PUnionType createUnionType(PythonLanguage language, Object[] args) {
        return PFactory.trace(language, new PUnionType((Object)PythonBuiltinClassType.PUnionType, PythonBuiltinClassType.PUnionType.getInstanceShape(language), PFactory.createTuple(language, args)));
    }

    public static DigestObject createDigestObject(PythonLanguage language, PythonBuiltinClassType type, String name, Object digest) {
        return PFactory.trace(language, DigestObject.create(type, type.getInstanceShape(language), name, digest));
    }

    public static PyCapsule createCapsuleNativeName(PythonLanguage language, Object pointer, Object name) {
        return PFactory.createCapsule(language, new PyCapsule.CapsuleData(pointer, name));
    }

    public static PyCapsule createCapsuleJavaName(PythonLanguage language, Object pointer, byte[] name) {
        return PFactory.createCapsule(language, new PyCapsule.CapsuleData(pointer, new CArrayWrappers.CByteArrayWrapper(name)));
    }

    public static PyCapsule createCapsule(PythonLanguage language, PyCapsule.CapsuleData data) {
        return PFactory.trace(language, new PyCapsule(language, data));
    }

    public static MultibyteIncrementalDecoderObject createMultibyteIncrementalDecoderObject(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new MultibyteIncrementalDecoderObject(cls, shape));
    }

    public static MultibyteIncrementalEncoderObject createMultibyteIncrementalEncoderObject(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new MultibyteIncrementalEncoderObject(cls, shape));
    }

    public static MultibyteStreamReaderObject createMultibyteStreamReaderObject(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new MultibyteStreamReaderObject(cls, shape));
    }

    public static MultibyteStreamWriterObject createMultibyteStreamWriterObject(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new MultibyteStreamWriterObject(cls, shape));
    }

    public static MultibyteCodecObject createMultibyteCodecObject(PythonLanguage language, MultibyteCodec codec) {
        return PFactory.createMultibyteCodecObject(language, (Object)PythonBuiltinClassType.MultibyteCodec, PythonBuiltinClassType.MultibyteCodec.getInstanceShape(language), codec);
    }

    public static MultibyteCodecObject createMultibyteCodecObject(PythonLanguage language, Object cls, Shape shape, MultibyteCodec codec) {
        return PFactory.trace(language, new MultibyteCodecObject(cls, shape, codec));
    }

    public static PAsyncGenASend createAsyncGeneratorASend(PythonLanguage language, PAsyncGen receiver, Object message) {
        return PFactory.trace(language, new PAsyncGenASend(language, receiver, message));
    }

    public static PAsyncGenAThrow createAsyncGeneratorAThrow(PythonLanguage language, PAsyncGen receiver, Object arg1, Object arg2, Object arg3) {
        return PFactory.trace(language, new PAsyncGenAThrow(language, receiver, arg1, arg2, arg3));
    }

    public static PAsyncGenWrappedValue createAsyncGeneratorWrappedValue(PythonLanguage language, Object wrapped) {
        return PFactory.trace(language, new PAsyncGenWrappedValue(language, wrapped));
    }

    public static PPickleBuffer createPickleBuffer(PythonLanguage language, Object view) {
        return PFactory.createPickleBuffer(language, view, (Object)PythonBuiltinClassType.PickleBuffer, PythonBuiltinClassType.PickleBuffer.getInstanceShape(language));
    }

    public static PPickleBuffer createPickleBuffer(PythonLanguage language, Object view, Object cls, Shape shape) {
        return PFactory.trace(language, new PPickleBuffer(cls, shape, view));
    }

    public static PPickler createPickler(PythonLanguage language) {
        return PFactory.createPickler(language, (Object)PythonBuiltinClassType.Pickler, PythonBuiltinClassType.Pickler.getInstanceShape(language));
    }

    public static PPickler createPickler(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PPickler(cls, shape));
    }

    public static PUnpickler createUnpickler(PythonLanguage language) {
        return PFactory.createUnpickler(language, (Object)PythonBuiltinClassType.Unpickler, PythonBuiltinClassType.Unpickler.getInstanceShape(language));
    }

    public static PUnpickler createUnpickler(PythonLanguage language, Object cls, Shape shape) {
        return PFactory.trace(language, new PUnpickler(cls, shape));
    }

    public static PPicklerMemoProxy createPicklerMemoProxy(PythonLanguage language, PPickler pickler) {
        return PFactory.createPicklerMemoProxy(language, pickler, (Object)PythonBuiltinClassType.PicklerMemoProxy, PythonBuiltinClassType.PicklerMemoProxy.getInstanceShape(language));
    }

    public static PPicklerMemoProxy createPicklerMemoProxy(PythonLanguage language, PPickler pickler, Object cls, Shape shape) {
        return PFactory.trace(language, new PPicklerMemoProxy(cls, shape, pickler));
    }

    public static PUnpicklerMemoProxy createUnpicklerMemoProxy(PythonLanguage language, PUnpickler unpickler) {
        return PFactory.createUnpicklerMemoProxy(language, unpickler, (Object)PythonBuiltinClassType.UnpicklerMemoProxy, PythonBuiltinClassType.UnpicklerMemoProxy.getInstanceShape(language));
    }

    public static PUnpicklerMemoProxy createUnpicklerMemoProxy(PythonLanguage language, PUnpickler unpickler, Object cls, Shape shape) {
        return PFactory.trace(language, new PUnpicklerMemoProxy(cls, shape, unpickler));
    }

    public static PStruct createStruct(PythonLanguage language, PStruct.StructInfo structInfo) {
        return PFactory.trace(language, new PStruct((Object)PythonBuiltinClassType.PStruct, PythonBuiltinClassType.PStruct.getInstanceShape(language), structInfo));
    }

    public static PStructUnpackIterator createStructUnpackIterator(PythonLanguage language, PStruct struct, Object buffer) {
        return PFactory.trace(language, new PStructUnpackIterator((Object)PythonBuiltinClassType.PStructUnpackIterator, PythonBuiltinClassType.PStructUnpackIterator.getInstanceShape(language), struct, buffer));
    }

    public static PTokenizerIter createTokenizerIter(PythonLanguage language, Object cls, Shape shape, Supplier<int[]> inputSupplier, boolean extraTokens) {
        return PFactory.trace(language, new PTokenizerIter(cls, shape, inputSupplier, extraTokens));
    }

    public static PTypeVar createTypeVar(PythonLanguage language, TruffleString name, Object bound, Object evaluateBound, Object constraints, Object evaluateConstraints, boolean covariant, boolean contravariant, boolean inferVariance) {
        return PFactory.createTypeVar(language, (Object)PythonBuiltinClassType.PTypeVar, PythonBuiltinClassType.PTypeVar.getInstanceShape(language), name, bound, evaluateBound, constraints, evaluateConstraints, covariant, contravariant, inferVariance);
    }

    public static PTypeVar createTypeVar(PythonLanguage language, Object cls, Shape shape, TruffleString name, Object bound, Object evaluateBound, Object constraints, Object evaluateConstraints, boolean covariant, boolean contravariant, boolean inferVariance) {
        return PFactory.trace(language, new PTypeVar(cls, shape, name, bound, evaluateBound, constraints, evaluateConstraints, covariant, contravariant, inferVariance));
    }

    public static PTypeVarTuple createTypeVarTuple(PythonLanguage language, TruffleString name) {
        return PFactory.createTypeVarTuple(language, (Object)PythonBuiltinClassType.PTypeVarTuple, PythonBuiltinClassType.PTypeVarTuple.getInstanceShape(language), name);
    }

    public static PTypeVarTuple createTypeVarTuple(PythonLanguage language, Object cls, Shape shape, TruffleString name) {
        return PFactory.trace(language, new PTypeVarTuple(cls, shape, name));
    }

    public static PParamSpec createParamSpec(PythonLanguage language, TruffleString name, Object bound, boolean covariant, boolean contravariant, boolean inferVariance) {
        return PFactory.createParamSpec(language, (Object)PythonBuiltinClassType.PParamSpec, PythonBuiltinClassType.PParamSpec.getInstanceShape(language), name, bound, covariant, contravariant, inferVariance);
    }

    public static PParamSpec createParamSpec(PythonLanguage language, Object cls, Shape shape, TruffleString name, Object bound, boolean covariant, boolean contravariant, boolean inferVariance) {
        return PFactory.trace(language, new PParamSpec(cls, shape, name, bound, covariant, contravariant, inferVariance));
    }

    public static PParamSpecArgs createParamSpecArgs(PythonLanguage language, Object origin) {
        return PFactory.createParamSpecArgs(language, (Object)PythonBuiltinClassType.PParamSpecArgs, PythonBuiltinClassType.PParamSpecArgs.getInstanceShape(language), origin);
    }

    public static PParamSpecArgs createParamSpecArgs(PythonLanguage language, Object cls, Shape shape, Object origin) {
        return PFactory.trace(language, new PParamSpecArgs(cls, shape, origin));
    }

    public static PParamSpecKwargs createParamSpecKwargs(PythonLanguage language, Object origin) {
        return PFactory.createParamSpecKwargs(language, (Object)PythonBuiltinClassType.PParamSpecKwargs, PythonBuiltinClassType.PParamSpecKwargs.getInstanceShape(language), origin);
    }

    public static PParamSpecKwargs createParamSpecKwargs(PythonLanguage language, Object cls, Shape shape, Object origin) {
        return PFactory.trace(language, new PParamSpecKwargs(cls, shape, origin));
    }

    public static PTypeAliasType createTypeAliasType(PythonLanguage language, TruffleString name, PTuple typeParams, Object computeValue, Object value, Object module) {
        return PFactory.createTypeAliasType(language, (Object)PythonBuiltinClassType.PTypeAliasType, PythonBuiltinClassType.PTypeAliasType.getInstanceShape(language), name, typeParams, computeValue, value, module);
    }

    public static PTypeAliasType createTypeAliasType(PythonLanguage language, Object cls, Shape shape, TruffleString name, PTuple typeParams, Object computeValue, Object value, Object module) {
        return PFactory.trace(language, new PTypeAliasType(cls, shape, name, typeParams, computeValue, value, module));
    }

    public static Profiler createProfiler(PythonLanguage language, Object cls, Shape shape, CPUSampler sampler) {
        return PFactory.trace(language, new Profiler(cls, shape, sampler));
    }
}

