/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.nodes.argument.CreateArgumentsNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;

@ExportLibrary(value=InteropLibrary.class)
public abstract class PyCFunctionWrapper
implements TruffleObject {
    protected final RootCallTarget callTarget;
    protected final Signature signature;
    protected final TruffleString callTargetName;
    protected final CApiTiming timing;
    private long pointer;
    protected final Object[] defaults;

    protected PyCFunctionWrapper(RootCallTarget callTarget, Signature signature, Object[] defaults) {
        assert (callTarget != null);
        assert (signature != null);
        this.callTarget = callTarget;
        this.signature = signature;
        this.defaults = defaults;
        String ctName = callTarget.getRootNode().getName();
        this.callTargetName = PythonUtils.toTruffleStringUncached(ctName);
        this.timing = CApiTiming.create(false, ctName);
    }

    public final RootCallTarget getCallTarget() {
        return this.callTarget;
    }

    public final Object getDelegate() {
        assert (this.callTarget != null);
        return this.callTarget;
    }

    abstract String getSignature();

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    protected Object execute(Object[] arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        throw CompilerDirectives.shouldNotReachHere((String)"abstract class");
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected void toNative(@CachedLibrary(limit="1") SignatureLibrary signatureLibrary) {
        if (this.pointer == 0L) {
            CApiContext cApiContext = PythonContext.get(null).getCApiContext();
            this.pointer = cApiContext.registerClosure(this.getSignature(), this, this.getDelegate(), signatureLibrary);
        }
    }

    @ExportMessage
    protected boolean isPointer() {
        return this.pointer != 0L;
    }

    @ExportMessage
    protected long asPointer() {
        return this.pointer;
    }

    protected abstract String getFlagsRepr();

    @CompilerDirectives.TruffleBoundary
    private static String toString(Object name, String flagsRepr, long pointer) {
        String ptr = pointer != 0L ? " at 0x" + Long.toHexString(pointer) : "";
        return String.format("PyCFunction(%s, %s)%s", name, flagsRepr, ptr);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return PyCFunctionWrapper.toString(this.callTargetName, this.getFlagsRepr(), this.pointer);
    }

    @CompilerDirectives.TruffleBoundary
    public static PyCFunctionWrapper createFromBuiltinFunction(CApiContext cApiContext, PBuiltinFunction builtinFunction) {
        int flags = builtinFunction.getFlags();
        RootCallTarget ct = builtinFunction.getCallTarget();
        Signature signature = builtinFunction.getSignature();
        Object[] defaults = builtinFunction.getDefaults();
        if (CExtContext.isMethNoArgs(flags)) {
            return cApiContext.getOrCreatePyCFunctionWrapper(ct, k -> new PyCFunctionUnaryWrapper((RootCallTarget)k, signature, defaults));
        }
        if (CExtContext.isMethO(flags)) {
            return cApiContext.getOrCreatePyCFunctionWrapper(ct, k -> new PyCFunctionBinaryWrapper((RootCallTarget)k, signature, defaults));
        }
        if (CExtContext.isMethVarargs(flags)) {
            return cApiContext.getOrCreatePyCFunctionWrapper(ct, k -> new PyCFunctionVarargsWrapper((RootCallTarget)k, signature, defaults));
        }
        if (CExtContext.isMethVarargsWithKeywords(flags)) {
            return cApiContext.getOrCreatePyCFunctionWrapper(ct, k -> new PyCFunctionKeywordsWrapper((RootCallTarget)k, signature, defaults));
        }
        throw CompilerDirectives.shouldNotReachHere((String)("other signature " + Integer.toHexString(flags)));
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class PyCFunctionKeywordsWrapper
    extends PyCFunctionWrapper {
        PyCFunctionKeywordsWrapper(RootCallTarget callTarget, Signature signature, Object[] defaults) {
            super(callTarget, signature, defaults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached ExecutePositionalStarargsNode posStarargsNode, @Cached CreateArgumentsNode createArgsNode, @Cached CallDispatchers.CallTargetCachedInvokeNode invokeNode2, @Cached ExpandKeywordStarargsNode expandKwargsNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 3) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)3, (int)3, (int)arguments.length);
                }
                try {
                    Object receiver = toJavaNode.execute(arguments[0]);
                    Object starArgs = toJavaNode.execute(arguments[1]);
                    Object kwArgs = toJavaNode.execute(arguments[2]);
                    Object[] starArgsArray = posStarargsNode.executeWith(null, starArgs);
                    PKeyword[] kwArgsArray = expandKwargsNode.execute(inliningTarget, kwArgs);
                    Object[] pArgs = createArgsNode.execute(inliningTarget, this.callTargetName, starArgsArray, kwArgsArray, this.signature, receiver, null, this.defaults, PKeyword.EMPTY_KEYWORDS, false);
                    Object result = invokeNode2.execute(null, inliningTarget, this.callTarget, pArgs);
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, this.toString(), "");
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):POINTER";
        }

        @Override
        protected String getFlagsRepr() {
            return "METH_KEYWORDS";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class PyCFunctionVarargsWrapper
    extends PyCFunctionWrapper {
        PyCFunctionVarargsWrapper(RootCallTarget callTarget, Signature signature, Object[] defaults) {
            super(callTarget, signature, defaults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached ExecutePositionalStarargsNode posStarargsNode, @Cached CreateArgumentsNode createArgsNode, @Cached CallDispatchers.CallTargetCachedInvokeNode invokeNode2, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)2, (int)2, (int)arguments.length);
                }
                try {
                    Object receiver = toJavaNode.execute(arguments[0]);
                    Object starArgs = toJavaNode.execute(arguments[1]);
                    Object[] starArgsArray = posStarargsNode.executeWith(null, starArgs);
                    Object[] pArgs = createArgsNode.execute(inliningTarget, this.callTargetName, starArgsArray, PKeyword.EMPTY_KEYWORDS, this.signature, receiver, null, this.defaults, PKeyword.EMPTY_KEYWORDS, false);
                    Object result = invokeNode2.execute(null, inliningTarget, this.callTarget, pArgs);
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, this.toString(), "");
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER):POINTER";
        }

        @Override
        protected String getFlagsRepr() {
            return "METH_VARARGS";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class PyCFunctionBinaryWrapper
    extends PyCFunctionWrapper {
        PyCFunctionBinaryWrapper(RootCallTarget callTarget, Signature signature, Object[] defaults) {
            super(callTarget, signature, defaults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CallDispatchers.CallTargetCachedInvokeNode invokeNode2, @Cached CreateArgumentsNode createArgsNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length != 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)2, (int)2, (int)arguments.length);
                }
                try {
                    Object jArg0 = toJavaNode.execute(arguments[0]);
                    Object jArg1 = toJavaNode.execute(arguments[1]);
                    Object[] pArgs = createArgsNode.execute(inliningTarget, this.callTargetName, new Object[]{jArg1}, PKeyword.EMPTY_KEYWORDS, this.signature, jArg0, null, this.defaults, PKeyword.EMPTY_KEYWORDS, false);
                    Object result = invokeNode2.execute(null, inliningTarget, this.callTarget, pArgs);
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, this.toString(), "");
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER):POINTER";
        }

        @Override
        protected String getFlagsRepr() {
            return "METH_O";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class PyCFunctionUnaryWrapper
    extends PyCFunctionWrapper {
        PyCFunctionUnaryWrapper(RootCallTarget callTarget, Signature signature, Object[] defaults) {
            super(callTarget, signature, defaults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        Object execute(Object[] arguments, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNode, @Cached CreateArgumentsNode createArgsNode, @Cached CallDispatchers.CallTargetCachedInvokeNode invokeNode2, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            CApiTiming.enter();
            try {
                if (arguments.length > 2) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)1, (int)2, (int)arguments.length);
                }
                try {
                    Object jArg0 = toJavaNode.execute(arguments[0]);
                    Object[] pArgs = createArgsNode.execute(inliningTarget, this.callTargetName, PythonUtils.EMPTY_OBJECT_ARRAY, PKeyword.EMPTY_KEYWORDS, this.signature, jArg0, null, this.defaults, PKeyword.EMPTY_KEYWORDS, false);
                    Object result = invokeNode2.execute(null, inliningTarget, this.callTarget, pArgs);
                    Object object = toNativeNode.execute(result);
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, this.toString(), "");
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(inliningTarget, e);
                        NativePointer nativePointer = PythonContext.get(gil).getNativeNull();
                        return nativePointer;
                    }
                }
            }
            finally {
                CApiTiming.exit(this.timing);
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER):POINTER";
        }

        @Override
        protected String getFlagsRepr() {
            return "METH_NOARGS";
        }
    }
}

