/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.hashlib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObject;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObjectBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.MD5Type, PythonBuiltinClassType.SHA1Type, PythonBuiltinClassType.SHA224Type, PythonBuiltinClassType.SHA256Type, PythonBuiltinClassType.SHA384Type, PythonBuiltinClassType.SHA512Type, PythonBuiltinClassType.HashlibHash, PythonBuiltinClassType.HashlibHmac, PythonBuiltinClassType.Sha3SHA224Type, PythonBuiltinClassType.Sha3SHA256Type, PythonBuiltinClassType.Sha3SHA384Type, PythonBuiltinClassType.Sha3SHA512Type, PythonBuiltinClassType.Sha3Shake128Type, PythonBuiltinClassType.Sha3Shake256Type, PythonBuiltinClassType.Blake2bType, PythonBuiltinClassType.Blake2sType})
public final class DigestObjectBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DigestObjectBuiltinsFactory.getFactories();
    }

    @Builtin(name="name", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NameNode
    extends PythonUnaryBuiltinNode {
        NameNode() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        TruffleString get(DigestObject self) {
            return PythonUtils.toTruffleStringUncached(self.getAlgorithm());
        }
    }

    @Builtin(name="digest_size", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DigestSizeNode
    extends PythonUnaryBuiltinNode {
        DigestSizeNode() {
        }

        @Specialization
        static int get(DigestObject self) {
            return self.getDigestLength();
        }
    }

    @Builtin(name="block_size", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class BlockSizeNode
    extends PythonUnaryBuiltinNode {
        BlockSizeNode() {
        }

        @Specialization
        static int get(DigestObject self) {
            return self.getBlockSize();
        }
    }

    @Builtin(name="update", parameterNames={"self", "obj"})
    @ArgumentClinic(name="obj", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class UpdateNode
    extends PythonBinaryClinicBuiltinNode {
        UpdateNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DigestObjectBuiltinsClinicProviders.UpdateNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static PNone update(VirtualFrame frame, DigestObject self, Object buffer, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode raiseNode) {
            if (self.wasReset()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.UPDATING_FINALIZED_DIGEST_IS_NOT_SUPPORTED);
            }
            try {
                self.update(bufferLib.getInternalOrCopiedByteArray(buffer), bufferLib.getBufferLength(buffer));
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="hexdigest", parameterNames={"self"})
    @GenerateNodeFactory
    static abstract class HexdigestNode
    extends PythonUnaryBuiltinNode {
        HexdigestNode() {
        }

        @Specialization
        static TruffleString hexdigest(DigestObject self, @Bind Node inliningTarget, @Cached BytesNodes.ByteToHexNode toHexNode) {
            byte[] digest = self.digest();
            return toHexNode.execute(inliningTarget, digest, digest.length, (byte)0, 0);
        }
    }

    @Builtin(name="digest", parameterNames={"self"})
    @GenerateNodeFactory
    static abstract class DigestNode
    extends PythonUnaryBuiltinNode {
        DigestNode() {
        }

        @Specialization
        static PBytes digest(DigestObject self, @Bind PythonLanguage language) {
            return PFactory.createBytes(language, self.digest());
        }
    }

    @Builtin(name="copy", parameterNames={"self"})
    @GenerateNodeFactory
    static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        CopyNode() {
        }

        @Specialization
        static DigestObject copy(DigestObject self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode) {
            try {
                return self.copy();
            }
            catch (CloneNotSupportedException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError);
            }
        }
    }
}

