/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.lib.PyObjectTypeCheck;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary.Repeat(value={@ExportLibrary(value=PythonBufferAcquireLibrary.class), @ExportLibrary(value=PythonBufferAccessLibrary.class)})
public class CDataObject
extends PythonBuiltinObject {
    final Pointer b_ptr;
    final boolean b_needsfree;
    CDataObject b_base;
    int b_size;
    int b_length;
    int b_index;
    Object b_objects;

    public CDataObject(Object cls, Shape instanceShape, Pointer b_ptr, int b_size, boolean b_needsfree) {
        super(cls, instanceShape);
        this.b_ptr = b_ptr;
        this.b_size = b_size;
        this.b_needsfree = b_needsfree;
    }

    public static CDataObjectWrapper createWrapper(Object delegate, StgDictObject dictObject, byte[] storage) {
        return new CDataObjectWrapper(delegate, dictObject, storage);
    }

    @ExportMessage
    boolean hasBuffer() {
        return true;
    }

    @ExportMessage
    Object acquire(int flags) {
        return this;
    }

    @ExportMessage
    boolean isBuffer() {
        return true;
    }

    @ExportMessage
    int getBufferLength() {
        return this.b_size;
    }

    @ExportMessage
    TruffleString getFormatString(@Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached StgDictBuiltins.PyTypeStgDictNode stgDictNode) {
        Object itemType = getClassNode.execute(inliningTarget, this);
        StgDictObject dict = stgDictNode.execute(inliningTarget, itemType);
        return dict.format;
    }

    @ExportMessage
    int getItemSize(@Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached StgDictBuiltins.PyTypeStgDictNode stgDictNode, @Cached PyObjectTypeCheck typeCheck) {
        Object itemType = getClassNode.execute(inliningTarget, this);
        while (typeCheck.execute(inliningTarget, itemType, (Object)PythonBuiltinClassType.PyCArrayType)) {
            StgDictObject stgDict = stgDictNode.execute(inliningTarget, itemType);
            itemType = stgDict.proto;
        }
        StgDictObject itemDict = stgDictNode.execute(inliningTarget, itemType);
        return itemDict.size;
    }

    @ExportMessage
    byte readByte(int byteIndex, @Bind Node inliningTarget, @Cached PointerNodes.ReadByteNode readByteNode) {
        return readByteNode.execute(inliningTarget, this.b_ptr.withOffset(byteIndex));
    }

    @ExportMessage
    void readIntoByteArray(int srcOffset, byte[] dest, int destOffset, int length, @Bind Node inliningTarget, @Cached PointerNodes.ReadBytesNode readBytesNode) {
        readBytesNode.execute(inliningTarget, dest, destOffset, this.b_ptr.withOffset(srcOffset), length);
    }

    @ExportMessage
    boolean isReadonly() {
        return false;
    }

    @ExportMessage
    void writeByte(int byteIndex, byte value, @Bind Node inliningTarget, @Cached.Shared @Cached PointerNodes.WriteBytesNode writeBytesNode) {
        writeBytesNode.execute(inliningTarget, this.b_ptr.withOffset(byteIndex), new byte[]{value});
    }

    @ExportMessage
    void writeFromByteArray(int destOffset, byte[] src, int srcOffset, int length, @Bind Node inliningTarget, @Cached.Shared @Cached PointerNodes.WriteBytesNode writeBytesNode) {
        writeBytesNode.execute(inliningTarget, this.b_ptr.withOffset(destOffset), src, srcOffset, length);
    }

    @ExportMessage
    boolean isNative(@Bind Node inliningTarget, @Cached PointerNodes.PointerIsNativeNode pointerIsNativeNode) {
        return pointerIsNativeNode.execute(inliningTarget, this.b_ptr);
    }

    @ExportMessage
    Object getNativePointer(@Bind Node inliningTarget, @Cached PointerNodes.GetPointerValueAsObjectNode getPointerValue) {
        return getPointerValue.execute(inliningTarget, this.b_ptr);
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class CDataObjectWrapper
    extends PythonNativeWrapper.PythonAbstractObjectNativeWrapper {
        private final byte[] storage;
        private final StgDictObject stgDict;
        private String[] members;

        public CDataObjectWrapper(Object delegate, StgDictObject stgDict, byte[] storage) {
            super(delegate);
            this.storage = storage;
            assert (stgDict != null);
            this.stgDict = stgDict;
        }

        private int getIndex(String field, CastToJavaStringNode toJavaStringNode) {
            String[] fields = this.getMembers(true, toJavaStringNode);
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equals(field)) continue;
                return i;
            }
            return -1;
        }

        @ExportMessage
        boolean hasMembers() {
            return this.stgDict.fieldsNames.length > 0;
        }

        @ExportMessage
        String[] getMembers(boolean includeInternal, @Cached.Shared @Cached CastToJavaStringNode toJavaStringNode) {
            if (this.members == null) {
                this.members = new String[this.stgDict.fieldsNames.length];
                for (int i = 0; i < this.stgDict.fieldsNames.length; ++i) {
                    this.members[i] = toJavaStringNode.execute(this.stgDict.fieldsNames[i]);
                }
            }
            return this.members;
        }

        @ExportMessage
        boolean isMemberReadable(String member, @Cached.Shared @Cached CastToJavaStringNode toJavaStringNode) {
            return this.getIndex(member, toJavaStringNode) != -1;
        }

        @ExportMessage
        boolean isMemberModifiable(String member, @Cached.Shared @Cached CastToJavaStringNode toJavaStringNode) {
            return this.isMemberReadable(member, toJavaStringNode);
        }

        @ExportMessage
        boolean isMemberInsertable(String member) {
            return false;
        }

        @ExportMessage
        Object readMember(String member, @Cached.Shared @Cached CastToJavaStringNode toJavaStringNode) throws UnknownIdentifierException {
            int idx = this.getIndex(member, toJavaStringNode);
            if (idx != -1) {
                return CtypesNodes.getValue(this.stgDict.fieldsTypes[idx], this.storage, this.stgDict.fieldsOffsets[idx]);
            }
            throw UnknownIdentifierException.create((String)member);
        }

        @ExportMessage
        void writeMember(String member, Object value, @Cached.Shared @Cached CastToJavaStringNode toJavaStringNode) throws UnknownIdentifierException {
            int idx = this.getIndex(member, toJavaStringNode);
            if (idx != -1) {
                CtypesNodes.setValue(this.stgDict.fieldsTypes[idx], this.storage, this.stgDict.fieldsOffsets[idx], value);
                return;
            }
            throw UnknownIdentifierException.create((String)member);
        }

        @ExportMessage
        boolean isPointer() {
            return this.isNative();
        }

        @ExportMessage
        long asPointer() {
            return this.getNativePointer();
        }

        @ExportMessage
        void toNative(@Bind Node inliningTarget, @Cached InlinedConditionProfile isNativeProfile, @Cached CApiTransitions.FirstToNativeNode firstToNativeNode) {
            if (!this.isNative(inliningTarget, isNativeProfile)) {
                this.setNativePointer(firstToNativeNode.execute(inliningTarget, this));
            }
        }
    }
}

