/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal;

import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.DataPrintWriter;
import com.ibm.db2.cmx.runtime.internal.trace.GeneratorLogFormatter;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.trace.PrintWriterHandler;
import com.ibm.db2.cmx.tools.DataVersion;
import com.ibm.db2.jcc.DB2Connection;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ToolsLogger {
    private static final ThreadLocal<ToolsLoggerLocator> locatorThreadLocal = new ThreadLocal();
    private static final String TOOLS_LOGGER_NAME = "com.ibm.db2.cmx.tools";
    private static final ToolsLoggerLocator defaultLoggerLocator = new ToolsLoggerLocator(null);

    public static final Logger getLogger() {
        ToolsLoggerLocator toolsLoggerLocator = locatorThreadLocal.get();
        return null != toolsLoggerLocator ? toolsLoggerLocator.logger_ : ToolsLogger.defaultLoggerLocator.logger_;
    }

    public static boolean isAUtilityRunning() {
        return null != locatorThreadLocal.get();
    }

    public static synchronized void configureLogger(String string, String string2, boolean bl2) {
        try {
            ToolsLoggerLocator toolsLoggerLocator = locatorThreadLocal.get();
            if (null == toolsLoggerLocator) {
                toolsLoggerLocator = defaultLoggerLocator;
                locatorThreadLocal.set(toolsLoggerLocator);
            }
            if (toolsLoggerLocator.isDefaultLogger_ && (null != string || null != string2)) {
                toolsLoggerLocator = new ToolsLoggerLocator(Logger.getAnonymousLogger());
                locatorThreadLocal.set(toolsLoggerLocator);
                Logger logger = toolsLoggerLocator.logger_;
                Level level = Log.getLevelFromPropertyValue(string2);
                if (string != null && level != null && !Level.OFF.equals(level)) {
                    File file = new File(string);
                    File file2 = file.getParentFile();
                    if (file2 != null) {
                        file2.mkdirs();
                    }
                    toolsLoggerLocator.printWriterForDriverTrace_ = DataLogger.getPrintWriter(string, true);
                    toolsLoggerLocator.printWriterForDriverTrace_.incrementUserCount();
                    toolsLoggerLocator.fileHandlerUsed = new PrintWriterHandler(toolsLoggerLocator.printWriterForDriverTrace_);
                    toolsLoggerLocator.fileHandlerUsed.setFormatter(new GeneratorLogFormatter());
                    logger.addHandler(toolsLoggerLocator.fileHandlerUsed);
                    if (level != logger.getLevel()) {
                        toolsLoggerLocator.fileHandlerUsed.setLevel(level);
                        logger.setLevel(level);
                    }
                } else if (string2 != null) {
                    Handler[] handlerArray = logger.getHandlers();
                    boolean bl3 = false;
                    for (int i10 = 0; i10 < handlerArray.length; ++i10) {
                        if (!(handlerArray[i10] instanceof ConsoleHandler)) continue;
                        handlerArray[i10].setLevel(level);
                        bl3 = true;
                        break;
                    }
                    if (!bl3) {
                        ConsoleHandler consoleHandler = new ConsoleHandler();
                        consoleHandler.setFormatter(new GeneratorLogFormatter());
                        consoleHandler.setLevel(level);
                        logger.addHandler(consoleHandler);
                    }
                    if (level != logger.getLevel()) {
                        logger.setLevel(level);
                    }
                }
                logger.log(Level.CONFIG, DataVersion.getConfiguration());
                logger.log(Level.CONFIG, DataLogger.getPmrStamp());
                ToolsLogger.attachDriverManagerLog(toolsLoggerLocator, bl2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static synchronized void cleanupLoggerAndDetachDriverManagerLogAndConnectionLog(Connection connection) {
        ToolsLoggerLocator toolsLoggerLocator = locatorThreadLocal.get();
        if (null != toolsLoggerLocator && !toolsLoggerLocator.isDefaultLogger_) {
            try {
                locatorThreadLocal.set(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                ToolsLogger.detachDriverManagerLog(toolsLoggerLocator);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                if (null != connection) {
                    ToolsLogger.detachConnectionLog(toolsLoggerLocator, connection);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (null != toolsLoggerLocator.fileHandlerUsed) {
                try {
                    toolsLoggerLocator.fileHandlerUsed.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                try {
                    toolsLoggerLocator.logger_.removeHandler(toolsLoggerLocator.fileHandlerUsed);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                try {
                    if (1 > toolsLoggerLocator.printWriterForDriverTrace_.decrementUserCount()) {
                        DataLogger.closeAndRemoveDataPrintWriter(toolsLoggerLocator.printWriterForDriverTrace_);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private static void attachDriverManagerLog(ToolsLoggerLocator toolsLoggerLocator, boolean bl2) {
        if (bl2 && toolsLoggerLocator.printWriterForDriverTrace_ != null) {
            toolsLoggerLocator.oldDriverManagerLogWriter_ = DriverManager.getLogWriter();
            toolsLoggerLocator.isDriverManagerLogSet = true;
            DriverManager.setLogWriter(toolsLoggerLocator.printWriterForDriverTrace_);
        }
    }

    private static void detachDriverManagerLog(ToolsLoggerLocator toolsLoggerLocator) {
        if (toolsLoggerLocator.isDriverManagerLogSet) {
            DriverManager.setLogWriter(toolsLoggerLocator.oldDriverManagerLogWriter_);
            toolsLoggerLocator.oldDriverManagerLogWriter_ = null;
            toolsLoggerLocator.isDriverManagerLogSet = false;
        }
    }

    public static void attachConnectionLog(Connection connection) {
        ToolsLoggerLocator toolsLoggerLocator = locatorThreadLocal.get();
        if (null != toolsLoggerLocator && !toolsLoggerLocator.isDefaultLogger_ && toolsLoggerLocator.printWriterForDriverTrace_ != null) {
            try {
                ToolsLogger.attachConnectionLogForJcc(toolsLoggerLocator, connection);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static void detachConnectionLog(ToolsLoggerLocator toolsLoggerLocator, Connection connection) {
        try {
            ToolsLogger.detachConnectionLogForJcc(toolsLoggerLocator, connection);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void attachConnectionLogForJcc(ToolsLoggerLocator toolsLoggerLocator, Connection connection) throws SQLException {
        if (null != connection && connection instanceof DB2Connection) {
            toolsLoggerLocator.oldJccConnectionLogWriter_ = ((DB2Connection)connection).getJccLogWriter();
            toolsLoggerLocator.isJccConnectionLogSet = true;
            ((DB2Connection)connection).setJccLogWriter(toolsLoggerLocator.printWriterForDriverTrace_);
        }
    }

    private static void detachConnectionLogForJcc(ToolsLoggerLocator toolsLoggerLocator, Connection connection) throws SQLException {
        if (null != connection && toolsLoggerLocator.isJccConnectionLogSet && connection instanceof DB2Connection) {
            ((DB2Connection)connection).setJccLogWriter(toolsLoggerLocator.oldJccConnectionLogWriter_);
            toolsLoggerLocator.oldJccConnectionLogWriter_ = null;
            toolsLoggerLocator.isJccConnectionLogSet = false;
        }
    }

    protected static class ToolsLoggerLocator {
        protected final Logger logger_;
        protected final boolean isDefaultLogger_;
        protected PrintWriterHandler fileHandlerUsed = null;
        protected DataPrintWriter printWriterForDriverTrace_ = null;
        protected boolean isDriverManagerLogSet = false;
        protected PrintWriter oldDriverManagerLogWriter_ = null;
        protected boolean isJccConnectionLogSet = false;
        protected PrintWriter oldJccConnectionLogWriter_ = null;

        ToolsLoggerLocator(Logger logger) {
            if (null == logger) {
                this.isDefaultLogger_ = true;
                this.logger_ = Logger.getLogger(ToolsLogger.TOOLS_LOGGER_NAME);
            } else {
                this.isDefaultLogger_ = false;
                this.logger_ = logger;
            }
            this.logger_.setUseParentHandlers(false);
        }
    }
}

