/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.manager.AppImpl;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryDataFactory;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk1.AccessMetaData;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk1.App_t;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AppReader {
    private String schema;

    public static AppReader getInstance(String string) {
        return new AppReader(string);
    }

    private AppReader(String string) {
        this.schema = string;
    }

    public int getAppKeyFor(Connection connection, String string, String string2) throws MetadataException {
        int n2 = -1;
        AccessMetaData accessMetaData = RepositoryDataFactory.getData(AccessMetaData.class, connection);
        try {
            List<Map<String, Object>> list = null;
            list = string2 != null ? accessMetaData.getAppKey(string, string2) : accessMetaData.getAppKey(string);
            if (list.size() > 0) {
                Number number = (Number)list.get(0).get("app_key");
                n2 = number.intValue();
            }
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        return n2;
    }

    public List<AppImpl> getApps(Connection connection) throws MetadataException {
        ArrayList<AppImpl> arrayList = new ArrayList<AppImpl>();
        AccessMetaData accessMetaData = RepositoryDataFactory.getData(AccessMetaData.class, connection);
        try {
            Iterator<App_t> iterator = accessMetaData.getAppKeyName();
            while (iterator.hasNext()) {
                App_t app_t = iterator.next();
                AppImpl appImpl = new AppImpl(app_t.getApp_key(), app_t.getName(), app_t.getVersion());
                arrayList.add(appImpl);
            }
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        return arrayList;
    }

    public static Iterator<App_t> getDataByProject(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws MetadataException {
        AccessMetaData accessMetaData = RepositoryDataFactory.getData(AccessMetaData.class, connection);
        Iterator<App_t> iterator = null;
        try {
            iterator = accessMetaData.getAppDataByProject(string, string2, string3, string4, string5, string6, string7, string8, string9, string10);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), dataRuntimeException);
        }
        return iterator;
    }

    public static Iterator<App_t> getDataByGroup(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws MetadataException {
        AccessMetaData accessMetaData = RepositoryDataFactory.getData(AccessMetaData.class, connection);
        Iterator<App_t> iterator = null;
        try {
            iterator = accessMetaData.getAppDataByGroup(string, string2, string3, string4, string5, string6, string7, string8, string9, string10);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), dataRuntimeException);
        }
        return iterator;
    }
}

