/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.Utility;
import us.fatehi.utility.property.PropertyName;

public abstract class BaseCommandProvider
implements CommandProvider {
    private final Collection<PropertyName> supportedCommands;

    public BaseCommandProvider(Collection<PropertyName> supportedCommands) {
        this.supportedCommands = Objects.requireNonNull(supportedCommands, "No supported commands provided");
    }

    public BaseCommandProvider(PropertyName command) {
        this(List.of(Objects.requireNonNull(command, "No command provided")));
    }

    @Override
    public PluginCommand getCommandLineCommand() {
        return PluginCommand.empty();
    }

    @Override
    public final Collection<PropertyName> getSupportedCommands() {
        return List.copyOf(this.supportedCommands);
    }

    @Override
    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig, OutputOptions outputOptions) {
        return this.supportsCommand(command);
    }

    protected final boolean supportsCommand(String command) {
        return this.lookupSupportedCommand(command) != null;
    }

    protected final PropertyName lookupSupportedCommand(String command) {
        if (Utility.isBlank(command)) {
            return null;
        }
        for (PropertyName supportedCommand : this.supportedCommands) {
            if (supportedCommand == null || !command.equalsIgnoreCase(supportedCommand.getName())) continue;
            return supportedCommand;
        }
        return null;
    }

    protected boolean supportsOutputFormat(String command, OutputOptions outputOptions, Predicate<String> outputFormatValuePredicate) {
        Objects.requireNonNull(outputFormatValuePredicate, "No output format value predicate provided");
        if (outputOptions == null) {
            return false;
        }
        String format = outputOptions.getOutputFormatValue();
        if (Utility.isBlank(format)) {
            return false;
        }
        return outputFormatValuePredicate.test(format);
    }
}

