/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.WorkerPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSWorker;
import com.oracle.truffle.js.runtime.builtins.JSWorkerObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public final class WorkerPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WorkerPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new WorkerPrototypeBuiltins();

    protected WorkerPrototypeBuiltins() {
        super(JSWorker.PROTOTYPE_NAME, WorkerPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WorkerPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return WorkerPrototypeBuiltinsFactory.WorkerGetMessageNodeGen.create(context, builtin, WorkerPrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 1: {
                return WorkerPrototypeBuiltinsFactory.WorkerPostMessageNodeGen.create(context, builtin, WorkerPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 2: 
            case 3: {
                return WorkerPrototypeBuiltinsFactory.WorkerTerminateNodeGen.create(context, builtin, WorkerPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum WorkerPrototype implements BuiltinEnum<WorkerPrototype>
    {
        getMessage(0),
        postMessage(0),
        terminate(0),
        terminateAndWait(0);

        private final int length;

        private WorkerPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSWorker.class})
    public static abstract class WorkerGetMessageNode
    extends JSBuiltinNode {
        public WorkerGetMessageNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doWorker(JSWorkerObject thisObj) {
            return thisObj.getAgent().getOutMessage(this.getRealm());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isJSWorker(thisObj)"})
        protected Object invalidReceiver(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    @ImportStatic(value={JSWorker.class})
    public static abstract class WorkerPostMessageNode
    extends JSBuiltinNode {
        public WorkerPostMessageNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object doWorker(JSWorkerObject thisObj, Object message, Object transfer) {
            EconomicSet transferSet;
            if (transfer == Undefined.instance) {
                transferSet = null;
            } else if (transfer instanceof JSArrayObject) {
                JSArrayObject array = (JSArrayObject)transfer;
                long length = JSAbstractArray.arrayGetLength(array);
                if (length >= Integer.MAX_VALUE) {
                    throw Errors.createRangeErrorInvalidArrayLength(this);
                }
                int lengthInt = (int)length;
                transferSet = EconomicSet.create((Equivalence)Equivalence.IDENTITY, (int)lengthInt);
                for (int i = 0; i < lengthInt; ++i) {
                    Object transferable = JSObject.get((JSDynamicObject)array, i);
                    if (transferable instanceof JSArrayBufferObject) {
                        JSArrayBufferObject arrayBuffer = (JSArrayBufferObject)((Object)transferable);
                        if (transferSet.add((Object)arrayBuffer)) continue;
                        throw Errors.createError("ArrayBuffer occurs in the transfer array more than once");
                    }
                    throw Errors.createError("Transfer array elements must be an ArrayBuffer");
                }
            } else {
                throw Errors.createError("Transfer list must be an Array or undefined");
            }
            thisObj.getAgent().postInMessage(message, transferSet);
            return Undefined.instance;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isJSWorker(thisObj)"})
        protected Object invalidReceiver(Object thisObj, Object message, Object transfer) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    @ImportStatic(value={JSWorker.class})
    public static abstract class WorkerTerminateNode
    extends JSBuiltinNode {
        public WorkerTerminateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doWorker(JSWorkerObject thisObj) {
            thisObj.getAgent().terminate();
            return Undefined.instance;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isJSWorker(thisObj)"})
        protected Object invalidReceiver(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }
}

