/*
 * Decompiled with CFR 0.152.
 */
package oracle.nativeimage;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import oracle.jdbc.logging.annotations.DisableTrace;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@DisableTrace
@AutomaticFeature
final class NativeImageFeature
implements Feature {
    private ResourcesRegistry resourcesRegistry;

    NativeImageFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a2) {
        Class parserFactory;
        Class characterConverterOGS = a2.findClassByName("oracle.i18n.text.converter.CharacterConverterOGS");
        if (characterConverterOGS != null) {
            this.initializeAtBuildTime(a2, "oracle.i18n.text.converter.CharacterConverterOGS");
            this.initializeAtBuildTime(a2, "oracle.i18n.text.converter.CharacterConverterSJIS");
            this.initializeAtBuildTime(a2, "oracle.i18n.text.converter.CharacterConverter12Byte");
        }
        if ((parserFactory = a2.findClassByName("oracle.xml.jaxp.JXSAXParserFactory")) != null) {
            this.getResourceRegistry().addResourceBundles("oracle.xml.mesg.XMLResourceBundle");
        }
    }

    private void initializeAtBuildTime(Feature.BeforeAnalysisAccess a2, String className) {
        Class clazz = a2.findClassByName(className);
        if (clazz != null) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{clazz});
        }
    }

    private void registerAll(Feature.BeforeAnalysisAccess a2, String className) {
        this.registerClass(a2, className);
        this.registerAllConstructor(a2, className);
        this.registerAllMethods(a2, className);
        this.registerAllFields(a2, className);
    }

    private void registerClass(Feature.BeforeAnalysisAccess a2, String className) {
        Class clazz = a2.findClassByName(className);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
        }
    }

    private void registerAllConstructor(Feature.BeforeAnalysisAccess a2, String className) {
        Class clazz = a2.findClassByName(className);
        if (clazz != null) {
            for (Constructor<?> c2 : clazz.getConstructors()) {
                RuntimeReflection.register((Executable[])new Executable[]{c2});
            }
        }
    }

    private void registerAllMethods(Feature.BeforeAnalysisAccess a2, String className) {
        Class clazz = a2.findClassByName(className);
        if (clazz != null) {
            for (Method m2 : clazz.getMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{m2});
            }
        }
    }

    private void registerAllFields(Feature.BeforeAnalysisAccess a2, String className) {
        Class clazz = a2.findClassByName(className);
        if (clazz != null) {
            for (Field f2 : clazz.getFields()) {
                RuntimeReflection.register((Field[])new Field[]{f2});
            }
        }
    }

    private ResourcesRegistry getResourceRegistry() {
        if (this.resourcesRegistry == null) {
            this.resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        }
        return this.resourcesRegistry;
    }
}

