/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CMarshaller;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.RAW;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CRawAccessor
extends RawAccessor
implements T4CAccessor {
    T4CMAREngine mare;
    boolean underlyingLongRaw;
    private T4CMarshaller marshaller;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    T4CRawAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$12, null, stmt, max_len, form, external_type, forBind, _mare);
            }
            this.underlyingLongRaw = false;
            this.marshaller = null;
            this.mare = _mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    T4CRawAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len == -1 ? _definedColumnSize : max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$13, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, _definedColumnType, _definedColumnSize, _mare);
            }
            this.underlyingLongRaw = false;
            this.marshaller = null;
            this.mare = _mare;
            if (stmt != null && stmt.implicitDefineForLobPrefetchDone) {
                this.definedColumnType = 0;
                this.definedColumnSize = 0;
            } else {
                this.definedColumnType = _definedColumnType;
                this.definedColumnSize = _definedColumnSize;
            }
            if (max_len == -1) {
                this.underlyingLongRaw = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$13, null);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public T4CMAREngine getMAREngine() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$0, this, new Object[0]);
            }
            T4CMAREngine t4CMAREngine = this.mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$0, this, t4CMAREngine);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$0, this, null);
            }
            return t4CMAREngine;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void unmarshalColumnMetadata() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
                this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processIndicator(int n2) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
                this.mare.unmarshalSB2();
                this.mare.unmarshalUB2();
            } else if (this.statement.connection.versionNumber < 9200) {
                this.mare.unmarshalSB2();
                if (!this.statement.sqlKind.isPlsqlOrCall()) {
                    this.mare.unmarshalSB2();
                }
            } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
                void size;
                this.mare.processIndicator(size <= 0, (int)size);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    int getPreviousRowProcessed() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            int n2 = this.previousRowProcessed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$3, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmt;
            void dba;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$4, this, byteArray, oracleStatement);
            }
            this.rowData = dba;
            this.mare = ((T4CConnection)stmt.connection).mare;
            this.rowNull = null;
            this.setCapacity(stmt.getFetchSize());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void copyRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (this.isNullByDescribe || this.previousRowProcessed == -1) {
                this.setNull(this.lastRowProcessed, true);
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            } else if (this.lastRowProcessed == 0) {
                if (this.previousRowProcessed == -1) {
                    this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
                }
                long previousOffset = this.getOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    this.setOffset(this.lastRowProcessed);
                    ((DynamicByteArray)this.rowData).copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            } else if (this.lastCopyRow == this.previousRowProcessed) {
                this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
                this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
                this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
                this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
            } else {
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
            this.previousRowProcessed = this.lastRowProcessed++;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            boolean bl2 = this.getMarshaller().unmarshalOneRow(this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$6, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$6, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int readStreamFromWire(byte[] byArray, int n2, int n3, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer11 t4CTTIoer11) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void oer;
            void mare;
            void readAsNonStreamArr;
            void readHeaderArr;
            void escapeSequenceArr;
            void length;
            void offset;
            void buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$7, this, byArray, n2, n3, nArray, blArray, blArray2, t4CMAREngine, t4CTTIoer11);
            }
            int n4 = this.getMarshaller().readStreamFromWire((byte[])buffer, (int)offset, (int)length, (int[])escapeSequenceArr, (boolean[])readHeaderArr, (boolean[])readAsNonStreamArr, (T4CMAREngine)mare, (T4CTTIoer11)oer);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$7, this, n4);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$7, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    private final T4CMarshaller getMarshaller() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$8, this, new Object[0]);
            }
            if (this.marshaller == null) {
                this.marshaller = this.describeType == 24 ? T4CMarshaller.LONG_RAW : T4CMarshaller.RAW;
            }
            T4CMarshaller t4CMarshaller = this.marshaller;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$8, this, t4CMarshaller);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$8, this, null);
            }
            return t4CMarshaller;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            String ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$9, this, n2);
            }
            if ((ret = super.getString((int)currentRow)) != null && this.definedColumnSize > 0 && ret.length() > this.definedColumnSize * 2) {
                ret = ret.substring(0, this.definedColumnSize * 2);
            }
            String string = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$9, this, string);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$9, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$10, this, n2);
            }
            if (this.definedColumnType == 0) {
                Object object = super.getObject((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$10, this, object);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$10, this, null);
                }
                return object;
            }
            if (this.isNull((int)currentRow)) {
                Object var3_4 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$10, this, var3_4);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$10, this, null);
                }
                return null;
            }
            switch (this.definedColumnType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    String string = this.getString((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$10, this, string);
                        ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$10, this, null);
                    }
                    return string;
                }
                case -4: 
                case -2: {
                    RAW rAW = this.getRAW((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$10, this, rAW);
                        ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$10, this, null);
                    }
                    return rAW;
                }
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$10, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    AccessorPrototype newPrototype(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            AccessorPrototype p2;
            void numRows;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$11, this, n2);
            }
            if (!$assertionsDisabled && numRows < 0) {
                AssertionError assertionError = new AssertionError((Object)("numRows: " + (int)numRows));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$11, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            AccessorPrototype accessorPrototype = p2 = new AccessorPrototype((int)numRows, this, this.statement.rowData){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                Accessor newAccessor(OracleStatement stmt) throws SQLException {
                    T4CRawAccessor acc = new T4CRawAccessor(stmt, T4CRawAccessor.this.describeMaxLength, T4CRawAccessor.this.nullable, -1, T4CRawAccessor.this.precision, T4CRawAccessor.this.scale, T4CRawAccessor.this.contflag, -1, T4CRawAccessor.this.formOfUse, T4CRawAccessor.this.definedColumnType, T4CRawAccessor.this.definedColumnSize, null);
                    this.initializeRowData(acc);
                    return acc;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(T4CRawAccessor.class, Integer.TYPE, Accessor.class, ByteArray.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("newAccessor", OracleStatement.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$11, this, accessorPrototype);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$11, this, null);
            }
            return accessorPrototype;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CRawAccessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$13 = T4CRawAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE, Integer.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CRawAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CRawAccessor.class.getDeclaredMethod("newPrototype", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CRawAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CRawAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CRawAccessor.class.getDeclaredMethod("getMarshaller", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CRawAccessor.class.getDeclaredMethod("readStreamFromWire", byte[].class, Integer.TYPE, Integer.TYPE, int[].class, boolean[].class, boolean[].class, T4CMAREngine.class, T4CTTIoer11.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CRawAccessor.class.getDeclaredMethod("unmarshalOneRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CRawAccessor.class.getDeclaredMethod("copyRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CRawAccessor.class.getDeclaredMethod("reinitForResultSetCache", ByteArray.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CRawAccessor.class.getDeclaredMethod("getPreviousRowProcessed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CRawAccessor.class.getDeclaredMethod("processIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CRawAccessor.class.getDeclaredMethod("unmarshalColumnMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CRawAccessor.class.getDeclaredMethod("getMAREngine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

