/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.bytecode;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.bytecode.BytecodeConfigEncoder;
import com.oracle.truffle.api.instrumentation.Tag;
import java.util.Objects;

public final class BytecodeConfig {
    private static final long SOURCE_ENCODING = 1L;
    public static final BytecodeConfig DEFAULT = new BytecodeConfig(null, 0L);
    public static final BytecodeConfig WITH_SOURCE = new BytecodeConfig(null, 1L);
    public static final BytecodeConfig COMPLETE = new BytecodeConfig(null, -1L);
    final BytecodeConfigEncoder encoder;
    final long encoding;

    BytecodeConfig(BytecodeConfigEncoder encoder, long encoding) {
        this.encoder = encoder;
        this.encoding = encoding;
    }

    public static Builder newBuilder(BytecodeConfigEncoder encoder) {
        return new Builder(encoder);
    }

    public static class Builder {
        private final BytecodeConfigEncoder encoder;
        private long encoding;

        Builder(BytecodeConfigEncoder encoder) {
            Objects.requireNonNull(encoder);
            this.encoder = encoder;
        }

        public Builder addSource() {
            CompilerAsserts.neverPartOfCompilation();
            this.encoding |= 1L;
            return this;
        }

        public Builder addTag(Class<? extends Tag> tag) {
            CompilerAsserts.neverPartOfCompilation();
            Objects.requireNonNull(tag);
            long encodedTag = this.encoder.encodeTag(tag);
            assert (encodedTag != 1L && Long.bitCount(encodedTag) == 1) : "generated code invariant violated";
            this.encoding |= encodedTag;
            return this;
        }

        public Builder addInstrumentation(Class<?> instrumentation) {
            CompilerAsserts.neverPartOfCompilation();
            Objects.requireNonNull(instrumentation);
            long encodedTag = this.encoder.encodeInstrumentation(instrumentation);
            assert (encodedTag != 1L && Long.bitCount(encodedTag) == 1) : "generated code invariant violated";
            this.encoding |= encodedTag;
            return this;
        }

        @CompilerDirectives.TruffleBoundary
        public BytecodeConfig build() {
            return new BytecodeConfig(this.encoder, this.encoding);
        }
    }
}

