/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.bytecode.SetupAnnotationsNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateUncached
@ImportStatic(value={PArguments.class})
@GenerateInline(value=false)
@OperationProxy.Proxyable
public abstract class SetupAnnotationsNode
extends PNodeWithContext {
    public abstract void execute(Frame var1);

    @Specialization
    public static void doLocals(VirtualFrame frame, @Bind Node inliningTarget, @Cached InlinedConditionProfile hasLocals, @Cached SetupAnnotationsFromDictOrModuleNode setup) {
        Object locals = PArguments.getSpecialArgument((Frame)frame);
        if (hasLocals.profile(inliningTarget, locals != null)) {
            setup.execute((Frame)frame, inliningTarget, locals);
        } else {
            setup.execute((Frame)frame, inliningTarget, PArguments.getGlobals((Frame)frame));
        }
    }

    public static SetupAnnotationsNode create() {
        return SetupAnnotationsNodeGen.create();
    }

    public static SetupAnnotationsNode getUncached() {
        return SetupAnnotationsNodeGen.getUncached();
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetupAnnotationsFromDictOrModuleNode
    extends PNodeWithContext {
        public abstract void execute(Frame var1, Node var2, Object var3);

        @Specialization
        static void doModule(Node inliningTarget, PythonModule locals, @Cached(inline=false) ReadAttributeFromObjectNode read, @Cached(inline=false) WriteAttributeToObjectNode write, @Cached @Cached.Exclusive InlinedBranchProfile create) {
            Object annotations = read.execute(locals, SpecialAttributeNames.T___ANNOTATIONS__);
            if (annotations == PNone.NO_VALUE) {
                create.enter(inliningTarget);
                write.execute(locals, SpecialAttributeNames.T___ANNOTATIONS__, PFactory.createDict(PythonLanguage.get(inliningTarget)));
            }
        }

        @Specialization(guards={"isBuiltinDict(locals)"})
        static void doBuiltinDict(VirtualFrame frame, Node inliningTarget, PDict locals, @Cached PyDictGetItem getItem, @Cached PyDictSetItem setItem, @Cached @Cached.Exclusive InlinedBranchProfile create) {
            Object annotations = getItem.execute((Frame)frame, inliningTarget, locals, SpecialAttributeNames.T___ANNOTATIONS__);
            if (annotations == null) {
                create.enter(inliningTarget);
                setItem.execute((Frame)frame, inliningTarget, locals, SpecialAttributeNames.T___ANNOTATIONS__, PFactory.createDict(PythonLanguage.get(inliningTarget)));
            }
        }

        @Fallback
        static void doOther(VirtualFrame frame, Node inliningTarget, Object locals, @Cached PyObjectGetItem getItem, @Cached PyObjectSetItem setItem, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            try {
                getItem.execute((Frame)frame, inliningTarget, locals, SpecialAttributeNames.T___ANNOTATIONS__);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.KeyError, errorProfile);
                setItem.execute((Frame)frame, inliningTarget, locals, SpecialAttributeNames.T___ANNOTATIONS__, PFactory.createDict(PythonLanguage.get(inliningTarget)));
            }
        }
    }
}

