/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.str;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Objects;

public final class NativeCharSequence
implements CharSequence {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(NativeCharSequence.class);
    private final Object ptr;
    private final int elements;
    private final int elementSize;
    private final boolean asciiOnly;
    private TruffleString materialized;

    public NativeCharSequence(Object ptr, int elements, int elementSize, boolean asciiOnly) {
        assert (elements >= -1);
        assert (elementSize == 1 || elementSize == 2 || elementSize == 4);
        assert (!(ptr instanceof String));
        assert (!(ptr instanceof PString));
        assert (!(ptr instanceof TruffleString));
        this.ptr = ptr;
        this.elements = elements;
        this.elementSize = elementSize;
        this.asciiOnly = asciiOnly;
    }

    @Override
    public int length() {
        return TruffleString.CodePointLengthNode.getUncached().execute((AbstractTruffleString)this.materialize(), PythonUtils.TS_ENCODING);
    }

    @Override
    public char charAt(int index) {
        return (char)TruffleString.CodePointAtIndexNode.getUncached().execute((AbstractTruffleString)this.materialize(), index, PythonUtils.TS_ENCODING);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.materialize().toJavaStringUncached().subSequence(start, end);
    }

    boolean isMaterialized() {
        return this.materialized != null;
    }

    TruffleString getMaterialized() {
        return this.materialized;
    }

    TruffleString materialize() {
        if (!this.isMaterialized()) {
            LOGGER.warning("uncached materialization of NativeCharSequence");
            assert (PythonUtils.TS_ENCODING == TruffleString.Encoding.UTF_32) : "needs switch_encoding otherwise";
            this.materialized = TruffleString.fromIntArrayUTF32Uncached((int[])CExtCommonNodes.ReadUnicodeArrayNode.executeUncached(this.getPtr(), this.getElements(), this.getElementSize()));
        }
        return this.materialized;
    }

    public Object getPtr() {
        return this.ptr;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public boolean isAsciiOnly() {
        return this.asciiOnly;
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.isMaterialized()) {
            return this.materialized.toJavaStringUncached();
        }
        return Objects.toString(this.ptr);
    }

    public int getElements() {
        return this.elements;
    }
}

