/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.TypingModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.frame.FrameBuiltins;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.typing.PTypeVarTuple;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_typing")
public class TypingModuleBuiltins
extends PythonBuiltins {
    public static final TruffleString T_GENERIC_ALIAS = PythonUtils.tsLiteral("_GenericAlias");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TypingModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("Generic", (Object)PythonBuiltinClassType.PGeneric);
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class UnpackTypeVarTuplesNode
    extends Node {
        public abstract PTuple execute(VirtualFrame var1, Node var2, PTuple var3);

        @Specialization
        static PTuple doUnpack(VirtualFrame frame, Node inliningTarget, PTuple params, @Bind PythonLanguage language, @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached UnpackNode unpackNode) {
            Object[] elements = toArrayNode.execute(inliningTarget, params.getSequenceStorage());
            boolean found = false;
            for (Object element : elements) {
                if (!(element instanceof PTypeVarTuple)) continue;
                found = true;
                break;
            }
            if (!found) {
                return params;
            }
            Object[] unpacked = new Object[elements.length];
            for (int i = 0; i < unpacked.length; ++i) {
                Object object = elements[i];
                if (object instanceof PTypeVarTuple) {
                    PTypeVarTuple typeVarTuple = (PTypeVarTuple)object;
                    unpacked[i] = unpackNode.execute(frame, inliningTarget, typeVarTuple);
                    continue;
                }
                unpacked[i] = elements[i];
            }
            return PFactory.createTuple(language, unpacked);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class UnpackNode
    extends Node {
        private static final TruffleString T_UNPACK = PythonUtils.tsLiteral("Unpack");

        public abstract Object execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization
        static Object doUnpack(VirtualFrame frame, Node inliningTarget, Object tvt, @Cached PyObjectGetAttr getAttrNode, @Cached PyObjectGetItem getItemNode) {
            PythonModule typing = AbstractImportNode.importModule(BuiltinNames.T_TYPING);
            Object unpack = getAttrNode.execute((Frame)frame, inliningTarget, typing, T_UNPACK);
            return getItemNode.execute((Frame)frame, inliningTarget, unpack, tvt);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CallerNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2);

        @Specialization
        static Object caller(VirtualFrame frame, @Cached(inline=false) FrameBuiltins.GetGlobalsNode getGlobalsNode, @Cached(inline=false) PyObjectCallMethodObjArgs callMethod, @Cached(inline=false) ReadCallerFrameNode readCallerNode) {
            PFrame.Reference currentFrameInfo = PArguments.getCurrentFrameInfo((Frame)frame);
            PFrame pFrame = readCallerNode.executeWith(currentFrameInfo, 0);
            Object globals = getGlobalsNode.execute(frame, pFrame);
            return callMethod.executeCached((Frame)frame, globals, SpecialMethodNames.T_GET, SpecialAttributeNames.T___NAME__, PNone.NONE);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CallTypingArgsKwargsNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2, TruffleString var3, Object var4, Object[] var5, PKeyword[] var6);

        @Specialization
        static Object doCall(VirtualFrame frame, Node inliningTarget, TruffleString name, Object cls, Object[] args, PKeyword[] keywords, @Cached PyObjectGetAttr getAttrNode, @Cached(inline=false) CallNode callNode) {
            PythonModule typing = AbstractImportNode.importModule(BuiltinNames.T_TYPING);
            Object func = getAttrNode.execute((Frame)frame, inliningTarget, typing, name);
            Object[] args2 = new Object[args.length + 1];
            args2[0] = cls;
            PythonUtils.arraycopy(args, 0, args2, 1, args.length);
            return callNode.execute((Frame)frame, func, args2, keywords);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallTypingFuncObjectNode
    extends Node {
        abstract Object executeInternal(VirtualFrame var1, Node var2, TruffleString var3, Object[] var4);

        public final Object execute(VirtualFrame frame, Node inliningTarget, TruffleString name, Object ... args) {
            return this.executeInternal(frame, inliningTarget, name, args);
        }

        @Specialization
        static Object doCall(VirtualFrame frame, Node inliningTarget, TruffleString name, Object[] args, @Cached PyObjectGetAttr getAttrNode, @Cached(inline=false) CallNode callNode) {
            PythonModule typing = AbstractImportNode.importModule(BuiltinNames.T_TYPING);
            Object func = getAttrNode.execute((Frame)frame, inliningTarget, typing, name);
            return callNode.execute((Frame)frame, func, args);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class TypeCheckNode
    extends Node {
        private static final TruffleString T__TYPE_CHECK = PythonUtils.tsLiteral("_type_check");

        TypeCheckNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, Object var3, TruffleString var4);

        @Specialization
        static Object none(PNone arg, TruffleString msg) {
            return PNone.NONE;
        }

        @Fallback
        static Object check(VirtualFrame frame, Node inliningTarget, Object arg, TruffleString msg, @Cached CallTypingFuncObjectNode callTypingFuncObjectNode) {
            return callTypingFuncObjectNode.execute(frame, inliningTarget, T__TYPE_CHECK, arg, msg);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CheckBoundNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization
        static Object none(PNone bound) {
            return PNone.NONE;
        }

        @Fallback
        static Object check(VirtualFrame frame, Node inliningTarget, Object bound, @Cached TypeCheckNode typeCheckNode) {
            return typeCheckNode.execute(frame, inliningTarget, bound, ErrorMessages.BOUND_MUST_BE_A_TYPE);
        }
    }

    @Builtin(name="_idfunc", minNumOfPositionalArgs=1, parameterNames={"x"})
    @GenerateNodeFactory
    static abstract class IdFuncNode
    extends PythonUnaryBuiltinNode {
        IdFuncNode() {
        }

        @Specialization
        static Object doIt(Object x) {
            return x;
        }
    }
}

