/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.core.Utils;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.sql.SQLException;
import java.sql.Savepoint;

public class RedshiftSavepoint
implements Savepoint {
    private boolean isValid = true;
    private final boolean isNamed;
    private int id;
    private String name;

    public RedshiftSavepoint(int id) {
        this.isNamed = false;
        this.id = id;
    }

    public RedshiftSavepoint(String name) {
        this.isNamed = true;
        this.name = name;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (!this.isValid) {
            throw new RedshiftException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), RedshiftState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed) {
            throw new RedshiftException(GT.tr("Cannot retrieve the id of a named savepoint.", new Object[0]), RedshiftState.WRONG_OBJECT_TYPE);
        }
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (!this.isValid) {
            throw new RedshiftException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), RedshiftState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (!this.isNamed) {
            throw new RedshiftException(GT.tr("Cannot retrieve the name of an unnamed savepoint.", new Object[0]), RedshiftState.WRONG_OBJECT_TYPE);
        }
        return this.name;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public String getRSName() throws SQLException {
        if (!this.isValid) {
            throw new RedshiftException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), RedshiftState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this.isNamed) {
            return Utils.escapeIdentifier(null, this.name).toString();
        }
        return "JDBC_SAVEPOINT_" + this.id;
    }
}

