/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import us.fatehi.utility.Utility;

public class CollectionsUtility {
    public static <T extends Comparable<? super T>> int compareLists(List<? extends T> list1, List<? extends T> list2) {
        if (list1 == null && list2 == null) {
            return 0;
        }
        if (list1 == null) {
            return -1;
        }
        if (list2 == null) {
            return 1;
        }
        int comparison = Integer.compare(list1.size(), list2.size());
        if (comparison == 0) {
            Iterator<T> iter1 = list1.iterator();
            Iterator<T> iter2 = list2.iterator();
            while (comparison == 0 && iter1.hasNext() && iter2.hasNext()) {
                Comparable object1 = (Comparable)iter1.next();
                Comparable object2 = (Comparable)iter2.next();
                comparison = object1.compareTo(object2);
            }
        }
        return comparison;
    }

    public static <E> boolean listStartsWith(List<E> main, List<E> sub) {
        if (main == null || sub == null || main.size() < sub.size()) {
            return false;
        }
        if (main.isEmpty()) {
            return true;
        }
        return main.subList(0, sub.size()).equals(sub);
    }

    public static String[] splitList(String input) {
        return CollectionsUtility.splitList(input, ",");
    }

    public static String[] splitList(String input, String delimiter) {
        if (delimiter == null) {
            return new String[]{input};
        }
        Set setOfStrings = Arrays.stream(Utility.trimToEmpty(input).split(delimiter)).filter(Objects::nonNull).map(String::strip).filter(Predicate.not(String::isEmpty)).collect(Collectors.toCollection(LinkedHashSet::new));
        return setOfStrings.toArray(new String[0]);
    }

    private CollectionsUtility() {
    }
}

