/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.tools.RelBuilder;

public final class PPLHintUtils {
    private static final String HINT_AGG_ARGUMENTS = "AGG_ARGS";
    private static final String KEY_IGNORE_NULL_BUCKET = "ignoreNullBucket";
    private static final String KEY_HAS_NESTED_AGG_CALL = "hasNestedAggCall";
    private static final Supplier<HintStrategyTable> HINT_STRATEGY_TABLE = Suppliers.memoize(() -> HintStrategyTable.builder().hintStrategy(HINT_AGG_ARGUMENTS, (hint, rel) -> rel instanceof LogicalAggregate).build());

    public static void addIgnoreNullBucketHintToAggregate(RelBuilder relBuilder) {
        assert (relBuilder.peek() instanceof LogicalAggregate) : "Hint HINT_AGG_ARGUMENTS can be added to LogicalAggregate only";
        RelHint statHint = RelHint.builder((String)HINT_AGG_ARGUMENTS).hintOption(KEY_IGNORE_NULL_BUCKET, "true").build();
        relBuilder.hints(new RelHint[]{statHint});
        if (relBuilder.getCluster().getHintStrategies() == HintStrategyTable.EMPTY) {
            relBuilder.getCluster().setHintStrategies(HINT_STRATEGY_TABLE.get());
        }
    }

    public static void addNestedAggCallHintToAggregate(RelBuilder relBuilder) {
        assert (relBuilder.peek() instanceof LogicalAggregate) : "Hint HINT_AGG_ARGUMENTS can be added to LogicalAggregate only";
        RelHint statHint = RelHint.builder((String)HINT_AGG_ARGUMENTS).hintOption(KEY_HAS_NESTED_AGG_CALL, "true").build();
        relBuilder.hints(new RelHint[]{statHint});
        if (relBuilder.getCluster().getHintStrategies() == HintStrategyTable.EMPTY) {
            relBuilder.getCluster().setHintStrategies(HINT_STRATEGY_TABLE.get());
        }
    }

    public static boolean ignoreNullBucket(Aggregate aggregate) {
        return aggregate.getHints().stream().anyMatch(hint -> hint.hintName.equals(HINT_AGG_ARGUMENTS) && hint.kvOptions.getOrDefault(KEY_IGNORE_NULL_BUCKET, "false").equals("true"));
    }

    public static boolean hasNestedAggCall(Aggregate aggregate) {
        return aggregate.getHints().stream().anyMatch(hint -> hint.hintName.equals(HINT_AGG_ARGUMENTS) && hint.kvOptions.getOrDefault(KEY_HAS_NESTED_AGG_CALL, "false").equals("true"));
    }

    @Generated
    private PPLHintUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

