/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.generator;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyPairGeneratorSpi;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.cryptacular.CryptUtil;

public final class KeyPairGenerator {
    private KeyPairGenerator() {
    }

    public static KeyPair generateDSA(SecureRandom random, int bitLength) {
        CryptUtil.assertNotNullArg(random, "Secure random cannot be null");
        if (bitLength < 1) {
            throw new IllegalArgumentException("Bit length must be positive");
        }
        org.bouncycastle.jcajce.provider.asymmetric.dsa.KeyPairGeneratorSpi generator = new org.bouncycastle.jcajce.provider.asymmetric.dsa.KeyPairGeneratorSpi();
        generator.initialize(bitLength, random);
        return generator.generateKeyPair();
    }

    public static KeyPair generateRSA(SecureRandom random, int bitLength) {
        CryptUtil.assertNotNullArg(random, "Secure random cannot be null");
        if (bitLength < 1) {
            throw new IllegalArgumentException("Bit length must be positive");
        }
        KeyPairGeneratorSpi generator = new KeyPairGeneratorSpi();
        generator.initialize(bitLength, random);
        return generator.generateKeyPair();
    }

    public static KeyPair generateEC(SecureRandom random, int bitLength) {
        CryptUtil.assertNotNullArg(random, "Secure random cannot be null");
        if (bitLength < 1) {
            throw new IllegalArgumentException("Bit length must be positive");
        }
        KeyPairGeneratorSpi.EC generator = new KeyPairGeneratorSpi.EC();
        generator.initialize(bitLength, random);
        return generator.generateKeyPair();
    }

    public static KeyPair generateEC(SecureRandom random, String namedCurve) {
        CryptUtil.assertNotNullArg(random, "Secure random cannot be null");
        CryptUtil.assertNotNullArg(namedCurve, "Named curve cannot be null");
        KeyPairGeneratorSpi.EC generator = new KeyPairGeneratorSpi.EC();
        try {
            generator.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec(namedCurve), random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException("Invalid EC curve " + namedCurve, e);
        }
        return generator.generateKeyPair();
    }
}

