/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec;

import java.io.IOException;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.lucene103.Lucene103Codec;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.opensearch.index.codec.CriteriaBasedDocValueFormat;

public class CriteriaBasedCodec
extends FilterCodec {
    private final String bucket;
    public static final String BUCKET_NAME = "bucket";
    private static final String PLACEHOLDER_BUCKET_FOR_PARENT_WRITER = "-2";

    public CriteriaBasedCodec() {
        super("CriteriaBasedCodec", (Codec)new Lucene103Codec());
        this.bucket = null;
    }

    public CriteriaBasedCodec(Codec delegate, String bucket) {
        super("CriteriaBasedCodec", delegate);
        this.bucket = bucket;
    }

    public SegmentInfoFormat segmentInfoFormat() {
        return new SegmentInfoFormat(){

            public SegmentInfo read(Directory directory, String segmentName, byte[] segmentID, IOContext context) throws IOException {
                return CriteriaBasedCodec.this.delegate.segmentInfoFormat().read(directory, segmentName, segmentID, context);
            }

            public void write(Directory directory, SegmentInfo info, IOContext ioContext) throws IOException {
                if (CriteriaBasedCodec.this.bucket != null) {
                    info.putAttribute(CriteriaBasedCodec.BUCKET_NAME, CriteriaBasedCodec.this.bucket);
                } else if (info.getAttribute(CriteriaBasedCodec.BUCKET_NAME) == null) {
                    info.putAttribute(CriteriaBasedCodec.BUCKET_NAME, CriteriaBasedCodec.PLACEHOLDER_BUCKET_FOR_PARENT_WRITER);
                }
                CriteriaBasedCodec.this.delegate.segmentInfoFormat().write(directory, info, ioContext);
            }
        };
    }

    public DocValuesFormat docValuesFormat() {
        return new CriteriaBasedDocValueFormat(this.bucket);
    }
}

