/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.Closeable;
import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.bytes.ReleasableBytesReference;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.transport.Header;
import org.opensearch.transport.ProtocolInboundMessage;
import org.opensearch.transport.TransportProtocol;

@PublicApi(since="1.0.0")
public class InboundMessage
implements Releasable,
ProtocolInboundMessage {
    static final InboundMessage PING = new InboundMessage(null, null, null, true, null);
    protected final Header header;
    protected final ReleasableBytesReference content;
    protected final Exception exception;
    protected final boolean isPing;
    private Releasable breakerRelease;
    private StreamInput streamInput;

    public InboundMessage(Header header, ReleasableBytesReference content, Releasable breakerRelease) {
        this(header, content, null, false, breakerRelease);
    }

    public InboundMessage(Header header, Exception exception) {
        this(header, null, exception, false, null);
    }

    public InboundMessage(Header header, boolean isPing) {
        this(header, null, null, isPing, null);
    }

    private InboundMessage(Header header, ReleasableBytesReference content, Exception exception, boolean isPing, Releasable breakerRelease) {
        this.header = header;
        this.content = content;
        this.exception = exception;
        this.isPing = isPing;
        this.breakerRelease = breakerRelease;
    }

    TransportProtocol getTransportProtocol() {
        if (this.isPing) {
            return TransportProtocol.NATIVE;
        }
        return this.header.getTransportProtocol();
    }

    @Override
    public String getProtocol() {
        return this.header.getTransportProtocol().toString();
    }

    public Header getHeader() {
        return this.header;
    }

    public int getContentLength() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length();
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isPing() {
        return this.isPing;
    }

    public boolean isShortCircuit() {
        return this.exception != null;
    }

    public Releasable takeBreakerReleaseControl() {
        Releasable toReturn = this.breakerRelease;
        this.breakerRelease = null;
        if (toReturn != null) {
            return toReturn;
        }
        return () -> {};
    }

    public StreamInput openOrGetStreamInput() throws IOException {
        assert (!this.isPing && this.content != null);
        if (this.streamInput == null) {
            this.streamInput = this.content.streamInput();
            this.streamInput.setVersion(this.header.getVersion());
        }
        return this.streamInput;
    }

    public void close() {
        IOUtils.closeWhileHandlingException((Closeable)this.streamInput);
        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.content, this.breakerRelease});
    }

    public String toString() {
        return "InboundMessage{" + String.valueOf(this.header) + "}";
    }
}

