/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.status;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitFileNode;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.GitStatusNode;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.AddAction;
import org.netbeans.modules.git.ui.checkout.CheckoutPathsAction;
import org.netbeans.modules.git.ui.checkout.RevertChangesAction;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.commit.DeleteLocalAction;
import org.netbeans.modules.git.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.git.ui.commit.IncludeInCommitAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsAction;
import org.netbeans.modules.git.ui.diff.DiffAction;
import org.netbeans.modules.git.ui.ignore.IgnoreAction;
import org.netbeans.modules.git.ui.status.Bundle;
import org.netbeans.modules.git.ui.status.FileTreeViewImpl;
import org.netbeans.modules.git.ui.status.GitStatusTable;
import org.netbeans.modules.git.ui.status.StatusAction;
import org.netbeans.modules.git.ui.status.VersioningPanel;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.OpenInEditorAction;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.common.FileViewComponent;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.versioning.util.status.VCSStatusTableModel;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class VersioningPanelController
implements ActionListener,
PropertyChangeListener,
PreferenceChangeListener {
    private final VersioningPanel panel;
    private VCSContext context;
    private EnumSet<FileInformation.Status> displayStatuses;
    private final NoContentPanel noContentComponent = new NoContentPanel();
    private static final RequestProcessor RP = new RequestProcessor("GitVersioningWindow", 1, true);
    private final RequestProcessor.Task refreshNodesTask = RP.create((Runnable)new RefreshNodesTask());
    private final ApplyChangesTask applyChangeTask = new ApplyChangesTask();
    private final RequestProcessor.Task changeTask = RP.create((Runnable)this.applyChangeTask);
    static final Logger LOG = Logger.getLogger(VersioningPanelController.class.getName());
    private FileInformation.Mode mode;
    private GitProgressSupport refreshStatusSupport;
    private final ModeKeeper modeKeeper;
    private PreferenceChangeListener list;
    private FileViewComponent<GitStatusNodeImpl> activeComponent;
    private GitStatusTable fileListComponent;
    private FileTreeViewImpl fileTreeComponent;
    private static final int VIEW_MODE_TABLE = 1;
    private static final int VIEW_MODE_TREE = 2;
    private int popupViewIndex;
    private final Map<File, FileStatusCache.ChangedEvent> changes = new HashMap<File, FileStatusCache.ChangedEvent>();

    VersioningPanelController() {
        this.panel = new VersioningPanel();
        this.modeKeeper = new ModeKeeper();
        this.initPanelMode();
        this.initFileComponent();
        this.attachListeners();
    }

    void setActions(JComponent comp) {
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        comp.getInputMap(0).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        comp.getInputMap(0).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        this.panel.getActionMap().put("prevInnerView", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersioningPanelController.this.onNextInnerView();
            }
        });
        this.panel.getActionMap().put("nextInnerView", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersioningPanelController.this.onPrevInnerView();
            }
        });
    }

    void focus() {
        this.noContentComponent.requestFocusInWindow();
        this.getActiveFileComponent().focus();
    }

    JPanel getPanel() {
        return this.panel;
    }

    void setContext(VCSContext context) {
        if (context != this.context) {
            this.context = context;
            this.refreshNodes();
        }
    }

    void cancelRefresh() {
    }

    JPopupMenu getPopupFor(final Node[] nodes) {
        final JPopupMenu menu = new JPopupMenu();
        final int popupIndex = ++this.popupViewIndex;
        File[] files = this.toFiles(nodes);
        JMenuItem item = menu.add((Action)new OpenInEditorAction(files));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.addSeparator();
        final JMenuItem dummyItem = menu.add(Bundle.CTL_GitStatusTable_popup_initializing());
        dummyItem.setEnabled(false);
        Git.getInstance().getRequestProcessor().post(new Runnable(){
            final /* synthetic */ VersioningPanelController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                SystemActionBridge ia;
                Lookup lkp = Lookups.fixed((Object[])nodes);
                boolean displayAdd = false;
                boolean allLocallyNew = true;
                for (Node node : nodes) {
                    GitFileNode.GitLocalFileNode statusNode = (GitFileNode.GitLocalFileNode)((Object)node.getLookup().lookup(GitFileNode.GitLocalFileNode.class));
                    if (statusNode != null) {
                        FileInformation info = statusNode.getInformation();
                        if (info.containsStatus(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.IN_CONFLICT, FileInformation.Status.MODIFIED_INDEX_WORKING_TREE))) {
                            displayAdd = true;
                        }
                        if (info.containsStatus(EnumSet.of(FileInformation.Status.NEW_HEAD_INDEX, FileInformation.Status.NEW_HEAD_WORKING_TREE))) continue;
                        allLocallyNew = false;
                        continue;
                    }
                    allLocallyNew = false;
                    displayAdd = true;
                }
                if (popupIndex != this.this$0.popupViewIndex) {
                    return;
                }
                final ArrayList<SystemActionBridge> actions = new ArrayList<SystemActionBridge>();
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)NbBundle.getMessage(CommitAction.class, (String)"LBL_CommitAction.popupName"), (Lookup)lkp));
                if (popupIndex != this.this$0.popupViewIndex) {
                    return;
                }
                actions.add(new SystemActionBridge(((DiffAction)SystemAction.get(DiffAction.class)).createContextAwareInstance(lkp), NbBundle.getMessage(DiffAction.class, (String)"LBL_DiffAction_PopupName")){

                    public void actionPerformed(ActionEvent e) {
                        this$0.modeKeeper.storeMode();
                        super.actionPerformed(e);
                    }
                });
                if (displayAdd) {
                    actions.add(SystemActionBridge.createAction((Action)SystemAction.get(AddAction.class), (String)NbBundle.getMessage(AddAction.class, (String)"LBL_AddAction.popupName"), (Lookup)lkp));
                }
                if (allLocallyNew) {
                    SystemAction systemAction = SystemAction.get(DeleteLocalAction.class);
                    actions.add(SystemActionBridge.createAction((Action)systemAction, (String)NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_PopupMenuItem_Delete"), (Lookup)lkp));
                }
                SystemActionBridge efca = SystemActionBridge.createAction((Action)SystemAction.get(ExcludeFromCommitAction.class), (String)NbBundle.getMessage(ExcludeFromCommitAction.class, (String)"LBL_ExcludeFromCommitAction_PopupName"), (Lookup)lkp);
                SystemActionBridge iica = SystemActionBridge.createAction((Action)SystemAction.get(IncludeInCommitAction.class), (String)NbBundle.getMessage(IncludeInCommitAction.class, (String)"LBL_IncludeInCommitAction_PopupName"), (Lookup)lkp);
                if (efca.isEnabled() || iica.isEnabled()) {
                    if (efca.isEnabled()) {
                        actions.add(efca);
                    } else if (iica.isEnabled()) {
                        actions.add(iica);
                    }
                }
                if ((ia = SystemActionBridge.createAction((Action)SystemAction.get(IgnoreAction.class), (String)NbBundle.getMessage(IgnoreAction.class, (String)"LBL_IgnoreAction_PopupName"), (Lookup)lkp)).isEnabled()) {
                    actions.add(ia);
                }
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(RevertChangesAction.class), (String)NbBundle.getMessage(CheckoutPathsAction.class, (String)"LBL_RevertChangesAction_PopupName"), (Lookup)lkp));
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(CheckoutPathsAction.class), (String)NbBundle.getMessage(CheckoutPathsAction.class, (String)"LBL_CheckoutPathsAction_PopupName"), (Lookup)lkp));
                ResolveConflictsAction a = (ResolveConflictsAction)SystemAction.get(ResolveConflictsAction.class);
                if (a.isEnabled()) {
                    actions.add(null);
                    actions.add(SystemActionBridge.createAction((Action)((Object)a), (String)NbBundle.getMessage(ResolveConflictsAction.class, (String)"LBL_ResolveConflictsAction_PopupName"), (Lookup)lkp));
                }
                if (popupIndex == this.this$0.popupViewIndex) {
                    EventQueue.invokeLater(new Runnable(){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (popupIndex == this.this$1.this$0.popupViewIndex && menu.isShowing()) {
                                menu.remove(dummyItem);
                                for (Action a : actions) {
                                    if (a == null) {
                                        menu.addSeparator();
                                        continue;
                                    }
                                    JMenuItem item = menu.add(a);
                                    Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
                                }
                                menu.pack();
                                menu.repaint();
                            }
                        }
                    });
                }
            }
        });
        return menu;
    }

    private void initFileComponent() {
        this.fileListComponent = new GitStatusTable(this, (VCSStatusTableModel<GitStatusNodeImpl>)new VCSStatusTableModel((VCSStatusNode[])new GitStatusNodeImpl[0]), this.modeKeeper);
        this.fileListComponent.addPropertyChangeListener(this);
        this.fileTreeComponent = new FileTreeViewImpl(this, this.modeKeeper);
        int viewMode = GitModuleConfig.getDefault().getStatusViewMode(1);
        if (viewMode == 2) {
            this.panel.treeButton.setSelected(true);
            this.setActiveComponent((FileViewComponent<GitStatusNodeImpl>)this.fileTreeComponent);
        } else {
            this.panel.listButton.setSelected(true);
            this.setActiveComponent((FileViewComponent<GitStatusNodeImpl>)this.fileListComponent);
        }
    }

    private FileViewComponent<GitStatusNodeImpl> getActiveFileComponent() {
        return this.activeComponent;
    }

    private void setActiveComponent(FileViewComponent<GitStatusNodeImpl> fileComponent) {
        if (this.activeComponent == fileComponent) {
            return;
        }
        this.activeComponent = fileComponent;
        GitModuleConfig.getDefault().setStatusViewMode(this.activeComponent == this.fileListComponent ? 1 : 2);
        this.setVersioningComponent(this.activeComponent.getComponent());
    }

    private void attachListeners() {
        this.panel.tgbHeadVsWorking.addActionListener(this);
        this.panel.tgbHeadVsIndex.addActionListener(this);
        this.panel.tgbIndexVsWorking.addActionListener(this);
        this.panel.btnCommit.addActionListener(this);
        this.panel.btnRevert.addActionListener(this);
        this.panel.btnDiff.addActionListener(this);
        this.panel.btnRefresh.addActionListener(this);
        this.panel.listButton.addActionListener(this);
        this.panel.treeButton.addActionListener(this);
        Git.getInstance().getFileStatusCache().addPropertyChangeListener(this);
        this.list = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)GitModuleConfig.getDefault().getPreferences());
        GitModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this.list);
    }

    private void onPrevInnerView() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.panel.tgbHeadVsIndex.setSelected(true);
        } else if (this.panel.tgbHeadVsIndex.isSelected()) {
            this.panel.tgbIndexVsWorking.setSelected(true);
        } else {
            this.panel.tgbHeadVsWorking.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    private void onNextInnerView() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.panel.tgbIndexVsWorking.setSelected(true);
        } else if (this.panel.tgbIndexVsWorking.isSelected()) {
            this.panel.tgbHeadVsIndex.setSelected(true);
        } else {
            this.panel.tgbHeadVsWorking.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    private void onDisplayedStatusChanged() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.mode = FileInformation.Mode.HEAD_VS_WORKING_TREE;
            this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanelController.class, (String)"MSG_No_Changes_HeadWorking"));
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING);
            this.modeKeeper.setMode(this.mode);
        } else if (this.panel.tgbHeadVsIndex.isSelected()) {
            this.mode = FileInformation.Mode.HEAD_VS_INDEX;
            this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanelController.class, (String)"MSG_No_Changes_HeadIndex"));
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_HEAD_VS_INDEX);
            this.modeKeeper.setMode(this.mode);
        } else {
            this.mode = FileInformation.Mode.INDEX_VS_WORKING_TREE;
            this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanelController.class, (String)"MSG_No_Changes_IndexWorking"));
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_INDEX_VS_WORKING);
            this.modeKeeper.setMode(this.mode);
        }
    }

    private void setDisplayStatuses(EnumSet<FileInformation.Status> displayStatuses) {
        this.displayStatuses = displayStatuses;
        this.refreshNodes();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final Object source = e.getSource();
        if (source == this.panel.tgbHeadVsIndex || source == this.panel.tgbHeadVsWorking || source == this.panel.tgbIndexVsWorking) {
            this.onDisplayedStatusChanged();
        } else if (source == this.panel.btnDiff) {
            this.modeKeeper.storeMode();
            ((DiffAction)SystemAction.get(DiffAction.class)).diff(this.context);
        } else if (source == this.panel.listButton) {
            this.setActiveComponent((FileViewComponent<GitStatusNodeImpl>)this.fileListComponent);
            this.fileListComponent.focus();
        } else if (source == this.panel.treeButton) {
            this.setActiveComponent((FileViewComponent<GitStatusNodeImpl>)this.fileTreeComponent);
            this.fileTreeComponent.focus();
        } else {
            Utils.postParallel((Runnable)new Runnable(){
                final /* synthetic */ VersioningPanelController this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (source == this.this$0.panel.btnRevert) {
                        ((RevertChangesAction)SystemAction.get(RevertChangesAction.class)).performAction(this.this$0.context);
                    } else if (source == this.this$0.panel.btnCommit) {
                        ((CommitAction.GitViewCommitAction)SystemAction.get(CommitAction.GitViewCommitAction.class)).performAction(this.this$0.context);
                    } else if (source == this.this$0.panel.btnRefresh) {
                        this.this$0.refreshStatusSupport = ((StatusAction)SystemAction.get(StatusAction.class)).scanStatus(this.this$0.context);
                        if (this.this$0.refreshStatusSupport != null) {
                            this.this$0.refreshStatusSupport.getTask().waitFinished();
                            if (!this.this$0.refreshStatusSupport.isCanceled()) {
                                this.this$0.refreshNodes();
                            }
                        }
                    }
                }
            }, (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChange(FileStatusCache.ChangedEvent event) {
        if (this.context != null) {
            Map<File, FileStatusCache.ChangedEvent> map = this.changes;
            synchronized (map) {
                this.changes.put(event.getFile(), event);
            }
            this.changeTask.schedule(1000);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("status.changed".equals(evt.getPropertyName())) {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)evt.getNewValue();
            if (this.affectsView((FileStatusCache.ChangedEvent)evt.getNewValue())) {
                this.applyChange(changedEvent);
            }
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.panel.repaint();
        }
    }

    private boolean affectsView(FileStatusCache.ChangedEvent changedEvent) {
        File file = changedEvent.getFile();
        FileInformation oldInfo = changedEvent.getOldInfo();
        FileInformation newInfo = changedEvent.getNewInfo();
        if (oldInfo == null ? !newInfo.containsStatus(this.displayStatuses) : !oldInfo.containsStatus(this.displayStatuses) && !newInfo.containsStatus(this.displayStatuses)) {
            return false;
        }
        return this.context == null ? false : GitUtils.contains(this.context.getRootFiles(), file);
    }

    private void initPanelMode() {
        this.mode = GitModuleConfig.getDefault().getLastUsedModificationContext();
        this.panel.tgbHeadVsWorking.setSelected(true);
        switch (this.mode) {
            case HEAD_VS_WORKING_TREE: {
                this.panel.tgbHeadVsWorking.setSelected(true);
                break;
            }
            case HEAD_VS_INDEX: {
                this.panel.tgbHeadVsIndex.setSelected(true);
                break;
            }
            case INDEX_VS_WORKING_TREE: {
                this.panel.tgbIndexVsWorking.setSelected(true);
            }
        }
        this.onDisplayedStatusChanged();
    }

    private void setVersioningComponent(final JComponent component) {
        Mutex.EVENT.readAccess(new Runnable(){
            final /* synthetic */ VersioningPanelController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Component[] children = this.this$0.panel.getComponents();
                for (int i = 0; i < children.length; ++i) {
                    Component child = children[i];
                    if (child == this.this$0.panel.jPanel2) continue;
                    if (child == component) {
                        return;
                    }
                    this.this$0.panel.remove(child);
                    break;
                }
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.gridwidth = 0;
                gbc.gridheight = 1;
                gbc.anchor = 23;
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                this.this$0.panel.add((Component)component, gbc);
                this.this$0.panel.revalidate();
                this.this$0.panel.repaint();
            }
        });
    }

    private void refreshNodes() {
        if (this.context != null) {
            this.refreshNodesTask.cancel();
            this.refreshNodesTask.schedule(0);
        }
    }

    private File[] toFiles(Node[] nodes) {
        ArrayList<File> files = new ArrayList<File>(nodes.length);
        for (Node n : nodes) {
            File f = (File)n.getLookup().lookup(File.class);
            if (f == null) continue;
            files.add(f);
        }
        return files.toArray(new File[0]);
    }

    private class RefreshNodesTask
    implements Runnable {
        private RefreshNodesTask() {
        }

        @Override
        public void run() {
            File[] interestingFiles;
            LinkedList<GitStatusNodeImpl> nodes = new LinkedList<GitStatusNodeImpl>();
            Git git = Git.getInstance();
            for (File f : interestingFiles = git.getFileStatusCache().listFiles(VersioningPanelController.this.context.getRootFiles(), VersioningPanelController.this.displayStatuses)) {
                File root = git.getRepositoryRoot(f);
                if (root == null) continue;
                if (f.equals(root)) {
                    File parentRepository;
                    File parentFile = f.getParentFile();
                    File file = parentRepository = parentFile == null ? null : git.getRepositoryRoot(parentFile);
                    if (parentRepository != null) {
                        root = parentRepository;
                    }
                }
                nodes.add(new GitStatusNodeImpl(new GitFileNode.GitLocalFileNode(root, f), VersioningPanelController.this.mode));
            }
            VCSStatusNode[] nodeArray = nodes.toArray(new GitStatusNodeImpl[0]);
            Object modelDataList = VersioningPanelController.this.fileListComponent.prepareModel((GitStatusNodeImpl[])nodeArray);
            Object modelDataTree = VersioningPanelController.this.fileTreeComponent.prepareModel(nodeArray);
            Mutex.EVENT.readAccess(new Runnable(){
                final /* synthetic */ GitStatusNodeImpl[] val$nodeArray;
                final /* synthetic */ Object val$modelDataList;
                final /* synthetic */ Object val$modelDataTree;
                final /* synthetic */ List val$nodes;
                final /* synthetic */ RefreshNodesTask this$1;
                {
                    this.val$nodeArray = gitStatusNodeImplArray;
                    this.val$modelDataList = object;
                    this.val$modelDataTree = object2;
                    this.val$nodes = list;
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.VersioningPanelController.this.fileListComponent.setModel(this.val$nodeArray, new EditorCookie[0], this.val$modelDataList);
                    this.this$1.VersioningPanelController.this.fileTreeComponent.setModel(this.val$nodeArray, new EditorCookie[0], this.val$modelDataTree);
                    if (this.val$nodes.isEmpty()) {
                        this.this$1.VersioningPanelController.this.setVersioningComponent((JComponent)this.this$1.VersioningPanelController.this.noContentComponent);
                        this.this$1.VersioningPanelController.this.noContentComponent.requestFocusInWindow();
                    } else {
                        this.this$1.VersioningPanelController.this.setVersioningComponent(this.this$1.VersioningPanelController.this.getActiveFileComponent().getComponent());
                        this.this$1.VersioningPanelController.this.getActiveFileComponent().focus();
                    }
                }
            });
        }
    }

    private class ApplyChangesTask
    implements Runnable {
        private ApplyChangesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<FileStatusCache.ChangedEvent> events;
            Map<File, FileStatusCache.ChangedEvent> map = VersioningPanelController.this.changes;
            synchronized (map) {
                events = new HashSet<FileStatusCache.ChangedEvent>(VersioningPanelController.this.changes.values());
                VersioningPanelController.this.changes.clear();
            }
            Iterator it = events.iterator();
            while (it.hasNext()) {
                FileStatusCache.ChangedEvent evt = (FileStatusCache.ChangedEvent)it.next();
                if (VersioningPanelController.this.affectsView(evt)) continue;
                it.remove();
            }
            Git git = Git.getInstance();
            Map nodes = (Map)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Map<File, GitStatusNodeImpl>>(){

                public Map<File, GitStatusNodeImpl> run() {
                    return VersioningPanelController.this.fileListComponent.getNodes();
                }
            });
            final LinkedList<GitStatusNodeImpl> toRemove = new LinkedList<GitStatusNodeImpl>();
            final LinkedList<GitStatusNodeImpl> toRefresh = new LinkedList<GitStatusNodeImpl>();
            final LinkedList<GitStatusNodeImpl> toAdd = new LinkedList<GitStatusNodeImpl>();
            for (FileStatusCache.ChangedEvent evt : events) {
                FileInformation newInfo = evt.getNewInfo();
                GitStatusNodeImpl node = (GitStatusNodeImpl)((Object)nodes.get(evt.getFile()));
                if (newInfo.containsStatus(VersioningPanelController.this.displayStatuses)) {
                    File parentRepository;
                    if (node != null) {
                        toRefresh.add(node);
                        continue;
                    }
                    File root = git.getRepositoryRoot(evt.getFile());
                    if (root == null) continue;
                    File parentFile = evt.getFile().getParentFile();
                    File file = parentRepository = parentFile == null ? null : git.getRepositoryRoot(parentFile);
                    if (parentRepository != null) {
                        root = parentRepository;
                    }
                    toAdd.add(new GitStatusNodeImpl(new GitFileNode.GitLocalFileNode(root, evt.getFile()), VersioningPanelController.this.mode));
                    continue;
                }
                if (node == null) continue;
                toRemove.add(node);
            }
            for (GitStatusNodeImpl n : toRemove) {
                nodes.remove(n.getFile());
            }
            for (GitStatusNodeImpl n : toAdd) {
                nodes.put(n.getFile(), n);
            }
            for (GitStatusNodeImpl n : toRefresh) {
                nodes.put(n.getFile(), n);
            }
            VCSStatusNode[] statusNodes = nodes.values().toArray(new GitStatusNodeImpl[nodes.size()]);
            Object modelDataTree = VersioningPanelController.this.fileTreeComponent.prepareModel(statusNodes);
            Mutex.EVENT.readAccess(new Runnable(){
                final /* synthetic */ GitStatusNodeImpl[] val$statusNodes;
                final /* synthetic */ Object val$modelDataTree;
                final /* synthetic */ ApplyChangesTask this$1;
                {
                    this.val$statusNodes = gitStatusNodeImplArray;
                    this.val$modelDataTree = object;
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.VersioningPanelController.this.fileListComponent.updateNodes(toRemove, toRefresh, toAdd);
                    this.this$1.VersioningPanelController.this.fileTreeComponent.setModel(this.val$statusNodes, new EditorCookie[0], this.val$modelDataTree);
                    if (this.this$1.VersioningPanelController.this.fileListComponent.getNodes().isEmpty()) {
                        this.this$1.VersioningPanelController.this.setVersioningComponent((JComponent)this.this$1.VersioningPanelController.this.noContentComponent);
                    } else {
                        this.this$1.VersioningPanelController.this.setVersioningComponent(this.this$1.VersioningPanelController.this.getActiveFileComponent().getComponent());
                    }
                }
            });
        }
    }

    static class ModeKeeper {
        private FileInformation.Mode selectedMode;

        private ModeKeeper() {
        }

        void storeMode() {
            GitModuleConfig.getDefault().setLastUsedModificationContext(this.selectedMode);
        }

        private void setMode(FileInformation.Mode mode) {
            this.selectedMode = mode;
            this.storeMode();
        }
    }

    static class GitStatusNodeImpl
    extends GitStatusNode<GitFileNode.GitLocalFileNode> {
        private final FileInformation.Mode mode;

        private GitStatusNodeImpl(GitFileNode.GitLocalFileNode gitLocalFileNode, FileInformation.Mode mode) {
            super(gitLocalFileNode, (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])gitLocalFileNode.getLookupObjects()), Lookups.fixed((Object[])new Object[]{gitLocalFileNode})}));
            this.mode = mode;
        }

        public Action getPreferredAction() {
            return this.getNodeAction();
        }

        public Action getNodeAction() {
            if (((GitFileNode.GitLocalFileNode)this.node).getInformation().containsStatus(FileInformation.Status.IN_CONFLICT)) {
                return SystemAction.get(ResolveConflictsAction.class);
            }
            return SystemAction.get(DiffAction.class);
        }

        @Override
        public String getStatusText() {
            return ((GitFileNode.GitLocalFileNode)this.node).getInformation().getStatusText(this.mode);
        }
    }
}

