/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadGroupReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ThreadsCache;
import org.openide.util.Exceptions;

public class JPDAThreadGroupImpl
implements JPDAThreadGroup {
    private ThreadGroupReference tgr;
    private JPDADebuggerImpl debugger;
    private String name;

    public JPDAThreadGroupImpl(ThreadGroupReference tgr, JPDADebuggerImpl debugger) {
        this.tgr = tgr;
        this.debugger = debugger;
        this.name = "";
        try {
            this.name = ThreadGroupReferenceWrapper.name(tgr);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            // empty catch block
        }
        debugger.interestedInThreadGroup(this);
    }

    public JPDAThreadGroupImpl getParentThreadGroup() {
        ThreadGroupReference ptgr = null;
        try {
            ptgr = ThreadGroupReferenceWrapper.parent(this.tgr);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        if (ptgr == null) {
            return null;
        }
        return (JPDAThreadGroupImpl)this.debugger.getThreadGroup(ptgr);
    }

    public JPDAThreadImpl[] getThreads() {
        ThreadsCache tc = this.debugger.getThreadsCache();
        if (tc == null) {
            return new JPDAThreadImpl[0];
        }
        List<ThreadReference> l = tc.getThreads(this.tgr);
        int k = l.size();
        JPDAThreadImpl[] ts = new JPDAThreadImpl[k];
        int i = 0;
        for (ThreadReference t : l) {
            JPDAThreadImpl thread = this.debugger.getThread(t);
            if (thread.getName().contains("org.netbeans.modules.debugger.jpda")) {
                ts = Arrays.copyOf(ts, k - 1);
                continue;
            }
            ts[i++] = thread;
        }
        return ts;
    }

    public JPDAThreadGroupImpl[] getThreadGroups() {
        ThreadsCache tc = this.debugger.getThreadsCache();
        if (tc == null) {
            return new JPDAThreadGroupImpl[0];
        }
        List<ThreadGroupReference> l = tc.getGroups(this.tgr);
        int k = l.size();
        JPDAThreadGroupImpl[] ts = new JPDAThreadGroupImpl[k];
        for (int i = 0; i < k; ++i) {
            ts[i] = (JPDAThreadGroupImpl)this.debugger.getThreadGroup(l.get(i));
        }
        return ts;
    }

    public String getName() {
        return this.name;
    }

    public void resume() {
        ThreadsCache tc = this.debugger.getThreadsCache();
        if (tc == null) {
            return;
        }
        this.notifyToBeResumed(tc);
        try {
            ThreadGroupReferenceWrapper.resume(this.tgr);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void suspend() {
        ThreadsCache tc = this.debugger.getThreadsCache();
        if (tc == null) {
            return;
        }
        try {
            ThreadGroupReferenceWrapper.suspend(this.tgr);
        }
        catch (InternalExceptionWrapper ex) {
            return;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        this.notifySuspended(tc);
    }

    void notifyToBeResumed(ThreadsCache tc) {
        List<ThreadReference> threads = tc.getThreads(this.tgr);
        for (ThreadReference threadRef : threads) {
            JPDAThreadImpl thread = this.debugger.getThread(threadRef);
            thread.notifyToBeResumed();
        }
        List<ThreadGroupReference> groups = tc.getGroups(this.tgr);
        for (ThreadGroupReference groupRef : groups) {
            JPDAThreadGroupImpl group = (JPDAThreadGroupImpl)this.debugger.getThreadGroup(groupRef);
            group.notifyToBeResumed(tc);
        }
    }

    void notifySuspended(ThreadsCache tc) {
        List<ThreadReference> threads = tc.getThreads(this.tgr);
        for (ThreadReference threadRef : threads) {
            JPDAThreadImpl thread = this.debugger.getThread(threadRef);
            thread.notifySuspended();
        }
        List<ThreadGroupReference> groups = tc.getGroups(this.tgr);
        for (ThreadGroupReference groupRef : groups) {
            JPDAThreadGroupImpl group = (JPDAThreadGroupImpl)this.debugger.getThreadGroup(groupRef);
            group.notifySuspended(tc);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "] @" + Integer.toHexString(this.hashCode());
    }
}

